/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli;

import java.lang.reflect.InvocationTargetException;
import org.wildfly.glow.cli.commands.AbstractCommand;
import picocli.CommandLine;

public class ExecutionExceptionHandler
implements CommandLine.IExecutionExceptionHandler {
    private final AbstractCommand command;
    private final boolean isVerbose;

    public ExecutionExceptionHandler(boolean isVerbose, AbstractCommand command) {
        this.isVerbose = isVerbose;
        this.command = command;
    }

    @Override
    public int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult parseResult) throws Exception {
        String msg = ex.getLocalizedMessage();
        if (ex instanceof InvocationTargetException) {
            msg = ex.getCause().getLocalizedMessage();
        }
        this.command.printError("ERROR: %s", msg);
        if (this.isVerbose) {
            ex.printStackTrace(this.command.getStderr());
        }
        return 1;
    }
}

