/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.wildfly.glow.Layer;
import org.wildfly.glow.error.Fix;

public class AddOn
implements Comparable<AddOn> {
    private final String name;
    private final String family;
    private final String description;
    private final Set<Layer> layersAlwaysIncluded = new TreeSet<Layer>();
    private final Set<Layer> layers = new TreeSet<Layer>();
    private final Set<Layer> layersThatExpectAllDependencies = new TreeSet<Layer>();
    private final Map<Layer, Set<Layer>> layersThatExpectSomeDependencies = new HashMap<Layer, Set<Layer>>();
    private final Map<String, Fix> fixes = new HashMap<String, Fix>();
    private final boolean isDefault;
    private final String associatedNonDefault;

    AddOn(String name, String family, String description) {
        this.name = name;
        this.family = family;
        this.description = description;
        this.isDefault = name.endsWith(":default");
        if (this.isDefault) {
            int i = name.lastIndexOf(":");
            this.associatedNonDefault = name.substring(0, i);
        } else {
            this.associatedNonDefault = name;
        }
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getAssociatedNonDefault() {
        return this.associatedNonDefault;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getFamily() {
        return this.family;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Layer> getLayers() {
        return this.layers;
    }

    public Map<String, Fix> getFixes() {
        return this.fixes;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.name);
        hash = 59 * hash + Objects.hashCode(this.family);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddOn other = (AddOn)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.family, other.family);
    }

    public Set<Layer> getLayersThatExpectAllDependencies() {
        return this.layersThatExpectAllDependencies;
    }

    public Map<Layer, Set<Layer>> getLayersThatExpectSomeDependencies() {
        return this.layersThatExpectSomeDependencies;
    }

    @Override
    public int compareTo(AddOn t) {
        return this.name.compareTo(t.name);
    }

    public Set<Layer> getLayersAlwaysIncluded() {
        return this.layersAlwaysIncluded;
    }
}

