/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.support;

import java.util.Collections;
import java.util.Set;
import org.wildfly.glow.ConfigurationResolver;
import org.wildfly.glow.Env;
import org.wildfly.glow.Layer;
import org.wildfly.glow.deployment.openshift.api.OpenShiftSupport;

public class CLIConfigurationResolver
implements ConfigurationResolver {
    private final Set<String> disabledDeployers;
    private final boolean isOpenShift;

    public CLIConfigurationResolver() {
        this(true, null);
    }

    public CLIConfigurationResolver(boolean isOpenShift, Set<String> disabledDeployers) {
        this.disabledDeployers = disabledDeployers == null ? Collections.emptySet() : disabledDeployers;
        this.isOpenShift = isOpenShift;
    }

    @Override
    public ConfigurationResolver.ResolvedEnvs getResolvedEnvs(Layer layer, Set<Env> input) throws Exception {
        if (this.isOpenShift) {
            return OpenShiftSupport.getResolvedEnvs(layer, input, this.disabledDeployers);
        }
        return null;
    }

    @Override
    public String getPossibleDeployer(Set<Layer> layers) throws Exception {
        return OpenShiftSupport.getPossibleDeployer(layers, this.disabledDeployers);
    }
}

