/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.Path;
import java.util.Optional;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GlowSession;
import org.wildfly.glow.ScanArguments;
import org.wildfly.glow.cli.support.AbstractCommand;
import org.wildfly.glow.maven.MavenResolver;
import picocli.CommandLine;

@CommandLine.Command(name="go-offline", sortOptions=true)
public class GoOfflineCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;

    @Override
    public Integer call() throws Exception {
        this.print("Wildfly Glow is assembling offline content...");
        ScanArguments.Builder builder = Arguments.scanBuilder();
        if (this.cloud.orElse(false).booleanValue()) {
            builder.setExecutionContext("cloud");
        }
        if (this.wildflyPreview.orElse(false).booleanValue()) {
            builder.setTechPreview(true);
        }
        if (this.wildflyServerVersion.isPresent()) {
            builder.setVersion(this.wildflyServerVersion.get());
        }
        builder.setVerbose(this.verbose);
        if (this.provisioningXml.isPresent()) {
            builder.setProvisoningXML(this.provisioningXml.get());
        }
        GlowSession.goOffline(MavenResolver.newMavenResolver(), builder.build(), GlowMessageWriter.DEFAULT);
        this.print("Offline zip file %s generated", GlowSession.OFFLINE_ZIP);
        return 0;
    }
}

