/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.Path;
import java.util.Optional;
import org.wildfly.glow.cli.support.AbstractCommand;
import org.wildfly.glow.cli.support.Utils;
import picocli.CommandLine;

@CommandLine.Command(name="show-add-ons", sortOptions=true)
public class ShowAddOnsCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;
    @CommandLine.Option(names={"-cc", "--channels"}, paramLabel="<Channels yaml file path>")
    Optional<Path> channelsFile;

    @Override
    public Integer call() throws Exception {
        this.print("Wildfly Glow is retrieving add-ons...");
        String context = "bare-metal";
        if (this.cloud.orElse(false).booleanValue()) {
            context = "cloud";
        }
        if (this.wildflyPreview.orElse(false).booleanValue() && this.channelsFile.isPresent()) {
            throw new Exception("--wildfly-previewcan't be set when --channels is set.");
        }
        if (this.wildflyServerVersion.isPresent() && this.channelsFile.isPresent()) {
            throw new Exception("--server-versioncan't be set when --channels is set.");
        }
        Utils.showAddOns(this, context, this.provisioningXml.orElse(null), this.wildflyServerVersion.isEmpty(), this.wildflyServerVersion.orElse(null), this.wildflyPreview.orElse(false), this.channelsFile.orElse(null));
        return 0;
    }
}

