/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;

class HttpUrlConnection
extends URLConnection {
    private HttpClient client;
    private HttpHost host;
    private HttpRequest request;
    private boolean connected;
    private HttpResponse response = null;
    private final ReentrantLock connectionLock = new ReentrantLock();

    public HttpUrlConnection(URL url, HttpClient client, HttpHost host, HttpRequest request) {
        super(url);
        this.client = client;
        this.host = host;
        this.request = request;
    }

    private void lock() {
        this.connectionLock.lock();
    }

    private void unlock() {
        this.connectionLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        this.lock();
        try {
            if (this.connected) {
                return;
            }
            for (Map.Entry<String, List<String>> header : this.getRequestProperties().entrySet()) {
                for (String value : header.getValue()) {
                    this.request.addHeader(header.getKey(), value);
                }
            }
            this.response = this.client.execute(this.host, this.request);
            int statusCode = this.response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                this.response.getEntity().getContent().transferTo(outputStream);
                String errorMessage = ((Object)outputStream).toString();
                throw new IOException("Fail to get " + this.url + ": " + this.response.getStatusLine() + "\n" + errorMessage);
            }
            this.connected = true;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.response.getEntity().getContent();
    }
}

