/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.support;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.ProvisioningUtils;
import org.wildfly.glow.cli.support.AbstractCommand;
import org.wildfly.glow.cli.support.CLIConfigurationResolver;
import org.wildfly.glow.maven.MavenResolver;

public class Utils {
    public static void showAddOns(final AbstractCommand cmd, String context, Path provisioningXml, boolean isLatest, String serverVersion, boolean isPreview, Path channelsFile) throws Exception {
        final CLIConfigurationResolver resolver = new CLIConfigurationResolver();
        ProvisioningUtils.ProvisioningConsumer consumer = new ProvisioningUtils.ProvisioningConsumer(){

            @Override
            public void consume(GalleonProvisioningConfig provisioning, Map<String, Layer> all, LayerMapping mapping, Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies) throws Exception {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<String, Set<AddOn>> entry : mapping.getAddOnFamilyMembers().entrySet()) {
                    builder.append("* @|bold ").append(entry.getKey()).append("|@ add-ons:%n");
                    for (AddOn member : mapping.getAddOnFamilyMembers().get(entry.getKey())) {
                        if (member.getName().endsWith(":default")) continue;
                        String deployer = resolver.getPossibleDeployer(member.getLayers());
                        builder.append(" - ").append(member.getName()).append((String)(deployer == null ? "" : " @|bold (supported by " + deployer + " deployer)|@")).append((String)(member.getDescription() == null ? "" : ": " + member.getDescription())).append("%n");
                    }
                }
                cmd.print(builder.toString());
                cmd.print("@|bold Add-ons can be set using the|@ @|fg(yellow) %s=<list of add-ons>|@ @|bold option of the|@ @|fg(yellow) %s|@ @|bold command|@", "--add-ons", "scan");
            }
        };
        ProvisioningUtils.traverseProvisioning(consumer, context, provisioningXml, isLatest, serverVersion, isPreview, MavenResolver.buildMavenResolver(channelsFile));
    }

    public static void setSystemProperties(Set<String> systemProperties) throws Exception {
        if (!systemProperties.isEmpty()) {
            for (String p : systemProperties) {
                if (p.startsWith("-D")) {
                    String propName;
                    int i = p.indexOf("=");
                    String value = "";
                    if (i > 0) {
                        propName = p.substring(2, i);
                        value = p.substring(i + 1);
                    } else {
                        propName = p.substring(2);
                    }
                    System.setProperty(propName, value);
                    continue;
                }
                throw new Exception("Invalid system property " + p + ". A property must start with -D");
            }
        }
    }

    public static Map<String, String> handleOpenShiftEnvFile(Path envFile) throws Exception {
        HashMap<String, String> extraEnv = new HashMap<String, String>();
        if (!Files.exists(envFile, new LinkOption[0])) {
            throw new Exception(envFile + " file doesn't exist");
        }
        for (String l : Files.readAllLines(envFile)) {
            if ((l = l.trim()).isEmpty() || l.startsWith("#")) continue;
            int i = l.indexOf("=");
            if (i < 0 || i == l.length() - 1) {
                throw new Exception("Invalid environment variable " + l + " in " + envFile);
            }
            extraEnv.put(l.substring(0, i), l.substring(i + 1));
        }
        return extraEnv;
    }
}

