/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.ProvisioningUtils;
import org.wildfly.glow.cli.support.AbstractCommand;
import org.wildfly.glow.deployment.openshift.api.Deployer;
import org.wildfly.glow.maven.MavenResolver;
import picocli.CommandLine;

@CommandLine.Command(name="show-configuration", sortOptions=true)
public class ShowConfigurationCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;
    @CommandLine.Option(names={"-cc", "--channels"}, paramLabel="<Channels yaml file path>")
    Optional<Path> channelsFile;

    @Override
    public Integer call() throws Exception {
        this.print("Wildfly Glow is retrieving known provisioning configuration...");
        StringBuilder ocBuilder = new StringBuilder();
        ocBuilder.append("\nDeployers enabled when provisioning to OpenShift:\n");
        for (Deployer d : ServiceLoader.load(Deployer.class)) {
            ocBuilder.append("* @|bold " + d.getName() + "|@. Enabled when the layer(s) " + d.getSupportedLayers() + " is/are discovered.\n");
        }
        this.print(ocBuilder.toString());
        String context = "bare-metal";
        if (this.cloud.orElse(false).booleanValue()) {
            context = "cloud";
        }
        if (this.wildflyPreview.orElse(false).booleanValue() && this.channelsFile.isPresent()) {
            throw new Exception("--wildfly-previewcan't be set when --channels is set.");
        }
        if (this.wildflyServerVersion.isPresent() && this.channelsFile.isPresent()) {
            throw new Exception("--server-versioncan't be set when --channels is set.");
        }
        final String finalContext = context;
        final boolean isLatest = this.wildflyServerVersion.isEmpty();
        final String vers = this.wildflyServerVersion.isPresent() ? this.wildflyServerVersion.get() : FeaturePacks.getLatestVersion();
        ProvisioningUtils.ProvisioningConsumer consumer = new ProvisioningUtils.ProvisioningConsumer(){

            @Override
            public void consume(GalleonProvisioningConfig provisioning, Map<String, Layer> all, LayerMapping mapping, Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies) throws Exception {
                String configStr = ShowConfigurationCommand.dumpConfiguration(fpDependencies, finalContext, vers, all, mapping, provisioning, isLatest, ShowConfigurationCommand.this.wildflyPreview.orElse(false), ShowConfigurationCommand.this.provisioningXml.orElse(null));
                ShowConfigurationCommand.this.print(configStr);
            }
        };
        ProvisioningUtils.traverseProvisioning(consumer, context, this.provisioningXml.orElse(null), this.wildflyServerVersion.isEmpty(), vers, this.wildflyPreview.orElse(false), MavenResolver.buildMavenResolver(this.channelsFile.orElse(null)));
        return 0;
    }

    private static String dumpConfiguration(Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies, String context, String serverVersion, Map<String, Layer> allLayers, LayerMapping mapping, GalleonProvisioningConfig config, boolean isLatest, boolean techPreview, Path provisioningXml) throws Exception {
        StringBuilder builder = new StringBuilder();
        if (provisioningXml == null) {
            builder.append("Execution context: ").append(context).append("\n");
            builder.append("Server version: ").append(serverVersion).append(isLatest ? " (latest)" : "").append("\n");
            builder.append("Tech Preview: ").append(techPreview).append("\n");
        } else {
            builder.append("Input provisioning.xml file: ").append(provisioningXml).append("\n");
        }
        LinkedHashSet<FeaturePackLocation.ProducerSpec> topLevel = new LinkedHashSet<FeaturePackLocation.ProducerSpec>();
        LinkedHashMap<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID> featurepacks = new LinkedHashMap<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID>();
        block0: for (GalleonFeaturePackConfig fp : config.getFeaturePackDeps()) {
            topLevel.add(fp.getLocation().getProducer());
            for (FeaturePackLocation.FPID fpid : fpDependencies.keySet()) {
                if (!fpid.getProducer().equals(fp.getLocation().getProducer())) continue;
                featurepacks.put(fp.getLocation().getProducer(), fpid);
                continue block0;
            }
        }
        for (FeaturePackLocation.ProducerSpec p : featurepacks.keySet()) {
            FeaturePackLocation.FPID id = (FeaturePackLocation.FPID)featurepacks.get(p);
            builder.append("\nFeature-pack: ").append("@|bold ").append(id).append("|@\n");
            builder.append("Contained layers: ");
            TreeSet<String> layers = new TreeSet<String>();
            Set<FeaturePackLocation.ProducerSpec> deps = fpDependencies.get(id);
            for (Layer l : allLayers.values()) {
                if (l.getFeaturePacks().contains(id)) {
                    layers.add(l.getName());
                }
                if (deps == null) continue;
                for (FeaturePackLocation.ProducerSpec dep : deps) {
                    if (topLevel.contains(dep)) continue;
                    for (FeaturePackLocation.FPID fpid : l.getFeaturePacks()) {
                        if (!fpid.getProducer().equals(dep)) continue;
                        layers.add(l.getName());
                    }
                }
            }
            topLevel.addAll(deps);
            builder.append(layers).append("\n");
        }
        return builder.toString();
    }
}

