/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.Format;
import com.networknt.schema.FormatKeyword;
import com.networknt.schema.InvalidSchemaException;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.Keyword;
import com.networknt.schema.KeywordFactory;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.UnknownKeywordFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.Version201909;
import com.networknt.schema.Version202012;
import com.networknt.schema.Version4;
import com.networknt.schema.Version6;
import com.networknt.schema.Version7;
import com.networknt.schema.Vocabularies;
import com.networknt.schema.Vocabulary;
import com.networknt.schema.VocabularyFactory;
import com.networknt.schema.utils.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMetaSchema {
    private static final Logger logger = LoggerFactory.getLogger(JsonMetaSchema.class);
    private final String iri;
    private final String idKeyword;
    private final Map<String, Keyword> keywords;
    private final Map<String, Boolean> vocabularies;
    private final SpecVersion.VersionFlag specification;
    private final Builder builder;

    JsonMetaSchema(String iri, String idKeyword, Map<String, Keyword> keywords, Map<String, Boolean> vocabularies, SpecVersion.VersionFlag specification, Builder builder) {
        if (StringUtils.isBlank(iri)) {
            throw new IllegalArgumentException("iri must not be null or blank");
        }
        if (StringUtils.isBlank(idKeyword)) {
            throw new IllegalArgumentException("idKeyword must not be null or blank");
        }
        if (keywords == null) {
            throw new IllegalArgumentException("keywords must not be null ");
        }
        this.iri = iri;
        this.idKeyword = idKeyword;
        this.keywords = keywords;
        this.specification = specification;
        this.vocabularies = vocabularies;
        this.builder = builder;
    }

    public static JsonMetaSchema getV4() {
        return new Version4().getInstance();
    }

    public static JsonMetaSchema getV6() {
        return new Version6().getInstance();
    }

    public static JsonMetaSchema getV7() {
        return new Version7().getInstance();
    }

    public static JsonMetaSchema getV201909() {
        return new Version201909().getInstance();
    }

    public static JsonMetaSchema getV202012() {
        return new Version202012().getInstance();
    }

    public static Builder builder(String iri) {
        return new Builder(iri);
    }

    public static Builder builder(String iri, JsonMetaSchema blueprint) {
        Builder builder = JsonMetaSchema.builder(blueprint);
        builder.iri = iri;
        return builder;
    }

    public static Builder builder(JsonMetaSchema blueprint) {
        HashMap<String, Boolean> vocabularies = new HashMap<String, Boolean>(blueprint.getVocabularies());
        return JsonMetaSchema.builder(blueprint.getIri()).idKeyword(blueprint.idKeyword).keywords(blueprint.builder.keywords.values()).formats(blueprint.builder.formats.values()).specification(blueprint.getSpecification()).vocabularies(vocabularies).vocabularyFactory(blueprint.builder.vocabularyFactory).formatKeywordFactory(blueprint.builder.formatKeywordFactory).unknownKeywordFactory(blueprint.builder.unknownKeywordFactory);
    }

    public String getIdKeyword() {
        return this.idKeyword;
    }

    public String readId(JsonNode schemaNode) {
        return JsonMetaSchema.readText(schemaNode, this.idKeyword);
    }

    public String readAnchor(JsonNode schemaNode) {
        boolean supportsAnchor = this.keywords.containsKey("$anchor");
        if (supportsAnchor) {
            return JsonMetaSchema.readText(schemaNode, "$anchor");
        }
        return null;
    }

    public String readDynamicAnchor(JsonNode schemaNode) {
        boolean supportsDynamicAnchor = this.keywords.containsKey("$dynamicAnchor");
        if (supportsDynamicAnchor) {
            return JsonMetaSchema.readText(schemaNode, "$dynamicAnchor");
        }
        return null;
    }

    private static String readText(JsonNode node, String field) {
        JsonNode idNode = node.get(field);
        if (idNode == null || !idNode.isTextual()) {
            return null;
        }
        return idNode.textValue();
    }

    public String getIri() {
        return this.iri;
    }

    public Map<String, Keyword> getKeywords() {
        return this.keywords;
    }

    public Map<String, Boolean> getVocabularies() {
        return this.vocabularies;
    }

    public SpecVersion.VersionFlag getSpecification() {
        return this.specification;
    }

    public JsonValidator newValidator(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, String keyword, JsonNode schemaNode, JsonSchema parentSchema) {
        try {
            Keyword kw = this.keywords.get(keyword);
            if (kw == null) {
                if ("message".equals(keyword) && validationContext.getConfig().isCustomMessageSupported()) {
                    return null;
                }
                if (ValidatorTypeCode.DISCRIMINATOR.getValue().equals(keyword) && validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
                    return ValidatorTypeCode.DISCRIMINATOR.newValidator(schemaLocation, evaluationPath, schemaNode, parentSchema, validationContext);
                }
                Keyword keyword2 = kw = this.builder.unknownKeywordFactory != null ? this.builder.unknownKeywordFactory.getKeyword(keyword, validationContext) : UnknownKeywordFactory.getInstance().getKeyword(keyword, validationContext);
                if (kw == null) {
                    return null;
                }
            }
            return kw.newValidator(schemaLocation, evaluationPath, schemaNode, parentSchema, validationContext);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof JsonSchemaException) {
                logger.error("Error:", e);
                throw (JsonSchemaException)e.getTargetException();
            }
            logger.warn("Could not load validator {}", (Object)keyword);
            throw new JsonSchemaException(e.getTargetException());
        }
        catch (JsonSchemaException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("Could not load validator {}", (Object)keyword);
            throw new JsonSchemaException(e);
        }
    }

    public String toString() {
        return this.iri;
    }

    public int hashCode() {
        return Objects.hash(this.iri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonMetaSchema other = (JsonMetaSchema)obj;
        return Objects.equals(this.iri, other.iri);
    }

    public static class Builder {
        private String iri;
        private String idKeyword = "$id";
        private SpecVersion.VersionFlag specification = null;
        private Map<String, Keyword> keywords = new HashMap<String, Keyword>();
        private Map<String, Format> formats = new HashMap<String, Format>();
        private Map<String, Boolean> vocabularies = new HashMap<String, Boolean>();
        private FormatKeywordFactory formatKeywordFactory = null;
        private VocabularyFactory vocabularyFactory = null;
        private KeywordFactory unknownKeywordFactory = null;

        public Builder(String iri) {
            this.iri = iri;
        }

        private Map<String, Keyword> createKeywordsMap(Map<String, Keyword> kwords, Map<String, Format> formats) {
            boolean formatKeywordPresent = false;
            HashMap<String, Keyword> map = new HashMap<String, Keyword>();
            for (Map.Entry<String, Keyword> type : kwords.entrySet()) {
                String keywordName = type.getKey();
                Keyword keyword = type.getValue();
                if (ValidatorTypeCode.FORMAT.getValue().equals(keywordName)) {
                    if (!(keyword instanceof FormatKeyword) && !ValidatorTypeCode.FORMAT.equals(keyword)) {
                        throw new IllegalArgumentException("Overriding the keyword 'format' is not supported. Use the formatKeywordFactory and extend the FormatKeyword.");
                    }
                    formatKeywordPresent = true;
                    continue;
                }
                map.put(keyword.getValue(), keyword);
            }
            if (formatKeywordPresent) {
                FormatKeyword formatKeyword = this.formatKeywordFactory != null ? this.formatKeywordFactory.newInstance(formats) : new FormatKeyword(formats);
                map.put(formatKeyword.getValue(), formatKeyword);
            }
            return map;
        }

        public Builder formatKeywordFactory(FormatKeywordFactory formatKeywordFactory) {
            this.formatKeywordFactory = formatKeywordFactory;
            return this;
        }

        public Builder vocabularyFactory(VocabularyFactory vocabularyFactory) {
            this.vocabularyFactory = vocabularyFactory;
            return this;
        }

        public Builder unknownKeywordFactory(KeywordFactory unknownKeywordFactory) {
            this.unknownKeywordFactory = unknownKeywordFactory;
            return this;
        }

        public Builder formats(Consumer<Map<String, Format>> customizer) {
            customizer.accept(this.formats);
            return this;
        }

        public Builder keywords(Consumer<Map<String, Keyword>> customizer) {
            customizer.accept(this.keywords);
            return this;
        }

        public Builder keyword(Keyword keyword) {
            this.keywords.put(keyword.getValue(), keyword);
            return this;
        }

        public Builder keywords(Collection<? extends Keyword> keywords) {
            for (Keyword keyword : keywords) {
                this.keywords.put(keyword.getValue(), keyword);
            }
            return this;
        }

        public Builder format(Format format) {
            this.formats.put(format.getName(), format);
            return this;
        }

        public Builder formats(Collection<? extends Format> formats) {
            for (Format format : formats) {
                this.format(format);
            }
            return this;
        }

        public Builder vocabulary(String vocabulary) {
            return this.vocabulary(vocabulary, true);
        }

        public Builder vocabulary(String vocabulary, boolean required) {
            this.vocabularies.put(vocabulary, required);
            return this;
        }

        public Builder vocabularies(Map<String, Boolean> vocabularies) {
            this.vocabularies.putAll(vocabularies);
            return this;
        }

        public Builder vocabularies(Consumer<Map<String, Boolean>> customizer) {
            customizer.accept(this.vocabularies);
            return this;
        }

        public Builder specification(SpecVersion.VersionFlag specification) {
            this.specification = specification;
            return this;
        }

        public Builder idKeyword(String idKeyword) {
            this.idKeyword = idKeyword;
            return this;
        }

        public JsonMetaSchema build() {
            Map<String, Keyword> keywords = this.keywords;
            if (this.specification != null && this.specification.getVersionFlagValue() >= SpecVersion.VersionFlag.V201909.getVersionFlagValue()) {
                keywords = new HashMap<String, Keyword>(this.keywords);
                for (Map.Entry<String, Boolean> entry : this.vocabularies.entrySet()) {
                    Vocabulary vocabulary = null;
                    String id = entry.getKey();
                    if (this.vocabularyFactory != null) {
                        vocabulary = this.vocabularyFactory.getVocabulary(id);
                    }
                    if (vocabulary == null) {
                        vocabulary = Vocabularies.getVocabulary(id);
                    }
                    if (vocabulary != null) {
                        for (Keyword keyword : vocabulary.getKeywords()) {
                            keywords.put(keyword.getValue(), keyword);
                        }
                        continue;
                    }
                    if (!Boolean.TRUE.equals(entry.getValue())) continue;
                    ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().message("Meta-schema ''{1}'' has unknown required vocabulary ''{2}''")).arguments(this.iri, id)).build();
                    throw new InvalidSchemaException(validationMessage);
                }
            }
            Map<String, Keyword> result = this.createKeywordsMap(keywords, this.formats);
            return new JsonMetaSchema(this.iri, this.idKeyword, result, this.vocabularies, this.specification, this);
        }

        @Deprecated
        public Builder addKeyword(Keyword keyword) {
            return this.keyword(keyword);
        }

        @Deprecated
        public Builder addKeywords(Collection<? extends Keyword> keywords) {
            return this.keywords(keywords);
        }

        @Deprecated
        public Builder addFormat(Format format) {
            return this.format(format);
        }

        @Deprecated
        public Builder addFormats(Collection<? extends Format> formats) {
            return this.formats(formats);
        }
    }

    public static interface FormatKeywordFactory {
        public FormatKeyword newInstance(Map<String, Format> var1);
    }
}

