/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.deployment.openshift.api;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.DockerBuildStrategyFluent;
import io.fabric8.openshift.api.model.ImageLookupPolicy;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourceBuilder;
import io.fabric8.openshift.api.model.ImageSourcePath;
import io.fabric8.openshift.api.model.ImageSourcePathBuilder;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteTargetReference;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.api.model.TLSConfig;
import io.fabric8.openshift.api.model.TLSConfigBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.glow.ConfigurationResolver;
import org.wildfly.glow.Env;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.Layer;
import org.wildfly.glow.ScanResults;
import org.wildfly.glow.deployment.openshift.api.Deployer;
import org.wildfly.glow.deployment.openshift.api.OpenShiftConfiguration;
import org.wildfly.glow.deployment.openshift.api.Utils;

public class OpenShiftSupport {
    private static final String DEPLOYMENT_RESOURCE_DIR = "deployment";
    private static final String BUILD_RESOURCE_DIR = "build";
    private static final String IMAGES_RESOURCE_DIR = "images";
    private static final String DEPLOYMENTS_DIR = "deployments";
    private static final String DOCKER_DIR = "docker";
    private static final String EXTENSIONS_DIR = "extensions";
    private static final String TMP_DIR = "tmp";
    private static final String DOCKER_SERVER_DIR = "server";
    private static final String DOCKER_APP_DIR = "app";
    private static final String DEPLOYERS_RESOURCE_DIR = "deployers";
    private static final String RESOURCES_DIR = "resources";
    private static final String WILDFLY_GLOW_SERVER_IMAGE_REPOSITORY = "WILDFLY_GLOW_SERVER_IMAGE_REPOSITORY";
    private static final String WILDFLY_GLOW_APP_IMAGE_REPOSITORY = "WILDFLY_GLOW_APP_IMAGE_REPOSITORY";
    private static final String IMAGE_PROPERTIES_FILE = "images.properties";

    public static Path getDeploymentDirectory(Path target) throws IOException {
        return OpenShiftSupport.createResourcesDirectory(target, DEPLOYMENT_RESOURCE_DIR);
    }

    public static Path getBuildDirectory(Path target) throws IOException {
        return OpenShiftSupport.createResourcesDirectory(target, BUILD_RESOURCE_DIR);
    }

    public static Path getImagesDirectory(Path target) throws IOException {
        return OpenShiftSupport.createResourcesDirectory(target, IMAGES_RESOURCE_DIR);
    }

    public static Path getDockerServerDirectory(Path target) throws IOException {
        return OpenShiftSupport.createDockerDirectory(target, DOCKER_SERVER_DIR);
    }

    public static Path getDockerAppDirectory(Path target) throws IOException {
        return OpenShiftSupport.createDockerDirectory(target, DOCKER_APP_DIR);
    }

    public static Path getExtensionsDirectory(Path target) throws IOException {
        Path ext = OpenShiftSupport.createDockerDirectory(target, DOCKER_APP_DIR).resolve(EXTENSIONS_DIR);
        Files.createDirectories(ext, new FileAttribute[0]);
        return ext;
    }

    public static Path getDeploymentsDirectory(Path target) throws IOException {
        Path deps = OpenShiftSupport.createDockerDirectory(target, DOCKER_APP_DIR).resolve(DEPLOYMENTS_DIR);
        Files.createDirectories(deps, new FileAttribute[0]);
        return deps;
    }

    public static Path getDockerDirectory(Path target) throws IOException {
        Path dir = target.resolve(DOCKER_DIR);
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir;
    }

    public static Path getTmpDirectory(Path target) throws IOException {
        Path dir = target.resolve(TMP_DIR);
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir;
    }

    public static Path getDeployersDirectory(Path target) throws IOException {
        return OpenShiftSupport.createResourcesDirectory(target, DEPLOYERS_RESOURCE_DIR);
    }

    private static Path createResourcesDirectory(Path path, String name) throws IOException {
        Path dir = OpenShiftSupport.getResourcesDirectory(path).resolve(name);
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir;
    }

    private static Path getResourcesDirectory(Path path) throws IOException {
        Path dir = path.resolve(RESOURCES_DIR);
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir;
    }

    private static Path createDockerDirectory(Path path, String name) throws IOException {
        Path dir = OpenShiftSupport.getDockerDirectory(path).resolve(name);
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir;
    }

    private static void createAppDeployment(GlowMessageWriter writer, Path target, OpenShiftClient osClient, String appName, Map<String, String> env, boolean ha, OpenShiftConfiguration config, String deploymentKind, String appImageTag) throws Exception {
        HashMap<String, String> matchLabels = new HashMap<String, String>();
        matchLabels.put(DEPLOYMENT_RESOURCE_DIR, appName);
        IntOrString value = new IntOrString();
        value.setValue(8080);
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withLabels(OpenShiftSupport.createCommonLabels(config))).withName(appName)).endMetadata()).withNewSpec().withPorts(((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePort().toBuilder().withProtocol("TCP")).withPort(8080)).withTargetPort(value)).build())).withType("ClusterIP")).withSessionAffinity("None")).withSelector(matchLabels)).endSpec()).build();
        if (osClient != null) {
            ((ServiceResource)osClient.services().resource(service)).createOr(Updatable::update);
        }
        Utils.persistResource(OpenShiftSupport.getDeploymentDirectory(target), service, appName + "-service.yaml");
        ContainerPort port = new ContainerPort();
        port.setContainerPort(8080);
        port.setName("http");
        port.setProtocol("TCP");
        ContainerPort portAdmin = new ContainerPort();
        portAdmin.setContainerPort(9990);
        portAdmin.setName("admin");
        portAdmin.setProtocol("TCP");
        ArrayList<ContainerPort> ports = new ArrayList<ContainerPort>();
        ports.add(port);
        ports.add(portAdmin);
        ArrayList<EnvVar> vars = new ArrayList<EnvVar>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName(entry.getKey())).withValue(entry.getValue())).build());
        }
        if (ha) {
            writer.info("\nHA enabled, 2 replicas will be started.");
            IntOrString v = new IntOrString();
            v.setValue(8888);
            Service pingService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withLabels(OpenShiftSupport.createCommonLabels(config))).withName(appName + "-ping")).endMetadata()).withNewSpec().withPorts(((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePort().toBuilder().withProtocol("TCP")).withPort(8888)).withName("ping")).withTargetPort(v)).build())).withClusterIP("None")).withPublishNotReadyAddresses()).withIpFamilies("IPv4")).withInternalTrafficPolicy("Cluster")).withClusterIPs("None")).withType("ClusterIP")).withIpFamilyPolicy("SingleStack")).withSessionAffinity("None")).withSelector(matchLabels)).endSpec()).build();
            if (osClient != null) {
                ((ServiceResource)osClient.services().resource(pingService)).createOr(Updatable::update);
            }
            Utils.persistResource(OpenShiftSupport.getDeploymentDirectory(target), pingService, appName + "-ping-service.yaml");
        }
        Container container = new Container();
        container.setName(appName);
        String imageName = osClient == null ? "WILDFLY_GLOW_APP_IMAGE_REPOSITORY:" + appImageTag : appName + ":latest";
        container.setImage(imageName);
        container.setPorts(ports);
        container.setEnv(vars);
        container.setImagePullPolicy("IfNotPresent");
        Probe readinessProbe = new Probe();
        HTTPGetAction getAction = new HTTPGetAction();
        getAction.setPath("/health/ready");
        IntOrString pp = new IntOrString("admin");
        getAction.setPort(pp);
        getAction.setScheme("HTTP");
        readinessProbe.setHttpGet(getAction);
        readinessProbe.setTimeoutSeconds(1);
        readinessProbe.setPeriodSeconds(10);
        readinessProbe.setSuccessThreshold(1);
        readinessProbe.setFailureThreshold(3);
        container.setReadinessProbe(readinessProbe);
        container.setTerminationMessagePath("/dev/termination-log");
        Probe livenessProbe = new Probe();
        HTTPGetAction getAction2 = new HTTPGetAction();
        getAction2.setPath("/health/live");
        IntOrString pp2 = new IntOrString("admin");
        getAction2.setPort(pp2);
        getAction2.setScheme("HTTP");
        livenessProbe.setHttpGet(getAction);
        livenessProbe.setTimeoutSeconds(1);
        livenessProbe.setPeriodSeconds(10);
        livenessProbe.setSuccessThreshold(1);
        livenessProbe.setFailureThreshold(3);
        container.setLivenessProbe(livenessProbe);
        Map<String, String> labels = OpenShiftSupport.createCommonLabels(config);
        labels.putAll(matchLabels);
        if (osClient != null) {
            writer.info("\nWaiting until the application " + deploymentKind + " is ready ...");
        }
        if (ha) {
            StatefulSet deployment = ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.UpdateStrategyNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)((StatefulSetFluent.SpecNested)((StatefulSetBuilder)((StatefulSetFluent.MetadataNested)((StatefulSetFluent.MetadataNested)new StatefulSetBuilder().withNewMetadata().withLabels(labels)).withName(appName)).endMetadata()).withNewSpec().withReplicas(2)).withNewSelector().withMatchLabels(matchLabels)).endSelector()).withNewTemplate().withNewMetadata().withLabels(labels)).endMetadata()).withNewSpec().withContainers(container)).withRestartPolicy("Always")).endSpec()).endTemplate()).withNewUpdateStrategy().withType("RollingUpdate")).endUpdateStrategy()).endSpec()).build();
            if (osClient != null) {
                ((Resource)osClient.resources(StatefulSet.class).resource(deployment)).createOr(Updatable::update);
            }
            Utils.persistResource(OpenShiftSupport.getDeploymentDirectory(target), deployment, appName + "-statefulset.yaml");
            if (osClient != null) {
                ((Resource)osClient.resources(StatefulSet.class).resource(deployment)).waitUntilReady(5L, TimeUnit.MINUTES);
            }
        } else {
            Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.StrategyNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withLabels(labels)).withName(appName)).endMetadata()).withNewSpec().withReplicas(1)).withNewSelector().withMatchLabels(matchLabels)).endSelector()).withNewTemplate().withNewMetadata().withLabels(labels)).endMetadata()).withNewSpec().withContainers(container)).withRestartPolicy("Always")).endSpec()).endTemplate()).withNewStrategy().withType("RollingUpdate")).endStrategy()).endSpec()).build();
            if (osClient != null) {
                ((Resource)osClient.resources(Deployment.class).resource(deployment)).createOr(Updatable::update);
            }
            Utils.persistResource(OpenShiftSupport.getDeploymentDirectory(target), deployment, appName + "-deployment.yaml");
            if (osClient != null) {
                ((Resource)osClient.resources(Deployment.class).resource(deployment)).waitUntilReady(5L, TimeUnit.MINUTES);
            }
        }
    }

    public static ConfigurationResolver.ResolvedEnvs getResolvedEnvs(Layer layer, Set<Env> input, Set<String> disabledDeployers, Set<String> enabledDeployers) throws Exception {
        ConfigurationResolver.ResolvedEnvs resolved = null;
        List<Deployer> deployers = OpenShiftSupport.getEnabledDeployers(disabledDeployers, enabledDeployers);
        for (Deployer d : deployers) {
            Set<Env> envs;
            if (!d.getSupportedLayers().contains(layer.getName()) || (envs = d.getResolvedEnvs(input)) == null || envs.isEmpty()) continue;
            resolved = new ConfigurationResolver.ResolvedEnvs("openshift/" + d.getName(), envs);
            break;
        }
        return resolved;
    }

    public static String getPossibleDeployer(Set<Layer> layers, Set<String> disabledDeployers, Set<String> enabledDeployers) throws Exception {
        List<Deployer> deployers = OpenShiftSupport.getEnabledDeployers(disabledDeployers, enabledDeployers);
        for (Deployer d : deployers) {
            for (Layer l : layers) {
                if (!d.getSupportedLayers().contains(l.getName())) continue;
                return "openshift/" + d.getName();
            }
        }
        return null;
    }

    private static List<Deployer> getEnabledDeployers(Set<String> disabledDeployers, Set<String> enabledDeployers) throws Exception {
        List<Deployer> existingDeployers = OpenShiftSupport.getAllDeployers(disabledDeployers, enabledDeployers);
        ArrayList<Deployer> deployers = new ArrayList<Deployer>();
        for (Deployer d : existingDeployers) {
            boolean isDisabled = OpenShiftSupport.isDisabled(d.getName(), disabledDeployers, enabledDeployers);
            if (isDisabled) continue;
            deployers.add(d);
        }
        return deployers;
    }

    private static List<Deployer> getAllDeployers(Set<String> disabledDeployers, Set<String> enabledDeployers) throws Exception {
        HashMap<String, Deployer> existingDeployers = new HashMap<String, Deployer>();
        ArrayList<Deployer> deployers = new ArrayList<Deployer>();
        for (Deployer d : ServiceLoader.load(Deployer.class)) {
            existingDeployers.put(d.getName(), d);
            deployers.add(d);
        }
        for (String disabled : disabledDeployers) {
            if ("ALL".equals(disabled) || existingDeployers.containsKey(disabled)) continue;
            throw new Exception("Invalid deployer to disable: " + disabled);
        }
        if (!enabledDeployers.isEmpty() && !disabledDeployers.contains("ALL")) {
            throw new Exception("Enabled deployers is not empty although not ALL deployers are disabled.");
        }
        for (String enabled : enabledDeployers) {
            if (existingDeployers.containsKey(enabled)) continue;
            throw new Exception("Invalid deployer to enable: " + enabled);
        }
        return deployers;
    }

    static final String generateValidName(String name) {
        name = name.toLowerCase();
        StringBuilder validName = new StringBuilder();
        char[] array = name.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            if (i == 0) {
                if (c <= 'a' || c >= 'z') {
                    validName.append("app-");
                }
                validName.append(c);
                continue;
            }
            if (i == array.length - 1) {
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z') {
                    validName.append(c);
                    continue;
                }
                validName.append('0');
                continue;
            }
            if (c == '-') {
                validName.append(c);
                continue;
            }
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z') {
                validName.append(c);
                continue;
            }
            validName.append('-');
        }
        return OpenShiftSupport.truncateValue(validName.toString());
    }

    private static String truncateValue(String val) {
        if (val.length() > 63) {
            val = val.substring(0, 63);
        }
        return val;
    }

    /*
     * WARNING - void declaration
     */
    public static void deploy(List<Path> deployments, String applicationName, GlowMessageWriter writer, Path target, ScanResults scanResults, boolean ha, Map<String, String> extraEnv, Map<String, String> buildExtraEnv, Set<String> disabledDeployers, Set<String> enabledDeployers, Path initScript, Path cliScript, OpenShiftConfiguration config, MavenRepoManager mvnResolver, String stability, Map<String, String> serverImageBuildLabels, boolean dryRun, List<Channel> channels) throws Exception {
        void var32_43;
        String deploymentKind;
        Set<Layer> layers = scanResults.getDiscoveredLayers();
        Set<Layer> metadataOnlyLayers = scanResults.getMetadataOnlyLayers();
        Map<Layer, Set<Env>> requiredBuildTime = scanResults.getSuggestions().getBuildTimeRequiredConfigurations();
        String originalAppName = null;
        if (deployments != null && !deployments.isEmpty()) {
            Path deploymentsDir = OpenShiftSupport.getDeploymentsDirectory(target);
            Files.createDirectories(deploymentsDir, new FileAttribute[0]);
            for (Path path : deployments) {
                Files.copy(path, deploymentsDir.resolve(path.getFileName()), new CopyOption[0]);
                int ext = path.getFileName().toString().lastIndexOf(".");
                if (applicationName == null || applicationName.isEmpty()) {
                    applicationName = path.getFileName().toString().substring(0, ext);
                    applicationName = OpenShiftSupport.generateValidName(applicationName);
                }
                if (originalAppName != null) continue;
                originalAppName = path.getFileName().toString().substring(0, ext);
            }
        } else {
            throw new Exception("No application to deploy to OpenShift");
        }
        HashMap<String, String> env = new HashMap<String, String>();
        for (Set set : scanResults.getSuggestions().getStronglySuggestedConfigurations().values()) {
            for (Env e : set) {
                env.put(e.getName(), e.getDescription());
            }
        }
        LinkedHashSet<Layer> allLayers = new LinkedHashSet<Layer>();
        allLayers.addAll(layers);
        allLayers.addAll(metadataOnlyLayers);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        TreeMap<String, String> actualBuildEnv = new TreeMap<String, String>();
        OpenShiftClient osClient = null;
        if (!dryRun) {
            osClient = new KubernetesClientBuilder().build().adapt(OpenShiftClient.class);
            writer.info("\nConnected to OpenShift cluster");
        }
        Route route = ((RouteBuilder)((RouteFluent.SpecNested)((RouteFluent.SpecNested)((RouteBuilder)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withLabels(OpenShiftSupport.createCommonLabels(config))).withName(applicationName)).endMetadata()).withNewSpec().withTo(new RouteTargetReference("Service", applicationName, 100))).withTls(((TLSConfigBuilder)((TLSConfigBuilder)new TLSConfig().toBuilder().withTermination("edge")).withInsecureEdgeTerminationPolicy("Redirect")).build())).endSpec()).build();
        if (osClient != null) {
            ((Resource)osClient.routes().resource(route)).createOr(Updatable::update);
        }
        Utils.persistResource(OpenShiftSupport.getDeploymentDirectory(target), route, applicationName + "-route.yaml");
        String host = null;
        if (osClient != null) {
            host = ((Route)((Resource)osClient.routes().resource(route)).get()).getSpec().getHost();
        }
        List<Deployer> deployers = OpenShiftSupport.getAllDeployers(disabledDeployers, enabledDeployers);
        block8: for (Deployer d : deployers) {
            boolean bl = OpenShiftSupport.isDisabled(d.getName(), disabledDeployers, enabledDeployers);
            for (Layer l : allLayers) {
                if (!d.getSupportedLayers().contains(l.getName())) continue;
                if (!bl) {
                    writer.info("\nFound deployer " + d.getName() + " for " + l.getName());
                } else {
                    writer.warn("\nThe deployer " + d.getName() + " has been disabled");
                }
                treeMap.putAll(bl ? d.disabledDeploy(host, applicationName, host, env) : d.deploy(writer, target, osClient, env, host, applicationName, l.getName(), extraEnv, dryRun));
                Set<Env> buildEnv = requiredBuildTime.get(l);
                if (buildEnv == null) continue block8;
                HashSet<String> names = new HashSet<String>();
                for (Env e : buildEnv) {
                    if (buildExtraEnv.containsKey(e.getName())) continue;
                    names.add(e.getName());
                }
                actualBuildEnv.putAll(d.handleBuildTimeDefault(names, mvnResolver));
                continue block8;
            }
        }
        if (!dryRun) {
            treeMap.put("APPLICATION_ROUTE_HOST", host);
        }
        treeMap.putAll(extraEnv);
        if (stability != null) {
            boolean bl;
            Object val = (String)treeMap.get("SERVER_ARGS");
            String stabilityOption = "--stability=" + stability;
            boolean bl2 = false;
            if (val == null) {
                val = stabilityOption;
            } else if (((String)val).contains("--stability")) {
                bl = true;
            } else {
                val = (String)val + " --stability" + stability;
            }
            if (!bl) {
                treeMap.put("SERVER_ARGS", (String)val);
            }
        }
        String string = deploymentKind = ha ? "StatefulSet" : "Deployment";
        if (!disabledDeployers.isEmpty()) {
            writer.warn("The following environment variables will be set in the " + applicationName + " " + deploymentKind + ". Make sure that the required env variables for the disabled deployer(s) have been set:\n");
        } else {
            writer.warn("The following environment variables will be set in the " + applicationName + " " + deploymentKind + ":\n");
        }
        if (ha) {
            treeMap.put("JGROUPS_PING_PROTOCOL", "openshift.DNS_PING");
            treeMap.put("OPENSHIFT_DNS_PING_SERVICE_PORT", "8888");
            treeMap.put("OPENSHIFT_DNS_PING_SERVICE_NAME", applicationName + "-ping");
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            writer.warn((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        actualBuildEnv.putAll(buildExtraEnv);
        Properties properties = new Properties();
        OpenShiftSupport.createBuild(writer, target, osClient, applicationName, initScript, cliScript, actualBuildEnv, config, serverImageBuildLabels, properties, channels);
        if (!dryRun) {
            writer.info("Deploying application image on OpenShift");
        }
        Object var32_41 = null;
        if (osClient == null) {
            String string2 = OpenShiftSupport.generateClientImageHash(deployments, target, buildExtraEnv, initScript, cliScript, channels);
            properties.setProperty("app-image-tag", string2);
        }
        OpenShiftSupport.createAppDeployment(writer, target, osClient, applicationName, treeMap, ha, config, deploymentKind, (String)var32_43);
        try (FileOutputStream out = new FileOutputStream(OpenShiftSupport.getDockerDirectory(target).resolve(IMAGE_PROPERTIES_FILE).toFile());){
            properties.store(out, null);
        }
        if (dryRun) {
            writer.info("\nThe following generated content can be used to produce server and application container images and deploy to OpenShift.\nNOTE: Some editing is required. Check the following steps:\n");
            writer.info("* Directory '" + target.resolve("galleon") + "' contains the provisioning file used to provision a server.\n");
            writer.info("* Directory '" + OpenShiftSupport.getDockerServerDirectory(target) + "' contains the Dockerfile to build the server image. This Dockerfile expects that you first provision a server (e.g.: using Galleon CLI) in the directory '" + OpenShiftSupport.getDockerServerDirectory(target) + "' using the generated provisioning.xml.\n");
            writer.info("NOTE: The file '" + OpenShiftSupport.getDockerDirectory(target).resolve(IMAGE_PROPERTIES_FILE) + "' contains the server image tag that is expected by the application Dockerfile.\n");
            writer.info("* Directory '" + OpenShiftSupport.getDockerAppDirectory(target) + "' contains the Dockerfile to build the application image. Make sure to replace the 'WILDFLY_GLOW_SERVER_IMAGE_REPOSITORY' string with the repository where the server image has been pushed (e.g.: 'quay.io/my-organization/wildfly-servers').\n");
            writer.info("NOTE: The file '" + OpenShiftSupport.getDockerDirectory(target).resolve(IMAGE_PROPERTIES_FILE) + "' contains the aplication image tag that is expected by the Deployment.\n");
            writer.info("* Directory '" + OpenShiftSupport.getDeploymentDirectory(target) + "' contains the openshift resources. Make sure to replace the 'WILDFLY_GLOW_APP_IMAGE_REPOSITORY' string with the repository where the application image has been pushed (e.g.: 'quay.io/my-organization/" + applicationName + "-image').\n");
        } else {
            writer.info("Application route: https://" + host + (String)("ROOT.war".equals(applicationName) ? "" : "/" + originalAppName));
        }
        IoUtils.recursiveDelete(OpenShiftSupport.getTmpDirectory(target));
    }

    private static void createBuild(GlowMessageWriter writer, Path target, OpenShiftClient osClient, String appName, Path initScript, Path cliScript, Map<String, String> buildExtraEnv, OpenShiftConfiguration config, Map<String, String> serverImageBuildLabels, Properties properties, List<Channel> channels) throws Exception {
        if (osClient == null) {
            OpenShiftSupport.generateDockerServerImage(writer, target, buildExtraEnv, config);
            String serverImageTag = OpenShiftSupport.generateServerImageHash(target, buildExtraEnv, channels);
            properties.setProperty("server-image-tag", serverImageTag);
            OpenShiftSupport.doAppImageBuild(null, writer, target, osClient, appName, initScript, cliScript, config, serverImageTag);
        } else {
            String serverImageName = OpenShiftSupport.doServerImageBuild(writer, target, osClient, buildExtraEnv, config, serverImageBuildLabels, channels);
            OpenShiftSupport.doAppImageBuild(serverImageName, writer, target, osClient, appName, initScript, cliScript, config, null);
        }
    }

    private static boolean packageInitScript(boolean dryRun, Path initScript, Path cliScript, Path target) throws Exception {
        if (initScript != null || cliScript != null) {
            Path extensions = dryRun ? OpenShiftSupport.getExtensionsDirectory(target) : target.resolve(EXTENSIONS_DIR);
            Files.createDirectories(extensions, new FileAttribute[0]);
            StringBuilder initExecution = new StringBuilder();
            initExecution.append("#!/bin/bash").append("\n");
            if (initScript != null) {
                initExecution.append("echo \"Calling initialization script\"").append("\n");
                Path init = extensions.resolve("init-script.sh");
                Files.copy(initScript, init, new CopyOption[0]);
                initExecution.append("sh $JBOSS_HOME/extensions/init-script.sh").append("\n");
            }
            if (cliScript != null) {
                initExecution.append("echo \"Calling CLI script\"").append("\n");
                Path cli = extensions.resolve("cli-script.cli");
                Files.copy(cliScript, cli, new CopyOption[0]);
                initExecution.append("cat $JBOSS_HOME/extensions/cli-script.cli >> \"${CLI_SCRIPT_FILE}\"");
            }
            Path postconfigure = extensions.resolve("postconfigure.sh");
            Files.write(postconfigure, initExecution.toString().getBytes(), new OpenOption[0]);
            return true;
        }
        return false;
    }

    private static boolean isDisabled(String name, Set<String> disabledDeployers, Set<String> enabledDeployers) {
        return !enabledDeployers.contains(name) && (disabledDeployers.contains("ALL") || disabledDeployers.contains(name));
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static Map<String, String> createCommonLabels(OpenShiftConfiguration osConfig) throws Exception {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(OpenShiftSupport.truncateValue(osConfig.getLabelRadical()), "");
        return labels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> createServerImageLabels(Path target, Path provisioning, OpenShiftConfiguration osConfig, Map<String, String> serverImageBuildLabels) throws Exception {
        GalleonBuilder provider = new GalleonBuilder();
        Path dir = OpenShiftSupport.getTmpDirectory(target).resolve("tmpHome");
        HashMap<String, String> labels = new HashMap<String, String>();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            StringBuilder fps = new StringBuilder();
            try (Provisioning p = provider.newProvisioningBuilder(provisioning).setInstallationHome(dir).build();){
                GalleonProvisioningConfig config = p.loadProvisioningConfig(provisioning);
                GalleonConfigurationWithLayers cl = config.getDefinedConfig(new ConfigId("standalone", "standalone.xml"));
                for (String s : cl.getIncludedLayers()) {
                    labels.put(OpenShiftSupport.truncateValue(osConfig.getLabelRadical() + ".layer." + s), "");
                }
                for (String s : cl.getExcludedLayers()) {
                    labels.put(OpenShiftSupport.truncateValue(osConfig.getLabelRadical() + ".excluded.layer." + s), "");
                }
                for (GalleonFeaturePackConfig gfpc : config.getFeaturePackDeps()) {
                    if (fps.length() != 0) {
                        fps.append("_");
                    }
                    String producerName = gfpc.getLocation().getProducerName();
                    int i = (producerName = producerName.replaceAll("::zip", "")).indexOf(":");
                    if (i > 0) {
                        producerName = producerName.substring(i + 1);
                    }
                    producerName = producerName.replaceAll(":", "-");
                    labels.put(OpenShiftSupport.truncateValue(osConfig.getLabelRadical() + "." + producerName), gfpc.getLocation().getBuild());
                }
            }
            for (Map.Entry<String, String> entry : serverImageBuildLabels.entrySet()) {
                labels.put(OpenShiftSupport.truncateValue(entry.getKey()), OpenShiftSupport.truncateValue(entry.getValue()));
            }
        }
        finally {
            IoUtils.recursiveDelete(dir);
        }
        return labels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> createDockerImageLabels(Path target, Path provisioning, OpenShiftConfiguration osConfig) throws Exception {
        GalleonBuilder provider = new GalleonBuilder();
        Path dir = OpenShiftSupport.getTmpDirectory(target).resolve("tmpHome");
        HashMap<String, String> labels = new HashMap<String, String>();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            try (Provisioning p = provider.newProvisioningBuilder(provisioning).setInstallationHome(dir).build();){
                String current;
                GalleonProvisioningConfig config = p.loadProvisioningConfig(provisioning);
                GalleonConfigurationWithLayers cl = config.getDefinedConfig(new ConfigId("standalone", "standalone.xml"));
                for (String s : cl.getIncludedLayers()) {
                    current = (String)labels.get(osConfig.getLabelRadical() + ".layers");
                    labels.put(osConfig.getLabelRadical() + ".layers", (String)(current == null ? "" : current + ",") + s);
                }
                for (String s : cl.getExcludedLayers()) {
                    current = (String)labels.get(osConfig.getLabelRadical() + ".excluded-layers");
                    labels.put(osConfig.getLabelRadical() + ".excluded-layers", (String)(current == null ? "" : current + ",") + s);
                }
                for (GalleonFeaturePackConfig gfpc : config.getFeaturePackDeps()) {
                    Object producerName = gfpc.getLocation().getProducerName();
                    int i = ((String)(producerName = ((String)producerName).replaceAll("::zip", ""))).indexOf(":");
                    if (i > 0) {
                        producerName = ((String)producerName).substring(i + 1);
                    }
                    producerName = ((String)producerName).replaceAll(":", "_");
                    String version = gfpc.getLocation().getBuild();
                    if (version != null) {
                        producerName = (String)producerName + "_" + version;
                    }
                    String current2 = (String)labels.get(osConfig.getLabelRadical() + ".feature-packs");
                    labels.put(osConfig.getLabelRadical() + ".feature-packs", (String)(current2 == null ? "" : current2 + ",") + (String)producerName);
                }
            }
        }
        finally {
            IoUtils.recursiveDelete(dir);
        }
        return labels;
    }

    private static String generateServerImageHash(Path target, Map<String, String> buildExtraEnv, List<Channel> channels) throws IOException, NoSuchAlgorithmException {
        StringBuilder contentBuilder = new StringBuilder();
        Path provisioning = target.resolve("galleon").resolve("provisioning.xml");
        contentBuilder.append(Files.readString(provisioning, Charset.forName("UTF-8")));
        for (Map.Entry<String, String> entry : buildExtraEnv.entrySet()) {
            contentBuilder.append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (channels != null && !channels.isEmpty()) {
            contentBuilder.append(ChannelMapper.toYaml(channels));
        }
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] encodedhash = digest.digest(contentBuilder.toString().getBytes());
        String key = OpenShiftSupport.bytesToHex(encodedhash);
        return key;
    }

    private static String generateClientImageHash(List<Path> deployments, Path target, Map<String, String> buildExtraEnv, Path initScript, Path cliScript, List<Channel> channels) throws IOException, NoSuchAlgorithmException {
        String server = OpenShiftSupport.generateServerImageHash(target, buildExtraEnv, channels);
        StringBuilder contentBuilder = new StringBuilder();
        contentBuilder.append(server);
        for (Path p : deployments) {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] encodedhash = digest.digest(Files.readAllBytes(p));
            String key = OpenShiftSupport.bytesToHex(encodedhash);
            contentBuilder.append(key);
        }
        if (initScript != null) {
            contentBuilder.append(Files.readString(initScript, Charset.forName("UTF-8")));
        }
        if (cliScript != null) {
            contentBuilder.append(Files.readString(cliScript, Charset.forName("UTF-8")));
        }
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] encodedhash = digest.digest(contentBuilder.toString().getBytes());
        String key = OpenShiftSupport.bytesToHex(encodedhash);
        return key;
    }

    private static String doServerImageBuild(GlowMessageWriter writer, Path target, OpenShiftClient osClient, Map<String, String> buildExtraEnv, OpenShiftConfiguration config, Map<String, String> serverImageBuildLabels, List<Channel> channels) throws Exception {
        Path provisioning = target.resolve("galleon").resolve("provisioning.xml");
        String serverImageName = config.getServerImageNameRadical() + OpenShiftSupport.generateServerImageHash(target, buildExtraEnv, channels);
        ImageStream stream = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withLabels(OpenShiftSupport.createCommonLabels(config))).withName(serverImageName)).endMetadata()).withNewSpec().withLookupPolicy(new ImageLookupPolicy(Boolean.TRUE))).endSpec()).build();
        ImageStream existingStream = (ImageStream)((Resource)osClient.imageStreams().resource(stream)).get();
        if (existingStream == null) {
            writer.info("\nBuilding server image (this can take up to few minutes)...");
            Path file = OpenShiftSupport.getTmpDirectory(target).resolve("openshiftServer.zip");
            if (Files.exists(file, new LinkOption[0])) {
                Files.delete(file);
            }
            Path stepOne = OpenShiftSupport.getTmpDirectory(target).resolve("step-one");
            Files.createDirectories(stepOne, new FileAttribute[0]);
            IoUtils.copy(target.resolve("galleon"), stepOne.resolve("galleon"));
            ZipUtils.zip(stepOne, file);
            stream = ((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)stream.toBuilder().editOrNewMetadata().withLabels(OpenShiftSupport.createServerImageLabels(target, provisioning, config, serverImageBuildLabels))).endMetadata()).build();
            ((Resource)osClient.imageStreams().resource(stream)).createOr(Updatable::update);
            Utils.persistResource(OpenShiftSupport.getBuildDirectory(target), stream, serverImageName + "-image-stream.yaml");
            BuildConfigBuilder builder = new BuildConfigBuilder();
            ObjectReference ref = new ObjectReference();
            ref.setKind("ImageStreamTag");
            ref.setName(serverImageName + ":latest");
            ArrayList<EnvVar> vars = new ArrayList<EnvVar>();
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName("GALLEON_USE_LOCAL_FILE")).withValue("true")).build());
            if (!buildExtraEnv.isEmpty()) {
                writer.warn("\nThe following environment variables have been set in the " + serverImageName + " buildConfig:\n");
                for (Map.Entry<String, String> entry : buildExtraEnv.entrySet()) {
                    String val = buildExtraEnv.get(entry.getKey());
                    writer.warn(entry.getKey() + "=" + entry.getValue());
                    vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName(entry.getKey())).withValue(val == null ? entry.getValue() : val)).build());
                }
            }
            BuildConfig buildConfig = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.SourceStrategyNested)((BuildStrategyFluent.SourceStrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)builder.withNewMetadata().withLabels(OpenShiftSupport.createCommonLabels(config))).withName(serverImageName + "-build")).endMetadata()).withNewSpec().withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(serverImageName + ":latest")).endTo()).endOutput()).withNewStrategy().withNewSourceStrategy().withNewFrom().withKind("DockerImage")).withName(config.getBuilderImage())).endFrom()).withIncremental(true)).withEnv(vars)).endSourceStrategy()).endStrategy()).withNewSource().withType("Binary")).endSource()).endSpec()).build();
            ((BuildConfigResource)osClient.buildConfigs().resource(buildConfig)).createOr(Updatable::update);
            Utils.persistResource(OpenShiftSupport.getBuildDirectory(target), buildConfig, serverImageName + "-build-config.yaml");
            Build build = (Build)((BuildConfigResource)osClient.buildConfigs().withName(serverImageName + "-build")).instantiateBinary().fromFile(file.toFile());
            BuildWatcher buildWatcher = new BuildWatcher(writer);
            try (Watch watcher = ((BuildResource)osClient.builds().withName(build.getMetadata().getName())).watch(buildWatcher);){
                buildWatcher.await();
            }
            if (buildWatcher.isFailed()) {
                ((Resource)osClient.imageStreams().resource(stream)).delete();
                throw new Exception("Server image build has failed. Check the OpenShift build log.");
            }
        }
        return serverImageName;
    }

    private static void generateDockerServerImage(GlowMessageWriter writer, Path target, Map<String, String> buildExtraEnv, OpenShiftConfiguration config) throws Exception {
        Path provisioning = target.resolve("galleon").resolve("provisioning.xml");
        Map<String, String> labels = OpenShiftSupport.createDockerImageLabels(target, provisioning, config);
        StringBuilder dockerFileBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            dockerFileBuilder.append("LABEL ").append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        if (!buildExtraEnv.isEmpty()) {
            writer.warn("\nThe following environment variables have been set in the server Dockerfile:\n");
            for (Map.Entry<String, String> entry : buildExtraEnv.entrySet()) {
                String val = buildExtraEnv.get(entry.getKey());
                writer.warn(entry.getKey() + "=" + entry.getValue());
                dockerFileBuilder.append("ENV ").append(entry.getKey()).append("=").append(val == null ? entry.getValue() : val).append("\n");
            }
        }
        dockerFileBuilder.append("FROM ").append(config.getRuntimeImage()).append("\n");
        dockerFileBuilder.append("COPY server $JBOSS_HOME\n");
        dockerFileBuilder.append("USER root\n");
        dockerFileBuilder.append("RUN chown -R jboss:root $JBOSS_HOME && chmod -R ug+rwX $JBOSS_HOME\n");
        dockerFileBuilder.append("USER jboss");
        Files.write(OpenShiftSupport.getDockerServerDirectory(target).resolve("Dockerfile"), dockerFileBuilder.toString().getBytes(), new OpenOption[0]);
    }

    private static void doAppImageBuild(String serverImageName, GlowMessageWriter writer, Path target, OpenShiftClient osClient, String appName, Path initScript, Path cliScript, OpenShiftConfiguration config, String serverImageTag) throws Exception {
        Path stepTwo = target;
        if (osClient != null) {
            stepTwo = OpenShiftSupport.getTmpDirectory(target).resolve("step-two");
            IoUtils.copy(OpenShiftSupport.getDeploymentsDirectory(target), stepTwo.resolve(DEPLOYMENTS_DIR));
        }
        StringBuilder dockerFileBuilder = new StringBuilder();
        if (osClient != null) {
            dockerFileBuilder.append("FROM ").append(config.getRuntimeImage()).append("\n");
            dockerFileBuilder.append("COPY --chown=jboss:root /server $JBOSS_HOME\n");
        } else {
            dockerFileBuilder.append("FROM ").append(WILDFLY_GLOW_SERVER_IMAGE_REPOSITORY).append(":").append(serverImageTag).append("\n");
        }
        dockerFileBuilder.append("COPY --chown=jboss:root deployments/* $JBOSS_HOME/standalone/deployments\n");
        if (OpenShiftSupport.packageInitScript(osClient == null, initScript, cliScript, stepTwo)) {
            dockerFileBuilder.append("COPY --chown=jboss:root extensions $JBOSS_HOME/extensions\n");
            dockerFileBuilder.append("RUN chmod ug+rwx $JBOSS_HOME/extensions/postconfigure.sh\n");
        }
        dockerFileBuilder.append("RUN chmod -R ug+rwX $JBOSS_HOME\n");
        Files.write(OpenShiftSupport.getDockerAppDirectory(target).resolve("Dockerfile"), dockerFileBuilder.toString().getBytes(), new OpenOption[0]);
        Path file2 = null;
        if (osClient != null) {
            Path dockerFile = stepTwo.resolve("Dockerfile");
            Files.write(dockerFile, dockerFileBuilder.toString().getBytes(), new OpenOption[0]);
            file2 = OpenShiftSupport.getTmpDirectory(target).resolve("openshiftApp.zip");
            if (Files.exists(file2, new LinkOption[0])) {
                Files.delete(file2);
            }
            ZipUtils.zip(stepTwo, file2);
            writer.info("\nBuilding application image...");
        }
        ImageStream appStream = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withLabels(OpenShiftSupport.createCommonLabels(config))).withName(appName)).endMetadata()).withNewSpec().withLookupPolicy(new ImageLookupPolicy(Boolean.TRUE))).endSpec()).build();
        if (osClient != null) {
            ((Resource)osClient.imageStreams().resource(appStream)).createOr(Updatable::update);
            Utils.persistResource(OpenShiftSupport.getImagesDirectory(target), appStream, appName + "-image-stream.yaml");
        }
        BuildConfigBuilder builder = new BuildConfigBuilder();
        ObjectReference ref = new ObjectReference();
        ref.setKind("ImageStreamTag");
        ref.setName(serverImageName + ":latest");
        ImageSourcePath srcPath = ((ImageSourcePathBuilder)((ImageSourcePathBuilder)new ImageSourcePathBuilder().withSourcePath("/opt/server")).withDestinationDir(".")).build();
        ImageSource imageSource = ((ImageSourceBuilder)((ImageSourceBuilder)new ImageSourceBuilder().withFrom(ref)).withPaths(srcPath)).build();
        if (osClient != null) {
            BuildConfig buildConfig2 = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildStrategyFluent.DockerStrategyNested)((DockerBuildStrategyFluent.FromNested)((DockerBuildStrategyFluent.FromNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)builder.withNewMetadata().withLabels(OpenShiftSupport.createCommonLabels(config))).withName(appName + "-build")).endMetadata()).withNewSpec().withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(appName + ":latest")).endTo()).endOutput()).withNewSource().withType("Binary")).withImages(imageSource)).endSource()).withNewStrategy().withNewDockerStrategy().withNewFrom().withKind("DockerImage")).withName("quay.io/wildfly/wildfly-runtime:latest")).endFrom()).withDockerfilePath("./Dockerfile")).endDockerStrategy()).endStrategy()).endSpec()).build();
            ((BuildConfigResource)osClient.buildConfigs().resource(buildConfig2)).createOr(Updatable::update);
            Utils.persistResource(OpenShiftSupport.getBuildDirectory(target), buildConfig2, appName + "-build-config.yaml");
            Build build = (Build)((BuildConfigResource)osClient.buildConfigs().withName(appName + "-build")).instantiateBinary().fromFile(file2.toFile());
            BuildWatcher buildWatcher = new BuildWatcher(writer);
            try (Watch watcher = ((BuildResource)osClient.builds().withName(build.getMetadata().getName())).watch(buildWatcher);){
                buildWatcher.await();
            }
            if (buildWatcher.isFailed()) {
                ((Resource)osClient.imageStreams().resource(appStream)).delete();
                throw new Exception("Application image build has failed. Check the OpenShift build log.");
            }
        }
    }

    private static class BuildWatcher
    implements Watcher<Build>,
    AutoCloseable {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final GlowMessageWriter writer;
        private boolean failed;

        BuildWatcher(GlowMessageWriter writer) {
            this.writer = writer;
        }

        @Override
        public void eventReceived(Watcher.Action action, Build build) {
            String phase = build.getStatus().getPhase();
            if ("Running".equals(phase)) {
                this.writer.info("Build is running...");
            }
            if ("Complete".equals(phase)) {
                this.writer.info("Build is complete.");
                this.latch.countDown();
            }
            if ("Failed".equals(phase)) {
                this.writer.info("Build Failed.");
                this.failed = true;
                this.latch.countDown();
            }
        }

        @Override
        public void onClose(WatcherException cause) {
        }

        void await() throws InterruptedException {
            this.latch.await();
        }

        boolean isFailed() {
            return this.failed;
        }

        @Override
        public void close() throws Exception {
        }
    }
}

