/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.error;

import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.error.ErrorLevel;

public class IdentifiedError {
    private final String id;
    private final String description;
    private ErrorLevel errorLevel;
    private boolean fixed;
    private String fixMessage;
    private final Set<AddOn> possibleAddOns = new TreeSet<AddOn>();

    public IdentifiedError(String id, String description, ErrorLevel errorLevel) {
        this.id = id;
        this.description = description;
        this.errorLevel = errorLevel;
    }

    public void setFixed(String message) {
        this.fixed = true;
        this.fixMessage = message;
    }

    public String getFixMessage() {
        return this.fixMessage;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public Set<AddOn> getPossibleAddons() {
        return this.possibleAddOns;
    }

    public ErrorLevel getErrorLevel() {
        return this.errorLevel;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.id);
        hash = 97 * hash + Objects.hashCode(this.description);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentifiedError other = (IdentifiedError)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.description, other.description);
    }

    public String getDescription() {
        return this.description;
    }
}

