/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.stringrover;

import java.util.Objects;

public class StringRover
implements CharSequence {
    private final String string;
    private int offset;

    public StringRover(String string) {
        this.string = Objects.requireNonNull(string);
        this.offset = 0;
    }

    private StringRover(String string, int offset) {
        this.string = string;
        this.offset = offset;
    }

    @Override
    public int length() {
        return this.string.length() - this.offset;
    }

    @Override
    public boolean isEmpty() {
        return this.string.length() <= this.offset;
    }

    @Override
    public char charAt(int index) {
        return this.string.charAt(this.offset + index);
    }

    public StringRover increment() {
        return this.increment(1);
    }

    public StringRover increment(int increment) {
        int len;
        int new_offset = this.offset + increment;
        this.offset = new_offset <= 0 ? 0 : (new_offset >= (len = this.string.length()) ? len : new_offset);
        return this;
    }

    public StringRover reset() {
        this.offset = 0;
        return this;
    }

    public StringRover duplicate() {
        return new StringRover(this.string, this.offset);
    }

    public int indexOf(int ch, int from) {
        int index = this.string.indexOf(ch, this.offset + from) - this.offset;
        return index < 0 ? -1 : index;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(CharSequence str, int from) {
        int length = this.length();
        int size = str.length();
        if (from >= length) {
            return size == 0 ? length : -1;
        }
        if (from < 0) {
            from = 0;
        }
        if (size == 0) {
            return from;
        }
        char first = str.charAt(0);
        int limit = this.offset + (length - size);
        block0: for (int i = this.offset + from; i <= limit; ++i) {
            if (this.string.charAt(i) != first) continue;
            int end = i + size;
            int j = i + 1;
            int k = 1;
            while (j < end) {
                if (this.string.charAt(j) != str.charAt(k)) continue block0;
                ++j;
                ++k;
            }
            return i - this.offset;
        }
        return -1;
    }

    public int indexOf(CharSequence str) {
        return this.indexOf(str, 0);
    }

    public int lastIndexOf(int ch, int from) {
        int index = this.string.lastIndexOf(ch, this.offset + from) - this.offset;
        return index < 0 ? -1 : index;
    }

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.length() - 1);
    }

    public int lastIndexOf(CharSequence str, int from) {
        int length = this.length();
        int size = str.length();
        if (from < 0) {
            return -1;
        }
        int right = length - size;
        if (from > right) {
            from = right;
        }
        if (size == 0) {
            return from;
        }
        int end = size - 1;
        char last = str.charAt(end);
        int limit = this.offset + end;
        block0: for (int i = limit + from; i >= limit; --i) {
            int start;
            if (this.string.charAt(i) != last) continue;
            int j = start = i - end;
            int k = 0;
            while (j < i) {
                if (this.string.charAt(j) != str.charAt(k)) continue block0;
                ++j;
                ++k;
            }
            return start - this.offset;
        }
        return -1;
    }

    public int lastIndexOf(CharSequence str) {
        return this.lastIndexOf(str, this.length());
    }

    public String substring(int start) {
        return this.string.substring(this.offset + start);
    }

    public String substring(int start, int end) {
        return this.string.substring(this.offset + start, this.offset + end);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    @Override
    public String toString() {
        return this.string.substring(this.offset);
    }

    public boolean startsWith(CharSequence prefix, int from) {
        int size = prefix.length();
        if (from < 0 || from > this.length() - size) {
            return false;
        }
        int source = this.offset + from;
        int target = 0;
        while (size > 0) {
            if (this.string.charAt(source) != prefix.charAt(target)) {
                return false;
            }
            --size;
            ++source;
            ++target;
        }
        return true;
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(CharSequence suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }
}

