/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.support;

import java.io.PrintWriter;
import java.util.concurrent.Callable;
import picocli.CommandLine;

public abstract class AbstractCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-B", "--batch"})
    private boolean batch;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true)
    boolean help;
    @CommandLine.Option(names={"-vv", "--verbose"})
    protected boolean verbose;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    private PrintWriter stdout;
    private PrintWriter stderr;
    private CommandLine.Help.Ansi ansi;

    public void print() {
        PrintWriter writer = this.getStdout();
        writer.println();
    }

    public void print(Object msg) {
        PrintWriter writer = this.getStdout();
        writer.println(this.format(String.valueOf(msg), new Object[0]));
    }

    public void print(String fmt, Object ... args) {
        this.print(0, fmt, args);
    }

    public void print(int padding, Object message) {
        PrintWriter writer = this.getStdout();
        if (padding > 0) {
            writer.printf("%1$" + padding + "s", " ");
        }
        writer.println(message);
    }

    public void print(int padding, String fmt, Object ... args) {
        this.print(this.getStdout(), padding, fmt, args);
    }

    public void printError(String fmt, Object ... args) {
        this.print(this.getStderr(), 0, "@|fg(red) " + fmt + "|@", args);
    }

    public PrintWriter getStdout() {
        if (this.stdout == null) {
            this.stdout = this.spec.commandLine().getOut();
        }
        return this.stdout;
    }

    String format(String fmt, Object ... args) {
        if (this.ansi == null) {
            this.ansi = this.batch ? CommandLine.Help.Ansi.OFF : this.spec.commandLine().getColorScheme().ansi();
        }
        return this.format(this.ansi, String.format(fmt, args));
    }

    String format(CommandLine.Help.Ansi ansi, String value) {
        return ansi.string(value);
    }

    public PrintWriter getStderr() {
        if (this.stderr == null) {
            this.stderr = this.spec.commandLine().getErr();
        }
        return this.stderr;
    }

    private void print(PrintWriter writer, int padding, String fmt, Object ... args) {
        if (padding > 0) {
            writer.printf("%1$" + padding + "s", " ");
        }
        writer.println(this.format(fmt, args));
    }
}

