/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.AnnotationKeyword;
import com.networknt.schema.Keyword;
import com.networknt.schema.KeywordFactory;
import com.networknt.schema.ValidationContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnknownKeywordFactory
implements KeywordFactory {
    private static final Logger logger = LoggerFactory.getLogger(UnknownKeywordFactory.class);
    private final Map<String, Keyword> keywords = new ConcurrentHashMap<String, Keyword>();

    @Override
    public Keyword getKeyword(String value, ValidationContext validationContext) {
        return this.keywords.computeIfAbsent(value, keyword -> {
            logger.warn("Unknown keyword {} - you should define your own Meta Schema. If the keyword is irrelevant for validation, just use a NonValidationKeyword or if it should generate annotations AnnotationKeyword", keyword);
            return new AnnotationKeyword((String)keyword);
        });
    }

    public static UnknownKeywordFactory getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static UnknownKeywordFactory INSTANCE = new UnknownKeywordFactory();

        private Holder() {
        }
    }
}

