/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.server;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.ContainerDescription;
import org.wildfly.plugin.tools.DeploymentManager;
import org.wildfly.plugin.tools.server.CommonOperations;
import org.wildfly.plugin.tools.server.DomainManager;
import org.wildfly.plugin.tools.server.StandaloneManager;

public interface ServerManager {
    public static Builder builder() {
        return new Builder();
    }

    public static Optional<ProcessHandle> findProcess() {
        return ProcessHandle.allProcesses().filter(p -> {
            ProcessHandle.Info info = p.info();
            boolean found = false;
            if (info.arguments().isPresent()) {
                String[] arguments = info.arguments().get();
                for (int i = 0; i < arguments.length; ++i) {
                    String arg = arguments[i];
                    if (!found && arg.trim().equalsIgnoreCase("-jar")) {
                        found = arguments[++i].contains("jboss-modules.jar");
                        continue;
                    }
                    if ((!found || !"org.jboss.as.process-controller".equals(arg)) && !"org.jboss.as.standalone".equals(arg)) continue;
                    return true;
                }
            }
            return false;
        }).findFirst();
    }

    public static boolean isValidHomeDirectory(Path path) {
        return path != null && Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && Files.exists(path.resolve("jboss-modules.jar"), new LinkOption[0]);
    }

    public static boolean isValidHomeDirectory(String path) {
        return path != null && ServerManager.isValidHomeDirectory(Path.of(path, new String[0]));
    }

    public static boolean isRunning(ModelControllerClient client) {
        try {
            String launchType;
            while ((launchType = (String)ServerManager.launchType(client).orElse(null)) != null) {
                if ("STANDALONE".equals(launchType)) {
                    return CommonOperations.isStandaloneRunning(client);
                }
                if (!"DOMAIN".equals(launchType)) continue;
                return CommonOperations.isDomainRunning(client, false);
            }
        }
        catch (RuntimeException e) {
            Logger.getLogger(ServerManager.class).trace((Object)"Interrupted determining if server is running", e);
        }
        return false;
    }

    public static Optional<String> launchType(ModelControllerClient client) {
        try {
            ModelNode response = client.execute(Operations.createReadAttributeOperation((ModelNode)new ModelNode().setEmptyList(), (String)"launch-type"));
            return Operations.isSuccessfulOutcome((ModelNode)response) ? Optional.of(Operations.readResult((ModelNode)response).asString()) : Optional.empty();
        }
        catch (IOException | RuntimeException exception) {
            return Optional.empty();
        }
    }

    public ModelControllerClient client();

    public String serverState();

    public String launchType();

    public String takeSnapshot() throws IOException;

    public ContainerDescription containerDescription() throws IOException;

    public DeploymentManager deploymentManager();

    public boolean isRunning();

    default public boolean waitFor(long startupTimeout) throws InterruptedException {
        return this.waitFor(startupTimeout, TimeUnit.SECONDS);
    }

    public boolean waitFor(long var1, TimeUnit var3) throws InterruptedException;

    public void shutdown() throws IOException;

    public void shutdown(long var1) throws IOException;

    public void executeReload() throws IOException;

    public void executeReload(ModelNode var1) throws IOException;

    public void reloadIfRequired() throws IOException;

    public void reloadIfRequired(long var1, TimeUnit var3) throws IOException;

    public static class Builder {
        private ModelControllerClient client;
        private String managementAddress;
        private int managementPort;
        private ProcessHandle process;

        public Builder client(ModelControllerClient client) {
            this.client = client;
            return this;
        }

        public Builder process(ProcessHandle process) {
            this.process = process;
            return this;
        }

        public Builder process(Process process) {
            this.process = process == null ? null : process.toHandle();
            return this;
        }

        public Builder managementAddress(String managementAddress) {
            this.managementAddress = managementAddress;
            return this;
        }

        public Builder managementPort(int managementPort) {
            this.managementPort = managementPort;
            return this;
        }

        public StandaloneManager standalone() {
            return new StandaloneManager(this.process, this.getOrCreateClient());
        }

        public DomainManager domain() {
            return new DomainManager(this.process, this.getOrCreateDomainClient());
        }

        public CompletableFuture<ServerManager> build() {
            ModelControllerClient client = this.getOrCreateClient();
            ProcessHandle process = this.process;
            return CompletableFuture.supplyAsync(() -> {
                while (!ServerManager.isRunning(client)) {
                    Thread.onSpinWait();
                }
                String launchType = ServerManager.launchType(client).orElseThrow(() -> new IllegalStateException("Could not determine the type of the server. Verify the server is running."));
                if ("STANDALONE".equals(launchType)) {
                    return new StandaloneManager(process, client);
                }
                if ("DOMAIN".equals(launchType)) {
                    return new DomainManager(process, this.getOrCreateDomainClient());
                }
                throw new IllegalStateException(String.format("Only standalone and domain servers are support. %s is not supported.", launchType));
            });
        }

        private ModelControllerClient getOrCreateClient() {
            if (this.client == null) {
                String address = this.managementAddress == null ? "localhost" : this.managementAddress;
                int port = this.managementPort <= 0 ? 9990 : this.managementPort;
                try {
                    return ModelControllerClient.Factory.create((String)address, (int)port);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return this.client;
        }

        private DomainClient getOrCreateDomainClient() {
            if (this.client == null) {
                return DomainClient.Factory.create((ModelControllerClient)this.getOrCreateClient());
            }
            return this.client instanceof DomainClient ? (DomainClient)this.client : DomainClient.Factory.create((ModelControllerClient)this.client);
        }
    }
}

