/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.util.LinkedHashSet;
import java.util.Set;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.Space;
import org.wildfly.glow.cli.support.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="show-server-versions", sortOptions=true)
public class ShowServerVersionsCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-sp", "--spaces"}, split=",", paramLabel="<space1,space2, ...>")
    Set<String> spaces = new LinkedHashSet<String>();

    @Override
    public Integer call() throws Exception {
        this.print("WildFly server versions in the " + Space.DEFAULT.getName() + " space:");
        this.print(FeaturePacks.getAllVersions());
        for (String space : this.spaces) {
            this.print("WildFly server versions in the " + space + " space:");
            this.print(FeaturePacks.getAllVersions(space));
        }
        this.print("@|bold WildFly server version can be set using the|@ @|fg(yellow) %s=<server version>|@ @|bold option of the|@ @|fg(yellow) %s|@ @|bold command|@", "--server-version", "scan");
        return 0;
    }
}

