/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.annotation.JsonNodeAnnotation;
import com.networknt.schema.regex.RegularExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalPropertiesValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AdditionalPropertiesValidator.class);
    private final boolean allowAdditionalProperties;
    private final JsonSchema additionalPropertiesSchema;
    private final Set<String> allowedProperties;
    private final List<RegularExpression> patternProperties;
    private Boolean hasUnevaluatedPropertiesValidator;

    public AdditionalPropertiesValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ADDITIONAL_PROPERTIES, validationContext);
        JsonNode patternPropertiesNode;
        if (schemaNode.isBoolean()) {
            this.allowAdditionalProperties = schemaNode.booleanValue();
            this.additionalPropertiesSchema = null;
        } else if (schemaNode.isObject()) {
            this.allowAdditionalProperties = true;
            this.additionalPropertiesSchema = validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
        } else {
            this.allowAdditionalProperties = false;
            this.additionalPropertiesSchema = null;
        }
        JsonNode propertiesNode = parentSchema.getSchemaNode().get("properties");
        if (propertiesNode != null) {
            this.allowedProperties = new HashSet<String>();
            Iterator<String> it = propertiesNode.fieldNames();
            while (it.hasNext()) {
                this.allowedProperties.add(it.next());
            }
        } else {
            this.allowedProperties = Collections.emptySet();
        }
        if ((patternPropertiesNode = parentSchema.getSchemaNode().get("patternProperties")) != null) {
            this.patternProperties = new ArrayList<RegularExpression>(patternPropertiesNode.size());
            Iterator<String> it = patternPropertiesNode.fieldNames();
            while (it.hasNext()) {
                this.patternProperties.add(RegularExpression.compile(it.next(), validationContext));
            }
        } else {
            this.patternProperties = Collections.emptyList();
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        return this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    protected Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean walk) {
        boolean collectAnnotations;
        AdditionalPropertiesValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        if (!node.isObject()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> matchedInstancePropertyNames = null;
        boolean bl = collectAnnotations = this.collectAnnotations() || this.collectAnnotations(executionContext);
        if (this.allowAdditionalProperties && collectAnnotations) {
            Iterator<String> it = node.fieldNames();
            while (it.hasNext()) {
                if (matchedInstancePropertyNames == null) {
                    matchedInstancePropertyNames = new LinkedHashSet<String>();
                }
                String fieldName = it.next();
                matchedInstancePropertyNames.add(fieldName);
            }
        }
        LinkedHashSet<ValidationMessage> errors = null;
        Iterator<Map.Entry<String, JsonNode>> it = node.fields();
        while (it.hasNext()) {
            Set<ValidationMessage> results;
            Map.Entry<String, JsonNode> entry = it.next();
            String pname = entry.getKey();
            if (pname.startsWith("#") || this.allowedProperties.contains(pname) || this.handledByPatternProperties(pname)) continue;
            if (!this.allowAdditionalProperties) {
                if (errors == null) {
                    errors = new LinkedHashSet<ValidationMessage>();
                }
                errors.add(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).property(pname)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(pname)).build());
                continue;
            }
            if (this.additionalPropertiesSchema == null || (results = !walk ? this.additionalPropertiesSchema.validate(executionContext, entry.getValue(), rootNode, instanceLocation.append(pname)) : this.additionalPropertiesSchema.walk(executionContext, entry.getValue(), rootNode, instanceLocation.append(pname), true)).isEmpty()) continue;
            if (errors == null) {
                errors = new LinkedHashSet();
            }
            errors.addAll(results);
        }
        if (collectAnnotations) {
            executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(matchedInstancePropertyNames != null ? matchedInstancePropertyNames : Collections.emptySet()).build());
        }
        return errors == null ? Collections.emptySet() : Collections.unmodifiableSet(errors);
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema && node != null) {
            return this.validate(executionContext, node, rootNode, instanceLocation, true);
        }
        if (node == null || !node.isObject()) {
            return Collections.emptySet();
        }
        Iterator<String> it = node.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            if (pname.startsWith("#") || this.allowedProperties.contains(pname) || this.handledByPatternProperties(pname) || !this.allowAdditionalProperties || this.additionalPropertiesSchema == null) continue;
            this.additionalPropertiesSchema.walk(executionContext, node.get(pname), rootNode, instanceLocation.append(pname), shouldValidateSchema);
        }
        return Collections.emptySet();
    }

    private boolean handledByPatternProperties(String pname) {
        for (RegularExpression pattern : this.patternProperties) {
            if (!pattern.matches(pname)) continue;
            return true;
        }
        return false;
    }

    private boolean collectAnnotations() {
        return this.hasUnevaluatedPropertiesValidator();
    }

    private boolean hasUnevaluatedPropertiesValidator() {
        if (this.hasUnevaluatedPropertiesValidator == null) {
            this.hasUnevaluatedPropertiesValidator = this.hasAdjacentKeywordInEvaluationPath("unevaluatedProperties");
        }
        return this.hasUnevaluatedPropertiesValidator;
    }

    @Override
    public void preloadJsonSchema() {
        if (this.additionalPropertiesSchema != null) {
            this.additionalPropertiesSchema.initializeValidators();
        }
        this.collectAnnotations();
    }
}

