/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.wildfly.glow.Space;
import org.wildfly.glow.Utils;
import org.yaml.snakeyaml.Yaml;

public class FeaturePacks {
    private static final String VERSIONS = "versions.yaml";
    private static final String SPACES = "spaces/spaces.yaml";
    private static final String PROVISIONING_FILE_RADICAL = "/provisioning-";
    private static final String TECH_PREVIEW = "/tech-preview/";
    public static final String URL_PROPERTY = "wildfly-glow-galleon-feature-packs-url";

    public static Path getFeaturePacks(String version, String context, boolean techPreview) throws Exception {
        return FeaturePacks.getFeaturePacks(Space.DEFAULT, version, context, techPreview);
    }

    public static Path getFeaturePacks(Space space, String version, String context, boolean techPreview) throws Exception {
        try {
            String rootURL = FeaturePacks.getFeaturePacksURL(space);
            Yaml yaml = new Yaml();
            Map map = (Map)yaml.load(new URI(FeaturePacks.getFeaturePacksURL() + VERSIONS).toURL().openStream());
            if (version == null) {
                version = (String)map.get("latest");
            } else {
                String[] versions = ((String)map.get("versions")).split(",");
                boolean found = false;
                for (String v : versions) {
                    if (!v.trim().equals(version)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new Exception("The server version " + version + " doesn't exist.");
                }
            }
            Path p = Files.createTempFile("glow-provisioning-", context, new FileAttribute[0]);
            try (InputStream in = new URL(rootURL + version + (techPreview ? TECH_PREVIEW : "") + PROVISIONING_FILE_RADICAL + context + ".xml").openStream();){
                Files.copy(in, p, StandardCopyOption.REPLACE_EXISTING);
            }
            p.toFile().deleteOnExit();
            return p;
        }
        catch (Exception ex) {
            throw new Exception("Exception occured while retrieving known Galleon feature-packs for version " + version + ". Cause: " + ex.getLocalizedMessage());
        }
    }

    public static String getFeaturePacksURL() throws Exception {
        return FeaturePacks.getFeaturePacksURL(Space.DEFAULT);
    }

    public static String getFeaturePacksURL(Space space) throws Exception {
        Object rootURL = Utils.getConfigEntry(URL_PROPERTY);
        if (rootURL == null) {
            throw new Exception("No wildfly-glow-galleon-feature-packs-url entry found");
        }
        if (!((String)rootURL).endsWith("/")) {
            rootURL = (String)rootURL + "/";
        }
        if (Space.DEFAULT != space) {
            rootURL = (String)rootURL + "/spaces/" + space.getName() + "/";
        }
        return rootURL;
    }

    public static Set<String> getAllVersions() throws Exception {
        String rootURL = FeaturePacks.getFeaturePacksURL();
        TreeSet<String> set = new TreeSet<String>();
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(new URI(rootURL + VERSIONS).toURL().openStream());
        for (String v : Arrays.asList(((String)map.get("versions")).split(","))) {
            set.add(v.trim());
        }
        return set;
    }

    public static Set<String> getAllVersions(String spaceName) throws Exception {
        Space space = FeaturePacks.getSpace(spaceName);
        String rootURL = FeaturePacks.getFeaturePacksURL(space);
        TreeSet<String> set = new TreeSet<String>();
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(new URI(rootURL + VERSIONS).toURL().openStream());
        for (String v : Arrays.asList(((String)map.get("versions")).split(","))) {
            set.add(v.trim());
        }
        return set;
    }

    public static List<Space> getAllSpaces() throws Exception {
        String rootURL = FeaturePacks.getFeaturePacksURL();
        ArrayList<Space> lst = new ArrayList<Space>();
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(new URI(rootURL + SPACES).toURL().openStream());
        List spaces = (List)map.get("spaces");
        for (Map space : spaces) {
            lst.add(new Space((String)space.get("name"), (String)space.get("description")));
        }
        return lst;
    }

    public static Space getSpace(String spaceName) throws Exception {
        String rootURL = FeaturePacks.getFeaturePacksURL();
        ArrayList lst = new ArrayList();
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(new URI(rootURL + SPACES).toURL().openStream());
        List spaces = (List)map.get("spaces");
        for (Map space : spaces) {
            if (!((String)space.get("name")).equals(spaceName)) continue;
            return new Space((String)space.get("name"), (String)space.get("description"));
        }
        List<Space> knownSpaces = FeaturePacks.getAllSpaces();
        StringBuilder builder = new StringBuilder();
        for (Space space : knownSpaces) {
            builder.append(space.getName() + " ");
        }
        throw new Exception("Space " + spaceName + " doesn't exist. Known spaces are: " + builder.toString());
    }

    public static String getLatestVersion() throws Exception {
        String rootURL = FeaturePacks.getFeaturePacksURL();
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(new URI(rootURL + VERSIONS).toURL().openStream());
        return (String)map.get("latest");
    }
}

