/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.ArtifactTransferException;
import org.wildfly.channel.Blocklist;
import org.wildfly.channel.BlocklistCoordinate;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.ChannelManifestMapper;
import org.wildfly.channel.CyclicDependencyException;
import org.wildfly.channel.ManifestRequirement;
import org.wildfly.channel.NoStreamFoundException;
import org.wildfly.channel.Repository;
import org.wildfly.channel.Stream;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.UnresolvedRequiredManifestException;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channel.version.VersionMatcher;

class ChannelImpl
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(ChannelImpl.class);
    private final Channel channelDefinition;
    private Channel resolvedChannel;
    private List<ChannelImpl> requiredChannels = Collections.emptyList();
    private ChannelManifest channelManifest;
    private MavenVersionsResolver resolver;
    private boolean dependency = false;
    public Optional<Blocklist> blocklist = Optional.empty();
    private ChannelManifestCoordinate resolvedCoordinate;

    public ChannelManifest getManifest() {
        return this.channelManifest;
    }

    public ChannelImpl(Channel channelDefinition) {
        this.channelDefinition = channelDefinition;
    }

    void init(MavenVersionsResolver.Factory factory, List<ChannelImpl> channels) {
        BlocklistCoordinate blocklistCoordinate;
        if (this.resolver != null) {
            return;
        }
        this.resolver = factory.create(this.channelDefinition.getRepositories());
        Channel.Builder resolvedChannelBuilder = new Channel.Builder(this.channelDefinition);
        if (this.channelDefinition.getManifestCoordinate() != null) {
            ChannelManifestCoordinate coordinate = this.resolveManifestVersion(this.channelDefinition);
            resolvedChannelBuilder.setManifestCoordinate(coordinate);
            this.channelManifest = this.resolveManifest(coordinate);
        } else {
            this.channelManifest = new ChannelManifest(null, null, null, Collections.emptyList());
        }
        List<ManifestRequirement> manifestRequirements = this.channelManifest.getManifestRequirements();
        if (!manifestRequirements.isEmpty()) {
            this.requiredChannels = new ArrayList<ChannelImpl>();
        }
        for (ManifestRequirement manifestRequirement : manifestRequirements) {
            ChannelImpl foundChannel = this.findRequiredChannel(factory, channels, manifestRequirement);
            this.requiredChannels.add(foundChannel);
        }
        if (this.channelDefinition.getBlocklistCoordinate() != null && (blocklistCoordinate = this.resolveBlocklistVersion(this.channelDefinition)) != null) {
            resolvedChannelBuilder.setBlocklistCoordinate(blocklistCoordinate);
            List<URL> urls = this.resolver.resolveChannelMetadata(List.of(blocklistCoordinate));
            this.blocklist = urls.stream().map(Blocklist::from).findFirst();
        }
        this.resolvedChannel = resolvedChannelBuilder.build();
    }

    private ChannelImpl findRequiredChannel(MavenVersionsResolver.Factory factory, List<ChannelImpl> channels, ManifestRequirement manifestRequirement) {
        ChannelImpl foundChannel = null;
        for (ChannelImpl c : channels) {
            if (c.getManifest() == null) {
                c.init(factory, channels);
            }
            if (!manifestRequirement.getId().equals(c.getManifest().getId())) continue;
            foundChannel = c;
            break;
        }
        if (foundChannel == null) {
            if (manifestRequirement.getMavenCoordinate() == null) {
                throw new UnresolvedRequiredManifestException("Manifest with ID " + manifestRequirement.getId() + " is not available", manifestRequirement.getId());
            }
            foundChannel = this.createNewChannelFromMaven(factory, channels, manifestRequirement);
        }
        this.checkForCycles(foundChannel);
        foundChannel.markAsDependency();
        return foundChannel;
    }

    private ChannelImpl createNewChannelFromMaven(MavenVersionsResolver.Factory factory, List<ChannelImpl> channels, ManifestRequirement manifestRequirement) {
        String groupId = manifestRequirement.getGroupId();
        String artifactId = manifestRequirement.getArtifactId();
        String version = manifestRequirement.getVersion();
        if (version == null) {
            Set<String> versions = this.resolver.getAllVersions(groupId, artifactId, "yaml", "manifest");
            Optional<String> latest = VersionMatcher.getLatestVersion(versions);
            version = latest.orElseThrow(() -> new RuntimeException(String.format("Can not determine the latest version for Maven artifact %s:%s:%s:%s", groupId, artifactId, "yaml", "manifest")));
        }
        ChannelImpl requiredChannel = new ChannelImpl(new Channel(null, null, null, this.channelDefinition.getRepositories(), new ChannelManifestCoordinate(groupId, artifactId, version), null, Channel.NoStreamStrategy.NONE));
        try {
            requiredChannel.init(factory, channels);
        }
        catch (UnresolvedMavenArtifactException e) {
            throw new UnresolvedRequiredManifestException("Manifest with ID " + manifestRequirement.getId() + " is not available", manifestRequirement.getId(), e);
        }
        return requiredChannel;
    }

    private void checkForCycles(ChannelImpl foundChannel) {
        String manifestId = this.getManifest().getId();
        if (foundChannel.getManifest().getId() != null && foundChannel.getManifest().getId().equals(manifestId)) {
            throw new CyclicDependencyException("Illegal manifest dependency: " + manifestId + "->" + foundChannel.getManifest().getId());
        }
        if (foundChannel.requiredChannels.stream().map(ChannelImpl::getManifest).map(ChannelManifest::getId).filter(id -> id != null && id.equals(manifestId)).findFirst().isPresent()) {
            throw new CyclicDependencyException("Illegal manifest dependency: " + manifestId + "->" + foundChannel.getManifest().getId());
        }
        for (ChannelImpl requiredChannel : foundChannel.requiredChannels) {
            this.checkForCycles(requiredChannel);
        }
    }

    @Override
    public void close() {
        if (this.resolver != null) {
            for (ChannelImpl requiredChannel : this.requiredChannels) {
                requiredChannel.close();
            }
            this.resolver.close();
            this.resolver = null;
        }
    }

    private void markAsDependency() {
        this.dependency = true;
    }

    boolean isDependency() {
        return this.dependency;
    }

    Channel getResolvedChannelDefinition() {
        return this.resolvedChannel;
    }

    public Blocklist getBlocklist() {
        return this.blocklist.orElse(null);
    }

    private Set<Repository> attemptedRepositories() {
        return new HashSet<Repository>(this.channelDefinition.getRepositories());
    }

    private ChannelManifestCoordinate resolveManifestVersion(Channel baseDefinition) {
        ChannelManifestCoordinate manifestCoordinate = baseDefinition.getManifestCoordinate();
        if (manifestCoordinate.getUrl() != null || manifestCoordinate.getMaven().getVersion() != null) {
            return manifestCoordinate;
        }
        Set<String> allVersions = this.resolver.getAllVersions(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), manifestCoordinate.getExtension(), manifestCoordinate.getClassifier());
        Optional<String> latestVersion = VersionMatcher.getLatestVersion(allVersions);
        String version = latestVersion.orElseThrow(() -> new ArtifactTransferException(String.format("Unable to resolve the latest version of channel metadata %s:%s", manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId()), Collections.singleton(new ArtifactCoordinate(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), manifestCoordinate.getExtension(), manifestCoordinate.getClassifier(), "")), this.attemptedRepositories()));
        return new ChannelManifestCoordinate(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), version);
    }

    private BlocklistCoordinate resolveBlocklistVersion(Channel baseDefinition) {
        BlocklistCoordinate blocklistCoordinate = baseDefinition.getBlocklistCoordinate();
        if (blocklistCoordinate == null) {
            return null;
        }
        if (blocklistCoordinate.getUrl() != null || blocklistCoordinate.getMaven().getVersion() != null) {
            return blocklistCoordinate;
        }
        Set<String> allVersions = this.resolver.getAllVersions(blocklistCoordinate.getGroupId(), blocklistCoordinate.getArtifactId(), blocklistCoordinate.getExtension(), blocklistCoordinate.getClassifier());
        Optional<String> latestVersion = VersionMatcher.getLatestVersion(allVersions);
        return latestVersion.map(v -> new BlocklistCoordinate(blocklistCoordinate.getGroupId(), blocklistCoordinate.getArtifactId(), (String)v)).orElse(null);
    }

    private ChannelManifest resolveManifest(ChannelManifestCoordinate manifestCoordinate) throws UnresolvedMavenArtifactException {
        if (manifestCoordinate.getUrl() == null && manifestCoordinate.getMaven().getVersion() == null) {
            Set<String> allVersions = this.resolver.getAllVersions(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), manifestCoordinate.getExtension(), manifestCoordinate.getClassifier());
            Optional<String> latestVersion = VersionMatcher.getLatestVersion(allVersions);
            String version = latestVersion.orElseThrow(() -> new ArtifactTransferException(String.format("Unable to resolve the latest version of channel metadata %s:%s", manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId()), Collections.singleton(new ArtifactCoordinate(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), manifestCoordinate.getExtension(), manifestCoordinate.getClassifier(), "")), this.attemptedRepositories()));
            this.resolvedCoordinate = new ChannelManifestCoordinate(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), version);
        } else {
            this.resolvedCoordinate = manifestCoordinate;
        }
        return this.resolver.resolveChannelMetadata(List.of(this.resolvedCoordinate)).stream().map(ChannelManifestMapper::from).findFirst().orElseThrow();
    }

    Optional<ResolveLatestVersionResult> resolveLatestVersion(String groupId, String artifactId, String extension, String classifier, String baseVersion) {
        Optional<Stream> foundStream;
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(this.resolver);
        Set<Object> blocklistedVersions = Collections.emptySet();
        if (this.blocklist.isPresent()) {
            blocklistedVersions = this.blocklist.get().getVersionsFor(groupId, artifactId);
        }
        if (!(foundStream = this.channelManifest.findStreamFor(groupId, artifactId)).isPresent()) {
            HashMap<String, ChannelImpl> foundVersions = new HashMap<String, ChannelImpl>();
            for (ChannelImpl requiredChannel : this.requiredChannels) {
                Optional<ResolveLatestVersionResult> found = requiredChannel.resolveLatestVersion(groupId, artifactId, extension, classifier, baseVersion);
                if (!found.isPresent()) continue;
                foundVersions.put(found.get().version, found.get().channel);
            }
            foundVersions.keySet().removeAll(blocklistedVersions);
            Optional<String> foundVersionInRequiredChannels = foundVersions.keySet().stream().sorted(VersionMatcher.COMPARATOR.reversed()).findFirst();
            if (foundVersionInRequiredChannels.isPresent()) {
                return Optional.of(new ResolveLatestVersionResult(foundVersionInRequiredChannels.get(), (ChannelImpl)foundVersions.get(foundVersionInRequiredChannels.get())));
            }
            switch (this.channelDefinition.getNoStreamStrategy()) {
                case LATEST: {
                    Set<String> versions = this.resolver.getAllVersions(groupId, artifactId, extension, classifier);
                    versions.removeAll(blocklistedVersions);
                    Optional<String> latestVersion = versions.stream().sorted(VersionMatcher.COMPARATOR.reversed()).findFirst();
                    if (latestVersion.isPresent()) {
                        return Optional.of(new ResolveLatestVersionResult(latestVersion.get(), this));
                    }
                    return Optional.empty();
                }
                case MAVEN_LATEST: {
                    try {
                        String latestMetadataVersion = this.resolver.getMetadataLatestVersion(groupId, artifactId);
                        if (blocklistedVersions.contains(latestMetadataVersion)) {
                            return Optional.empty();
                        }
                        return Optional.of(new ResolveLatestVersionResult(latestMetadataVersion, this));
                    }
                    catch (NoStreamFoundException e) {
                        LOG.debugf((Throwable)e, "Metadata resolution for %s:%s failed in channel %s", (Object)groupId, (Object)artifactId, (Object)this.getResolvedChannelDefinition().getName());
                        return Optional.empty();
                    }
                }
                case MAVEN_RELEASE: {
                    try {
                        String releaseMetadataVersion = this.resolver.getMetadataReleaseVersion(groupId, artifactId);
                        if (blocklistedVersions.contains(releaseMetadataVersion)) {
                            return Optional.empty();
                        }
                        return Optional.of(new ResolveLatestVersionResult(releaseMetadataVersion, this));
                    }
                    catch (NoStreamFoundException e) {
                        LOG.debugf((Throwable)e, "Metadata resolution for %s:%s failed in channel %s", (Object)groupId, (Object)artifactId, (Object)this.getResolvedChannelDefinition().getName());
                        return Optional.empty();
                    }
                }
            }
            return Optional.empty();
        }
        Stream stream = foundStream.get();
        Optional<Object> foundVersion = Optional.empty();
        if (stream.getVersion() != null) {
            foundVersion = Optional.of(stream.getVersion());
            if (foundVersion.isPresent() && blocklistedVersions.contains(foundVersion.get())) {
                return Optional.empty();
            }
        } else if (stream.getVersionPattern() != null) {
            Set<String> versions = this.resolver.getAllVersions(groupId, artifactId, extension, classifier);
            versions.removeAll(blocklistedVersions);
            foundVersion = foundStream.get().getVersionComparator().matches(versions);
        }
        if (foundVersion.isPresent()) {
            return Optional.of(new ResolveLatestVersionResult((String)foundVersion.get(), this));
        }
        return Optional.empty();
    }

    ResolveArtifactResult resolveArtifact(String groupId, String artifactId, String extension, String classifier, String version) throws UnresolvedMavenArtifactException {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(version);
        Objects.requireNonNull(this.resolver);
        for (ChannelImpl requiredChannel : this.requiredChannels) {
            try {
                return requiredChannel.resolveArtifact(groupId, artifactId, extension, classifier, version);
            }
            catch (UnresolvedMavenArtifactException unresolvedMavenArtifactException) {
            }
        }
        return new ResolveArtifactResult(this.resolver.resolveArtifact(groupId, artifactId, extension, classifier, version), this);
    }

    List<ResolveArtifactResult> resolveArtifacts(List<ArtifactCoordinate> coordinates) throws UnresolvedMavenArtifactException {
        List<File> resolvedArtifacts = this.resolver.resolveArtifacts(coordinates);
        return resolvedArtifacts.stream().map(f -> new ResolveArtifactResult((File)f, this)).collect(Collectors.toList());
    }

    public String toString() {
        return "Channel{channelDefinition=" + this.channelDefinition + ", requiredChannels=" + this.requiredChannels + ", channelManifest=" + this.channelManifest + ", resolver=" + this.resolver + ", dependency=" + this.dependency + ", blocklist=" + this.blocklist + "}";
    }

    static class ResolveArtifactResult {
        File file;
        ChannelImpl channel;

        ResolveArtifactResult(File file, ChannelImpl channel) {
            this.file = file;
            this.channel = channel;
        }
    }

    static class ResolveLatestVersionResult {
        final String version;
        final ChannelImpl channel;

        ResolveLatestVersionResult(String version, ChannelImpl channel) {
            this.version = version;
            this.channel = channel;
        }
    }
}

