/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.ProvisioningUtils;
import org.wildfly.glow.ScanArguments;
import org.wildfly.glow.Space;
import org.wildfly.glow.WildFlyMavenMetadataProvider;
import org.wildfly.glow.cli.support.AbstractCommand;
import org.wildfly.glow.deployment.openshift.api.Deployer;
import org.wildfly.glow.maven.MavenResolver;
import picocli.CommandLine;

@CommandLine.Command(name="show-configuration", sortOptions=true)
public class ShowConfigurationCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;
    @CommandLine.Option(names={"-cc", "--channels"}, paramLabel="<Channels yaml file path>")
    Optional<Path> channelsFile;
    @CommandLine.Option(names={"-sp", "--spaces"}, split=",", paramLabel="<space1,space2, ...>")
    Set<String> spaces = new LinkedHashSet<String>();
    private Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> defaultSpaceFpDependencies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Integer call() throws Exception {
        MavenRepoManager repoManager;
        this.print("Wildfly Glow is retrieving known provisioning configuration...");
        StringBuilder ocBuilder = new StringBuilder();
        ScanArguments.Builder builder = Arguments.scanBuilder();
        List<Channel> channels = Collections.emptyList();
        if (this.channelsFile.isPresent()) {
            String content = Files.readString(this.channelsFile.get());
            channels = ChannelMapper.fromString(content);
            builder.setChannels(channels);
            repoManager = MavenResolver.newMavenResolver(channels);
        } else {
            repoManager = MavenResolver.newMavenResolver();
        }
        Path tmpMetadataDirectory = Files.createTempDirectory("glow-metadata", new FileAttribute[0]);
        try {
            void var8_12;
            WildFlyMavenMetadataProvider metadataProvider = new WildFlyMavenMetadataProvider(repoManager, tmpMetadataDirectory);
            ocBuilder.append("\nDeployers enabled when provisioning to OpenShift:\n");
            for (Deployer deployer : ServiceLoader.load(Deployer.class)) {
                ocBuilder.append("* @|bold " + deployer.getName() + "|@. Enabled when the layer(s) " + deployer.getSupportedLayers() + " is/are discovered.\n");
            }
            this.print(ocBuilder.toString());
            StringBuilder spacesBuilder = new StringBuilder();
            spacesBuilder.append("\nSpaces from which more feature-packs can be used when scanning deployments (use the --spaces option to enable the space(s):\n");
            for (Space space : metadataProvider.getAllSpaces()) {
                spacesBuilder.append("* @|bold " + space.getName() + "|@. " + space.getDescription() + "\n");
            }
            this.print(spacesBuilder.toString());
            String string = "bare-metal";
            if (this.cloud.orElse(false).booleanValue()) {
                String string2 = "cloud";
            }
            if (this.wildflyPreview.orElse(false).booleanValue() && this.channelsFile.isPresent()) {
                throw new Exception("--wildfly-previewcan't be set when --channels is set.");
            }
            if (this.wildflyServerVersion.isPresent() && this.channelsFile.isPresent()) {
                throw new Exception("--server-versioncan't be set when --channels is set.");
            }
            void finalContext = var8_12;
            boolean isLatest = this.wildflyServerVersion.isEmpty();
            String vers = this.wildflyServerVersion.isPresent() ? this.wildflyServerVersion.get() : metadataProvider.getLatestVersion();
            ProvisioningUtils.ProvisioningConsumer consumer = new ProvisioningUtils.ProvisioningConsumer(){
                final /* synthetic */ String val$finalContext;
                final /* synthetic */ String val$vers;
                final /* synthetic */ boolean val$isLatest;
                {
                    this.val$finalContext = string;
                    this.val$vers = string2;
                    this.val$isLatest = bl;
                }

                @Override
                public void consume(Space space, GalleonProvisioningConfig provisioning, Map<String, Layer> all, LayerMapping mapping, Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies) throws Exception {
                    if (Space.DEFAULT.equals(space)) {
                        ShowConfigurationCommand.this.defaultSpaceFpDependencies = fpDependencies;
                    }
                    String configStr = ShowConfigurationCommand.this.dumpConfiguration(space, fpDependencies, this.val$finalContext, this.val$vers, all, mapping, provisioning, this.val$isLatest, ShowConfigurationCommand.this.wildflyPreview.orElse(false), ShowConfigurationCommand.this.provisioningXml.orElse(null));
                    ShowConfigurationCommand.this.print(configStr);
                }
            };
            ProvisioningUtils.traverseProvisioning(Space.DEFAULT, consumer, (String)var8_12, this.provisioningXml.orElse(null), this.wildflyServerVersion.isEmpty(), vers, this.wildflyPreview.orElse(false), channels, repoManager, metadataProvider);
            for (String spaceName : this.spaces) {
                Set<String> versions = metadataProvider.getAllVersions(spaceName);
                if (!versions.contains(vers)) continue;
                Space space = metadataProvider.getSpace(spaceName);
                ProvisioningUtils.traverseProvisioning(space, consumer, (String)var8_12, this.provisioningXml.orElse(null), this.wildflyServerVersion.isEmpty(), vers, this.wildflyPreview.orElse(false), channels, repoManager, metadataProvider);
            }
        }
        finally {
            IoUtils.recursiveDelete(tmpMetadataDirectory);
        }
        return 0;
    }

    private String dumpConfiguration(Space space, Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies, String context, String serverVersion, Map<String, Layer> allLayers, LayerMapping mapping, GalleonProvisioningConfig config, boolean isLatest, boolean techPreview, Path provisioningXml) throws Exception {
        StringBuilder builder = new StringBuilder();
        if (config == null) {
            builder.append("\nFeature-packs in the @|bold ").append(space.getName()).append("|@ space:\n");
            builder.append("No feature-packs found in the " + space.getName() + " space for context " + context + ", server version " + serverVersion + ".");
            return builder.toString();
        }
        if (Space.DEFAULT.equals(space)) {
            if (provisioningXml == null) {
                builder.append("Execution context: ").append(context).append("\n");
                builder.append("Server version: ").append(serverVersion).append(isLatest ? " (latest)" : "").append("\n");
                builder.append("Tech Preview: ").append(techPreview).append("\n");
            } else {
                builder.append("Input provisioning.xml file: ").append(provisioningXml).append("\n");
            }
        }
        builder.append("\nFeature-packs in the @|bold ").append(space.getName()).append("|@ space:\n");
        LinkedHashSet<FeaturePackLocation.ProducerSpec> topLevel = new LinkedHashSet<FeaturePackLocation.ProducerSpec>();
        LinkedHashMap<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID> featurepacks = new LinkedHashMap<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID>();
        block0: for (GalleonFeaturePackConfig fp : config.getFeaturePackDeps()) {
            topLevel.add(fp.getLocation().getProducer());
            for (FeaturePackLocation.FPID fpid : fpDependencies.keySet()) {
                if (!fpid.getProducer().equals(fp.getLocation().getProducer())) continue;
                featurepacks.put(fp.getLocation().getProducer(), fpid);
                continue block0;
            }
        }
        for (FeaturePackLocation.ProducerSpec p : featurepacks.keySet()) {
            FeaturePackLocation.FPID id = (FeaturePackLocation.FPID)featurepacks.get(p);
            builder.append("\nFeature-pack: ").append("@|bold ").append(id).append("|@\n");
            builder.append("Contained layers: ");
            TreeSet<String> layers = new TreeSet<String>();
            Set<FeaturePackLocation.ProducerSpec> deps = fpDependencies.get(id);
            for (Layer l : allLayers.values()) {
                if (l.getFeaturePacks().contains(id)) {
                    layers.add(l.getName());
                }
                if (deps == null) continue;
                for (FeaturePackLocation.ProducerSpec dep : deps) {
                    boolean inDefaultSpace = false;
                    if (!Space.DEFAULT.equals(space)) {
                        for (FeaturePackLocation.FPID fpid : this.defaultSpaceFpDependencies.keySet()) {
                            if (!fpid.getProducer().equals(dep)) continue;
                            inDefaultSpace = true;
                            break;
                        }
                    }
                    if (topLevel.contains(dep) || inDefaultSpace) continue;
                    for (FeaturePackLocation.FPID fpid : l.getFeaturePacks()) {
                        if (!fpid.getProducer().equals(dep)) continue;
                        layers.add(l.getName());
                    }
                }
            }
            topLevel.addAll(deps);
            builder.append(layers).append("\n");
        }
        return builder.toString();
    }
}

