/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.wildfly.channel.ManifestRequirement;
import org.wildfly.channel.Stream;

public class ChannelManifest {
    public static final String CLASSIFIER = "manifest";
    public static final String EXTENSION = "yaml";
    private final String schemaVersion;
    private final String name;
    private final String id;
    private final String logicalVersion;
    private final String description;
    private Set<Stream> streams;
    private List<ManifestRequirement> manifestRequirements;

    public ChannelManifest(String name, String id, String description, Collection<Stream> streams) {
        this("1.1.0", name, id, null, description, Collections.emptyList(), streams);
    }

    public ChannelManifest(String name, String id, String logicalVersion, String description, Collection<ManifestRequirement> manifestRequirements, Collection<Stream> streams) {
        this("1.1.0", name, id, logicalVersion, description, manifestRequirements, streams);
    }

    @JsonCreator
    @JsonPropertyOrder(value={"schemaVersion", "name", "description", "streams"})
    public ChannelManifest(@JsonProperty(value="schemaVersion", required=true) String schemaVersion, @JsonProperty(value="name") String name, @JsonProperty(value="id") String id, @JsonProperty(value="logical-version") String logicalVersion, @JsonProperty(value="description") String description, @JsonProperty(value="requires") Collection<ManifestRequirement> manifestRequirements, @JsonProperty(value="streams") Collection<Stream> streams) {
        this.schemaVersion = schemaVersion;
        this.name = name;
        this.id = id;
        this.logicalVersion = logicalVersion;
        this.description = description;
        this.manifestRequirements = new ArrayList<ManifestRequirement>();
        if (manifestRequirements != null) {
            this.manifestRequirements.addAll(manifestRequirements);
        }
        this.streams = new TreeSet<Stream>();
        if (streams != null) {
            this.streams.addAll(streams);
        }
    }

    @JsonInclude
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLogicalVersion() {
        return this.logicalVersion;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="requires")
    public List<ManifestRequirement> getManifestRequirements() {
        return this.manifestRequirements;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Collection<Stream> getStreams() {
        return this.streams;
    }

    public Optional<Stream> findStreamFor(String groupId, String artifactId) {
        Optional<Stream> stream = this.streams.stream().filter(s -> s.getGroupId().equals(groupId) && s.getArtifactId().equals(artifactId)).findFirst();
        if (stream.isPresent()) {
            return stream;
        }
        stream = this.streams.stream().filter(s -> s.getGroupId().equals(groupId) && s.getArtifactId().equals("*")).findFirst();
        return stream;
    }

    public String toString() {
        return "ChannelManifest{schemaVersion='" + this.schemaVersion + "', name='" + this.name + "', id='" + this.id + "', description='" + this.description + "', streams=" + this.streams + ", manifestRequirements=" + this.manifestRequirements + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelManifest that = (ChannelManifest)o;
        return Objects.equals(this.schemaVersion, that.schemaVersion) && Objects.equals(this.name, that.name) && Objects.equals(this.id, that.id) && Objects.equals(this.description, that.description) && Objects.equals(this.streams, that.streams) && Objects.equals(this.manifestRequirements, that.manifestRequirements);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.name, this.id, this.description, this.streams, this.manifestRequirements);
    }

    public static class Builder {
        private String schemaVersion;
        private String name;
        private String id;
        private String logicalVersion;
        private String description;
        private List<Stream> streams;
        private List<ManifestRequirement> manifestRequirements;

        public ChannelManifest build() {
            return new ChannelManifest(this.schemaVersion, this.name, this.id, this.logicalVersion, this.description, this.manifestRequirements, this.streams);
        }

        public Builder setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public void setLogicalVersion(String logicalVersion) {
            this.logicalVersion = logicalVersion;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addStreams(Stream ... stream) {
            if (this.streams == null) {
                this.streams = new ArrayList<Stream>();
            }
            this.streams.addAll(Arrays.asList(stream));
            return this;
        }

        public Builder addManifestRequirements(ManifestRequirement ... manifestRequirements) {
            if (this.manifestRequirements == null) {
                this.manifestRequirements = new ArrayList<ManifestRequirement>();
            }
            this.manifestRequirements.addAll(Arrays.asList(manifestRequirements));
            return this;
        }
    }
}

