/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.glow.Space;
import org.wildfly.glow.WildFlyMavenMetadataProvider;
import org.wildfly.glow.cli.support.AbstractCommand;
import org.wildfly.glow.maven.MavenResolver;
import picocli.CommandLine;

@CommandLine.Command(name="show-server-versions", sortOptions=true)
public class ShowServerVersionsCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-sp", "--spaces"}, split=",", paramLabel="<space1,space2, ...>")
    Set<String> spaces = new LinkedHashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        this.print("WildFly server versions in the " + Space.DEFAULT.getName() + " space:");
        Path tmpMetadataDirectory = Files.createTempDirectory("glow-metadata", new FileAttribute[0]);
        try {
            WildFlyMavenMetadataProvider metadataProvider = new WildFlyMavenMetadataProvider(MavenResolver.newMavenResolver(), tmpMetadataDirectory);
            this.print(metadataProvider.getAllVersions());
            for (String space : this.spaces) {
                this.print("WildFly server versions in the " + space + " space:");
                this.print(metadataProvider.getAllVersions(space));
            }
            this.print("@|bold WildFly server version can be set using the|@ @|fg(yellow) %s=<server version>|@ @|bold option of the|@ @|fg(yellow) %s|@ @|bold command|@", "--server-version", "scan");
            Integer n = 0;
            return n;
        }
        finally {
            IoUtils.recursiveDelete(tmpMetadataDirectory);
        }
    }
}

