/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.impl;

import java.io.InputStream;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.APIVersion;
import org.jboss.galleon.api.GalleonFeaturePack;
import org.jboss.galleon.api.GalleonFeaturePackDescription;
import org.jboss.galleon.impl.FeaturePackLightXmlParser;
import org.jboss.galleon.impl.ProvisioningLightXmlParser;
import org.jboss.galleon.impl.VersionMatcher;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;

public class ProvisioningUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFeaturePack(Path path) {
        boolean bl;
        Path tmp = null;
        try {
            tmp = Files.createTempDirectory("galleon-tmp", new FileAttribute[0]);
            Path spec = ProvisioningUtil.getFeaturePackSpec(path, tmp);
            bl = Files.exists(spec, new LinkOption[0]);
        }
        catch (Exception ex) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                IoUtils.recursiveDelete(tmp);
                throw throwable;
            }
            IoUtils.recursiveDelete(tmp);
            return bl2;
        }
        IoUtils.recursiveDelete(tmp);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FeaturePackLocation.FPID getFeaturePackProducer(Path path) throws Exception {
        FeaturePackLocation.FPID fPID;
        Path tmp = null;
        try {
            tmp = Files.createTempDirectory("galleon-tmp", new FileAttribute[0]);
            Path spec = ProvisioningUtil.getFeaturePackSpec(path, tmp);
            GalleonFeaturePackDescription deps = FeaturePackLightXmlParser.parseDescription(spec);
            fPID = deps.getProducer();
        }
        catch (Throwable throwable) {
            IoUtils.recursiveDelete(tmp);
            throw throwable;
        }
        IoUtils.recursiveDelete(tmp);
        return fPID;
    }

    public static String getCoreVersion(Path resolvedFP, String currentVersion, Path tmp, UniverseResolver universeResolver) throws Exception {
        Path spec = ProvisioningUtil.getFeaturePackSpec(resolvedFP, tmp);
        String fpVersion = FeaturePackLightXmlParser.parseVersion(spec);
        if (fpVersion != null && !fpVersion.isEmpty() && VersionMatcher.COMPARATOR.compare(fpVersion, currentVersion) > 0) {
            currentVersion = fpVersion;
        }
        return currentVersion;
    }

    public static String getMavenCoords(GalleonFeaturePack fp) {
        return fp.getMavenCoords();
    }

    public static Class<?> getCallerClass(URLClassLoader loader) throws ProvisioningException {
        try {
            return Class.forName("org.jboss.galleon.caller.ProvisioningContextBuilderImpl", true, loader);
        }
        catch (Exception ex) {
            throw new ProvisioningException(ex);
        }
    }

    public static String getCoreVersion(Path provisioning, UniverseResolver universeResolver, Path tmp) throws ProvisioningException {
        List<FeaturePackLocation.FPID> featurePacks = ProvisioningLightXmlParser.parse(provisioning);
        return ProvisioningUtil.getCoreVersion(featurePacks, APIVersion.getVersion(), universeResolver, tmp);
    }

    public static String getCoreVersion(InputStream stream, UniverseResolver universeResolver, Path tmp) throws ProvisioningException {
        List<FeaturePackLocation.FPID> featurePacks = ProvisioningLightXmlParser.parse(stream);
        return ProvisioningUtil.getCoreVersion(featurePacks, APIVersion.getVersion(), universeResolver, tmp);
    }

    private static String getCoreVersion(List<FeaturePackLocation.FPID> featurePacks, String currentMax, UniverseResolver universeResolver, Path tmp) throws ProvisioningException {
        try {
            String version = currentMax;
            for (FeaturePackLocation.FPID fpid : featurePacks) {
                Path resolvedFP = universeResolver.resolve(fpid.getLocation());
                Path spec = ProvisioningUtil.getFeaturePackSpec(resolvedFP, tmp);
                String fpVersion = FeaturePackLightXmlParser.parseVersion(spec);
                if (fpVersion == null || fpVersion.isEmpty() || VersionMatcher.COMPARATOR.compare(fpVersion, version) <= 0) continue;
                version = fpVersion;
            }
            return version;
        }
        catch (Exception ex) {
            throw new ProvisioningException(ex);
        }
    }

    public static GalleonFeaturePackDescription getFeaturePackDescription(Path fp) throws ProvisioningException {
        GalleonFeaturePackDescription galleonFeaturePackDescription;
        Path tmp = null;
        try {
            tmp = Files.createTempDirectory("galleon-tmp", new FileAttribute[0]);
            Path spec = ProvisioningUtil.getFeaturePackSpec(fp, tmp);
            galleonFeaturePackDescription = FeaturePackLightXmlParser.parseDescription(spec);
        }
        catch (Exception ex) {
            try {
                throw new ProvisioningException(ex);
            }
            catch (Throwable throwable) {
                IoUtils.recursiveDelete(tmp);
                throw throwable;
            }
        }
        IoUtils.recursiveDelete(tmp);
        return galleonFeaturePackDescription;
    }

    private static Path getFeaturePackSpec(Path resolvedFP, Path tmp) throws Exception {
        Path fpDir = tmp.resolve(resolvedFP.getFileName());
        Files.createDirectories(fpDir, new FileAttribute[0]);
        Path target = fpDir.resolve("fp-spec.xml");
        if (!Files.exists(target, new LinkOption[0])) {
            try (FileSystem fs = ZipUtils.newFileSystem(resolvedFP);){
                Path spec = fs.getPath("feature-pack.xml", new String[0]);
                ZipUtils.copyFromZip(spec, target);
            }
        }
        return target;
    }
}

