/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.wildfly.channel.ArtifactCoordinate;

public class MavenArtifact
extends ArtifactCoordinate {
    private final File file;
    private final Optional<String> channelName;

    public MavenArtifact(String groupId, String artifactId, String extension, String classifier, String version, File file) {
        this(groupId, artifactId, extension, classifier, version, file, null);
    }

    public MavenArtifact(String groupId, String artifactId, String extension, String classifier, String version, File file, String channelName) {
        super(groupId, artifactId, extension, classifier, version);
        Objects.requireNonNull(file);
        this.file = file;
        this.channelName = Optional.ofNullable(channelName);
    }

    public File getFile() {
        return this.file;
    }

    public Optional<String> getChannelName() {
        return this.channelName;
    }

    @Override
    public String toString() {
        return "MavenArtifact{groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', extension='" + this.extension + "', classifier='" + this.classifier + "', version='" + this.version + "', file=" + this.file + "', channelName=" + this.channelName + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifact artifact = (MavenArtifact)o;
        return Objects.equals(this.file, artifact.file) && Objects.equals(this.channelName, artifact.channelName) && Objects.equals(this.groupId, artifact.groupId) && Objects.equals(this.artifactId, artifact.artifactId) && Objects.equals(this.extension, artifact.extension) && Objects.equals(this.classifier, artifact.classifier) && Objects.equals(this.version, artifact.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.file, this.channelName, this.groupId, this.artifactId, this.extension, this.classifier, this.version);
    }
}

