/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.AlibabaCloudPlatformStatus;
import io.fabric8.openshift.api.model.config.v1.AlibabaCloudResourceTag;
import io.fabric8.openshift.api.model.config.v1.AlibabaCloudResourceTagBuilder;
import io.fabric8.openshift.api.model.config.v1.AlibabaCloudResourceTagFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AlibabaCloudPlatformStatusFluent<A extends AlibabaCloudPlatformStatusFluent<A>>
extends BaseFluent<A> {
    private String region;
    private String resourceGroupID;
    private ArrayList<AlibabaCloudResourceTagBuilder> resourceTags = new ArrayList();
    private Map<String, Object> additionalProperties;

    public AlibabaCloudPlatformStatusFluent() {
    }

    public AlibabaCloudPlatformStatusFluent(AlibabaCloudPlatformStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AlibabaCloudPlatformStatus instance) {
        AlibabaCloudPlatformStatus alibabaCloudPlatformStatus = instance = instance != null ? instance : new AlibabaCloudPlatformStatus();
        if (instance != null) {
            this.withRegion(instance.getRegion());
            this.withResourceGroupID(instance.getResourceGroupID());
            this.withResourceTags(instance.getResourceTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public String getResourceGroupID() {
        return this.resourceGroupID;
    }

    public A withResourceGroupID(String resourceGroupID) {
        this.resourceGroupID = resourceGroupID;
        return (A)this;
    }

    public boolean hasResourceGroupID() {
        return this.resourceGroupID != null;
    }

    public A addToResourceTags(int index, AlibabaCloudResourceTag item) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        AlibabaCloudResourceTagBuilder builder = new AlibabaCloudResourceTagBuilder(item);
        if (index < 0 || index >= this.resourceTags.size()) {
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        } else {
            this._visitables.get("resourceTags").add(index, builder);
            this.resourceTags.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceTags(int index, AlibabaCloudResourceTag item) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        AlibabaCloudResourceTagBuilder builder = new AlibabaCloudResourceTagBuilder(item);
        if (index < 0 || index >= this.resourceTags.size()) {
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        } else {
            this._visitables.get("resourceTags").set(index, builder);
            this.resourceTags.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceTags(AlibabaCloudResourceTag ... items) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        for (AlibabaCloudResourceTag item : items) {
            AlibabaCloudResourceTagBuilder builder = new AlibabaCloudResourceTagBuilder(item);
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceTags(Collection<AlibabaCloudResourceTag> items) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        for (AlibabaCloudResourceTag item : items) {
            AlibabaCloudResourceTagBuilder builder = new AlibabaCloudResourceTagBuilder(item);
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceTags(AlibabaCloudResourceTag ... items) {
        if (this.resourceTags == null) {
            return (A)this;
        }
        for (AlibabaCloudResourceTag item : items) {
            AlibabaCloudResourceTagBuilder builder = new AlibabaCloudResourceTagBuilder(item);
            this._visitables.get("resourceTags").remove(builder);
            this.resourceTags.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceTags(Collection<AlibabaCloudResourceTag> items) {
        if (this.resourceTags == null) {
            return (A)this;
        }
        for (AlibabaCloudResourceTag item : items) {
            AlibabaCloudResourceTagBuilder builder = new AlibabaCloudResourceTagBuilder(item);
            this._visitables.get("resourceTags").remove(builder);
            this.resourceTags.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceTags(Predicate<AlibabaCloudResourceTagBuilder> predicate) {
        if (this.resourceTags == null) {
            return (A)this;
        }
        Iterator<AlibabaCloudResourceTagBuilder> each = this.resourceTags.iterator();
        Object visitables = this._visitables.get("resourceTags");
        while (each.hasNext()) {
            AlibabaCloudResourceTagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<AlibabaCloudResourceTag> buildResourceTags() {
        return this.resourceTags != null ? AlibabaCloudPlatformStatusFluent.build(this.resourceTags) : null;
    }

    public AlibabaCloudResourceTag buildResourceTag(int index) {
        return this.resourceTags.get(index).build();
    }

    public AlibabaCloudResourceTag buildFirstResourceTag() {
        return this.resourceTags.get(0).build();
    }

    public AlibabaCloudResourceTag buildLastResourceTag() {
        return this.resourceTags.get(this.resourceTags.size() - 1).build();
    }

    public AlibabaCloudResourceTag buildMatchingResourceTag(Predicate<AlibabaCloudResourceTagBuilder> predicate) {
        for (AlibabaCloudResourceTagBuilder item : this.resourceTags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceTag(Predicate<AlibabaCloudResourceTagBuilder> predicate) {
        for (AlibabaCloudResourceTagBuilder item : this.resourceTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceTags(List<AlibabaCloudResourceTag> resourceTags) {
        if (this.resourceTags != null) {
            this._visitables.get("resourceTags").clear();
        }
        if (resourceTags != null) {
            this.resourceTags = new ArrayList();
            for (AlibabaCloudResourceTag item : resourceTags) {
                this.addToResourceTags(item);
            }
        } else {
            this.resourceTags = null;
        }
        return (A)this;
    }

    public A withResourceTags(AlibabaCloudResourceTag ... resourceTags) {
        if (this.resourceTags != null) {
            this.resourceTags.clear();
            this._visitables.remove("resourceTags");
        }
        if (resourceTags != null) {
            for (AlibabaCloudResourceTag item : resourceTags) {
                this.addToResourceTags(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceTags() {
        return this.resourceTags != null && !this.resourceTags.isEmpty();
    }

    public A addNewResourceTag(String key, String value) {
        return this.addToResourceTags(new AlibabaCloudResourceTag(key, value));
    }

    public ResourceTagsNested<A> addNewResourceTag() {
        return new ResourceTagsNested(-1, null);
    }

    public ResourceTagsNested<A> addNewResourceTagLike(AlibabaCloudResourceTag item) {
        return new ResourceTagsNested(-1, item);
    }

    public ResourceTagsNested<A> setNewResourceTagLike(int index, AlibabaCloudResourceTag item) {
        return new ResourceTagsNested(index, item);
    }

    public ResourceTagsNested<A> editResourceTag(int index) {
        if (this.resourceTags.size() <= index) {
            throw new RuntimeException("Can't edit resourceTags. Index exceeds size.");
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public ResourceTagsNested<A> editFirstResourceTag() {
        if (this.resourceTags.size() == 0) {
            throw new RuntimeException("Can't edit first resourceTags. The list is empty.");
        }
        return this.setNewResourceTagLike(0, this.buildResourceTag(0));
    }

    public ResourceTagsNested<A> editLastResourceTag() {
        int index = this.resourceTags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceTags. The list is empty.");
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public ResourceTagsNested<A> editMatchingResourceTag(Predicate<AlibabaCloudResourceTagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceTags.size(); ++i) {
            if (!predicate.test(this.resourceTags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceTags. No match found.");
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlibabaCloudPlatformStatusFluent that = (AlibabaCloudPlatformStatusFluent)o;
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.resourceGroupID, that.resourceGroupID)) {
            return false;
        }
        if (!Objects.equals(this.resourceTags, that.resourceTags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.region, this.resourceGroupID, this.resourceTags, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.resourceGroupID != null) {
            sb.append("resourceGroupID:");
            sb.append(this.resourceGroupID + ",");
        }
        if (this.resourceTags != null && !this.resourceTags.isEmpty()) {
            sb.append("resourceTags:");
            sb.append(this.resourceTags + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourceTagsNested<N>
    extends AlibabaCloudResourceTagFluent<ResourceTagsNested<N>>
    implements Nested<N> {
        AlibabaCloudResourceTagBuilder builder;
        int index;

        ResourceTagsNested(int index, AlibabaCloudResourceTag item) {
            this.index = index;
            this.builder = new AlibabaCloudResourceTagBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlibabaCloudPlatformStatusFluent.this.setToResourceTags(this.index, this.builder.build());
        }

        public N endResourceTag() {
            return this.and();
        }
    }
}

