/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import org.wildfly.glow.GlowMessageWriter;

class DefaultGlowMessageWriter
implements GlowMessageWriter {
    static final boolean VERBOSE = Boolean.getBoolean("verbose");
    private final GlowMessageWriter delegate;

    DefaultGlowMessageWriter() {
        boolean useAnsiColours = System.console() != null && System.getenv().get("TERM") != null;
        this.delegate = useAnsiColours ? new AnsiColourMessageWriter() : new GlowMessageWriter(){};
    }

    @Override
    public void info(Object s) {
        this.delegate.info(s);
    }

    @Override
    public void warn(Object s) {
        this.delegate.warn(s);
    }

    @Override
    public void error(Object s) {
        this.delegate.error(s);
    }

    @Override
    public void trace(Object s) {
        this.delegate.trace(s);
    }

    @Override
    public boolean isVerbose() {
        return VERBOSE;
    }

    private static class AnsiColourMessageWriter
    implements GlowMessageWriter {
        private static final String ANSI_RESET = "\u001b[0m";
        private static final String ANSI_RED = "\u001b[31m";
        private static final String ANSI_YELLOW = "\u001b[33m";

        private AnsiColourMessageWriter() {
        }

        @Override
        public void info(Object s) {
            GlowMessageWriter.super.info(s);
        }

        @Override
        public void warn(Object s) {
            GlowMessageWriter.super.warn(ANSI_YELLOW + String.valueOf(s) + ANSI_RESET);
        }

        @Override
        public void error(Object s) {
            GlowMessageWriter.super.error(ANSI_RED + String.valueOf(s) + ANSI_RESET);
        }
    }
}

