/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.glow.FeaturePacks;
import org.wildfly.glow.MetadataProvider;
import org.wildfly.glow.Space;

public class WildFlyMavenMetadataProvider
implements MetadataProvider {
    private static final String DEFAULT_RANGE = "[0.0,)";
    private static final String METADATA_EXTENSION = "zip";
    private static final String METADATA_GROUP_ID = "org.wildfly.galleon.feature-packs";
    private static final String METADATA_ARTIFACT_ID = "wildfly-galleon-feature-packs-metadata";
    private final MavenRepoManager repo;
    private final Path tmpDirectory;
    private FeaturePacks featurePacks;

    public WildFlyMavenMetadataProvider(MavenRepoManager repo, Path tmpDirectory) {
        this.repo = repo;
        this.tmpDirectory = tmpDirectory;
    }

    private FeaturePacks getResolver() throws Exception {
        if (this.featurePacks == null) {
            MavenArtifact artifact = new MavenArtifact();
            artifact.setExtension(METADATA_EXTENSION);
            artifact.setArtifactId(METADATA_ARTIFACT_ID);
            artifact.setGroupId(METADATA_GROUP_ID);
            artifact.setVersionRange(DEFAULT_RANGE);
            this.repo.resolveLatestVersion(artifact, null, false);
            Path zip = artifact.getPath();
            Path rootDirectory = this.tmpDirectory.resolve("glow-metadata");
            ZipUtils.unzip(zip, rootDirectory);
            this.featurePacks = new FeaturePacks(rootDirectory.toUri());
        }
        return this.featurePacks;
    }

    @Override
    public Path getFeaturePacks(Space space, String version, String context, boolean techPreview) throws Exception {
        return this.getResolver().getFeaturePacks(space, version, context, techPreview);
    }

    @Override
    public Set<String> getAllVersions(String spaceName) throws Exception {
        return this.getResolver().getAllVersions(spaceName);
    }

    @Override
    public Space getSpace(String spaceName) throws Exception {
        return this.getResolver().getSpace(spaceName);
    }

    @Override
    public String getLatestVersion() throws Exception {
        return this.getResolver().getLatestVersion();
    }

    @Override
    public List<Space> getAllSpaces() throws Exception {
        return this.getResolver().getAllSpaces();
    }
}

