/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.ConfigurationResolver;
import org.wildfly.glow.Env;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.ScanArguments;
import org.wildfly.glow.ScanResults;
import org.wildfly.glow.error.ErrorLevel;
import org.wildfly.glow.error.IdentifiedError;

public class ScanResultsPrinter {
    private final GlowMessageWriter writer;
    private final ConfigurationResolver configResolver;

    public ScanResultsPrinter(GlowMessageWriter writer) {
        this(writer, null);
    }

    public ScanResultsPrinter(GlowMessageWriter writer, ConfigurationResolver configResolver) {
        this.writer = writer;
        this.configResolver = configResolver;
    }

    void print(ScanArguments arguments, ScanResults scanResults) throws Exception {
        if (arguments.isCompact().booleanValue()) {
            this.printCompact(arguments, scanResults);
        } else {
            this.detailed(arguments, scanResults);
        }
    }

    void printCompact(ScanArguments arguments, ScanResults scanResults) throws Exception {
        this.writer.info(this.getCompactInformation(arguments, scanResults));
    }

    String getCompactInformation(ScanArguments arguments, ScanResults scanResults) throws Exception {
        StringBuilder compactBuilder = new StringBuilder();
        if (!arguments.getExecutionProfiles().isEmpty()) {
            compactBuilder.append(new TreeSet<String>(arguments.getExecutionProfiles()));
        }
        compactBuilder.append(new TreeSet<Layer>(scanResults.getDiscoveredLayers())).append("==>");
        compactBuilder.append(scanResults.getBaseLayer());
        for (Layer l : new TreeSet<Layer>(scanResults.getDecorators())) {
            compactBuilder.append(",").append(l.getName());
        }
        for (Layer l : new TreeSet<Layer>(scanResults.getExcludedLayers())) {
            compactBuilder.append(",-").append(l.getName());
        }
        return compactBuilder.toString();
    }

    private void detailed(ScanArguments arguments, ScanResults scanResults) throws Exception {
        this.writer.info("context: " + arguments.getExecutionContext());
        StringBuilder profileBuilder = new StringBuilder();
        profileBuilder.append("enabled profile: ");
        if (!arguments.getExecutionProfiles().isEmpty()) {
            for (String string : arguments.getExecutionProfiles()) {
                profileBuilder.append(string);
            }
        } else {
            profileBuilder.append("none");
        }
        this.writer.info(profileBuilder);
        if (arguments.getConfigStability() != null) {
            this.writer.info("config stability: " + arguments.getConfigStability().toString());
        }
        if (arguments.getPackageStability() != null) {
            this.writer.info("package stability: " + arguments.getPackageStability().toString());
        }
        this.writer.info("galleon discovery");
        StringBuilder builder = new StringBuilder();
        builder.append("- feature-packs").append("\n");
        for (GalleonFeaturePackConfig galleonFeaturePackConfig : scanResults.getProvisioningConfig().getFeaturePackDeps()) {
            FeaturePackLocation.FPID fPID = scanResults.getFeaturePackVersions().get(galleonFeaturePackConfig.getLocation().getProducer());
            builder.append("   ").append(fPID == null ? galleonFeaturePackConfig.getLocation() : fPID).append("\n");
        }
        builder.append("- layers").append("\n");
        builder.append("   ").append(scanResults.getBaseLayer()).append("\n");
        for (Layer layer : scanResults.getDecorators()) {
            builder.append("   ").append(layer.getName() + (scanResults.getExcludedFeatures().containsKey(layer) ? " [WARNING: contains content at a lower stability level]" : "")).append("\n");
        }
        if (!scanResults.getExcludedLayers().isEmpty()) {
            builder.append("- excluded-layers\n");
            for (Layer layer : scanResults.getExcludedLayers()) {
                builder.append("   ").append(layer.getName()).append("\n");
            }
        }
        this.writer.info(builder);
        if (arguments.isVerbose()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\nlayers inclusion rules").append("\n");
            stringBuilder.append("* ").append(scanResults.getBaseLayer()).append("\n");
            for (LayerMapping.RULE rULE : scanResults.getBaseLayer().getMatchingRules().keySet()) {
                Iterator<Object> str = scanResults.getBaseLayer().getMatchingRules().get((Object)rULE);
                stringBuilder.append("  - ").append((Object)rULE).append((String)(str == null || str.isEmpty() ? "" : ": " + String.valueOf(str))).append("\n");
            }
            for (Layer layer : scanResults.getDecorators()) {
                stringBuilder.append("* ").append(layer.getName()).append("\n");
                for (LayerMapping.RULE rULE : layer.getMatchingRules().keySet()) {
                    Set<String> str = layer.getMatchingRules().get((Object)rULE);
                    stringBuilder.append("  - ").append((Object)rULE).append((String)(str == null || str.isEmpty() ? "" : ": " + String.valueOf(str))).append("\n");
                }
            }
            this.writer.info(stringBuilder.toString());
        }
        if (!scanResults.getEnabledAddOns().isEmpty()) {
            this.writer.info("enabled add-ons");
            StringBuilder stringBuilder = new StringBuilder();
            for (AddOn addOn : scanResults.getEnabledAddOns()) {
                stringBuilder.append("- ").append(addOn.getName()).append((String)(addOn.getDescription() != null ? " : " + addOn.getDescription() : "")).append("\n");
            }
            this.writer.info(stringBuilder);
        }
        if (!scanResults.getDisabledAddOns().isEmpty()) {
            this.writer.info("disabled add-ons");
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<AddOn, String> entry : scanResults.getDisabledAddOns().entrySet()) {
                stringBuilder.append("- ").append(entry.getKey().getName()).append(": ").append(entry.getValue()).append("\n");
            }
            this.writer.info(stringBuilder);
        }
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>();
        ArrayList<StringBuilder> arrayList2 = new ArrayList<StringBuilder>();
        ArrayList<StringBuilder> arrayList3 = new ArrayList<StringBuilder>();
        for (IdentifiedError identifiedError : scanResults.getErrorSession().getErrors()) {
            if (identifiedError.isFixed()) {
                StringBuilder fixBuilder = new StringBuilder();
                fixBuilder.append("* ").append(identifiedError.getDescription()).append(" is fixed\n");
                fixBuilder.append("  - ").append(identifiedError.getFixMessage()).append("\n");
                arrayList.add(fixBuilder);
                continue;
            }
            StringBuilder errorBuilder = new StringBuilder();
            errorBuilder.append("* ").append(identifiedError.getDescription()).append("\n");
            if (!identifiedError.getPossibleAddons().isEmpty()) {
                errorBuilder.append("  To correct this error, enable one of the following add-ons:\n");
                for (AddOn addOn : identifiedError.getPossibleAddons()) {
                    String deployer = this.configResolver == null ? null : this.configResolver.getPossibleDeployer(addOn.getLayers());
                    errorBuilder.append("  - ").append(addOn.getName()).append((String)(deployer == null ? "" : " (supported by " + deployer + " deployer)")).append("\n");
                }
            }
            if (identifiedError.getErrorLevel() == ErrorLevel.ERROR) {
                arrayList2.add(errorBuilder);
                continue;
            }
            arrayList3.add(errorBuilder);
        }
        if (!arrayList2.isEmpty()) {
            this.writer.info("identified errors");
            for (StringBuilder stringBuilder : arrayList2) {
                this.writer.error(stringBuilder);
            }
        }
        if (!arrayList3.isEmpty()) {
            this.writer.info("possible issues");
            for (StringBuilder stringBuilder : arrayList3) {
                this.writer.warn(stringBuilder);
            }
        }
        if (!arrayList.isEmpty()) {
            this.writer.info("identified fixes");
            for (StringBuilder stringBuilder : arrayList) {
                this.writer.info(stringBuilder);
            }
        }
        if (this.configResolver != null) {
            Iterator<Map.Entry<Layer, Set<Env>>> deployers = new TreeSet();
            for (Layer l : scanResults.getDiscoveredLayers()) {
                String string = this.configResolver.getPossibleDeployer(l);
                if (string == null) continue;
                deployers.add((Map.Entry<Layer, Set<Env>>)((Object)string));
            }
            for (Layer l : scanResults.getMetadataOnlyLayers()) {
                String string = this.configResolver.getPossibleDeployer(l);
                if (string == null) continue;
                deployers.add((Map.Entry<Layer, Set<Env>>)((Object)string));
            }
            if (!deployers.isEmpty()) {
                this.writer.info("deployers that would get automatically enabled when deploying to openshift");
                Iterator iterator = deployers.iterator();
                while (iterator.hasNext()) {
                    String deployer2 = (String)iterator.next();
                    this.writer.info("- " + (String)deployer2);
                }
                this.writer.info("");
            }
        }
        if (!scanResults.getSuggestions().getStronglySuggestedConfigurations().isEmpty()) {
            this.writer.warn("strongly suggested configuration at runtime");
            for (Map.Entry entry : scanResults.getSuggestions().getStronglySuggestedConfigurations().entrySet()) {
                this.writer.warn(this.buildSuggestions((Layer)entry.getKey(), (Set)entry.getValue()));
            }
            this.writer.warn("");
        }
        if (!scanResults.getSuggestions().getBuildTimeRequiredConfigurations().isEmpty()) {
            this.writer.warn("configuration that must be set at provisioning time");
            for (Map.Entry<Layer, Set<Env>> entry : scanResults.getSuggestions().getBuildTimeRequiredConfigurations().entrySet()) {
                this.writer.warn(this.buildSuggestions(entry.getKey(), entry.getValue()));
            }
            this.writer.warn("");
        }
        if (arguments.getDefaultConfigStability() != null || arguments.getConfigStability() != null || arguments.getPackageStability() != null) {
            boolean needCR = false;
            if (!scanResults.getExcludedFeatures().isEmpty()) {
                String string = arguments.getConfigStability() == null ? "" : " at the '" + arguments.getConfigStability() + "' stability level";
                this.writer.warn("The following features would be disabled if provisioning a server" + string + ". Make sure to set the '--config-stability-level=<features expected lowest stability level>' option:");
                needCR = true;
                for (Layer layer : scanResults.getExcludedFeatures().keySet()) {
                    this.writer.warn(layer.getName() + " features:");
                    for (String f : scanResults.getExcludedFeatures().get(layer)) {
                        this.writer.warn("- " + f);
                    }
                }
            }
            if (!scanResults.getExcludedPackages().isEmpty()) {
                this.writer.warn("The following packages would be disabled if provisioning a server at the '" + arguments.getPackageStability() + "' stability level for packages:");
                needCR = true;
                this.writer.warn("packages:");
                for (String p : scanResults.getExcludedPackages()) {
                    this.writer.warn("- " + p);
                }
            }
            if (needCR) {
                this.writer.info("");
            }
        }
        String suggestedConfigs = this.buildSuggestions(scanResults.getSuggestions().getSuggestedConfigurations());
        String string = this.buildSuggestions(scanResults.getSuggestions().getBuildTimeConfigurations());
        if (arguments.isSuggest()) {
            this.writer.info("suggestions");
            if (scanResults.getSuggestions().getPossibleAddOns().isEmpty() && scanResults.getSuggestions().getPossibleProfiles().isEmpty() && suggestedConfigs.isEmpty() && string.isEmpty()) {
                this.writer.info("none");
            } else {
                if (!string.isEmpty()) {
                    this.writer.info("\n* you could set the following configuration at provisioning time");
                    this.writer.info(string);
                }
                if (!suggestedConfigs.isEmpty()) {
                    this.writer.info("\n* you could set the following configuration at runtime");
                    this.writer.info(suggestedConfigs);
                }
                if (!scanResults.getSuggestions().getPossibleAddOns().isEmpty()) {
                    this.writer.info("* you could enable the following add-ons:");
                    TreeMap<String, TreeSet<AddOn>> sortedAddOns = new TreeMap<String, TreeSet<AddOn>>();
                    for (AddOn addOn : scanResults.getSuggestions().getPossibleAddOns()) {
                        TreeSet<AddOn> addons = (TreeSet<AddOn>)sortedAddOns.get(addOn.getFamily());
                        if (addons == null) {
                            addons = new TreeSet<AddOn>();
                            sortedAddOns.put(addOn.getFamily(), addons);
                        }
                        addons.add(addOn);
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String family : sortedAddOns.keySet()) {
                        stringBuilder.append("  - ").append(family).append(" add-ons:\n");
                        for (AddOn l : (Set)sortedAddOns.get(family)) {
                            stringBuilder.append("    - ").append(l.getName()).append((String)(l.getDescription() != null ? " : " + l.getDescription() : "")).append("\n");
                        }
                    }
                    this.writer.info(stringBuilder);
                }
                if (!scanResults.getSuggestions().getPossibleProfiles().isEmpty()) {
                    this.writer.info("* you could enable profiles:");
                    StringBuilder profilesBuilder = new StringBuilder();
                    for (String string2 : scanResults.getSuggestions().getPossibleProfiles()) {
                        profilesBuilder.append("  - ").append(string2).append("\n");
                    }
                    this.writer.info(profilesBuilder);
                }
            }
        } else if (!(scanResults.getSuggestions().getPossibleAddOns().isEmpty() && scanResults.getSuggestions().getPossibleAddOns().isEmpty() && suggestedConfigs.isEmpty() && string.isEmpty())) {
            this.writer.info("Some suggestions have been found. You could enable suggestions with the " + (arguments.isCli() ? "--suggest" : "<suggest>true</suggest>") + " option.");
        }
    }

    private String buildSuggestions(Map<Layer, Set<Env>> map) throws Exception {
        StringBuilder suggestedConfigsBuilder = new StringBuilder();
        for (Layer l : map.keySet()) {
            suggestedConfigsBuilder.append(this.buildSuggestions(l, map.get(l)));
        }
        return suggestedConfigsBuilder.toString();
    }

    private String buildSuggestions(Layer layer, Set<Env> envs) throws Exception {
        Env e;
        Iterator it2;
        StringBuilder suggestedConfigsBuilder = new StringBuilder();
        TreeSet<Env> envVars = new TreeSet<Env>();
        TreeSet<Env> properties = new TreeSet<Env>();
        for (Env e2 : envs) {
            if (e2.isProperty().booleanValue()) {
                properties.add(e2);
                continue;
            }
            envVars.add(e2);
        }
        if (!envVars.isEmpty()) {
            ConfigurationResolver.ResolvedEnvs resolvedEnvs;
            suggestedConfigsBuilder.append("\n").append(layer.getName()).append(" environment variables:\n");
            if (this.configResolver != null && (resolvedEnvs = this.configResolver.getResolvedEnvs(layer, envVars)) != null) {
                envVars.removeAll(resolvedEnvs.getEnvs());
                if (envVars.isEmpty()) {
                    suggestedConfigsBuilder.append(" - ").append("Resolver " + resolvedEnvs.getName()).append(" resolved all env variables.");
                } else {
                    suggestedConfigsBuilder.append(" - ").append("Resolver " + resolvedEnvs.getName()).append(" resolved the following env variables:\n");
                    for (Env env : resolvedEnvs.getEnvs()) {
                        suggestedConfigsBuilder.append("  - ").append(env.getName() + "\n");
                    }
                }
            }
            it2 = envVars.iterator();
            while (it2.hasNext()) {
                e = (Env)it2.next();
                suggestedConfigsBuilder.append(" - ").append(e.getName()).append("=").append(e.getDescription());
                if (!it2.hasNext()) continue;
                suggestedConfigsBuilder.append("\n");
            }
        }
        if (!properties.isEmpty()) {
            suggestedConfigsBuilder.append("\n").append(layer.getName()).append(" system properties:\n");
            it2 = properties.iterator();
            while (it2.hasNext()) {
                e = (Env)it2.next();
                suggestedConfigsBuilder.append(" -D").append(e.getName()).append("=").append(e.getDescription());
                if (!it2.hasNext()) continue;
                suggestedConfigsBuilder.append("\n");
            }
        }
        return suggestedConfigsBuilder.toString();
    }
}

