/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.util.Set;
import java.util.TreeSet;

public abstract class LayerMetadata {
    public static final String PREFIX = "org.wildfly.rule.";
    public static final String ADD_ON = "org.wildfly.rule.add-on";
    public static final String ADD_ON_CARDINALITY = "org.wildfly.rule.add-on-cardinality";
    public static final String ADD_ON_DEPENDS_ON = "org.wildfly.rule.add-on-depends-on";
    public static final String ADD_ON_DESCRIPTION = "org.wildfly.rule.add-on-description";
    public static final String ADD_ON_FIX = "org.wildfly.rule.add-on-fix-";
    public static final String ANNOTATED_TYPE = "org.wildfly.rule.annotated.type";
    public static final String ANNOTATIONS = "org.wildfly.rule.annotations";
    public static final String ANNOTATION_FIELD_VALUE = "org.wildfly.rule.annotation.field.value";
    public static final String BRING_DATASOURCE = "org.wildfly.rule.bring-datasource";
    public static final String CLASS = "org.wildfly.rule.class";
    public static final String CONFIGURATION = "org.wildfly.rule.configuration";
    public static final String EXPECT_ADD_ON_FAMILY = "org.wildfly.rule.expect-add-on-family";
    public static final String EXPECTED_FILE = "org.wildfly.rule.expected-file";
    public static final String HIDDEN_IF = "org.wildfly.rule.hidden-if";
    public static final String INCLUSION_MODE = "org.wildfly.rule.inclusion-mode";
    public static final String KIND = "org.wildfly.rule.kind";
    public static final String NO_CONFIGURATION_IF = "org.wildfly.rule.no-configuration-if";
    public static final String NOT_EXPECTED_FILE = "org.wildfly.rule.not-expected-file";
    public static final String PROFILE = "org.wildfly.rule.profile-";
    public static final String PROPERTIES_FILE_MATCH = "org.wildfly.rule.properties-file-match";
    public static final String XML_PATH = "org.wildfly.rule.xml-path";
    private static final Set<String> ALL_RULES = new TreeSet<String>();
    private static final Set<String> FULLY_NAMED_RULES = new TreeSet<String>();
    private static final Set<String> RULES_WITH_SUFFIX = new TreeSet<String>();
    private static final Set<String> CONDITION_RULES = new TreeSet<String>();

    public static Set<String> getAllRules() {
        return ALL_RULES;
    }

    public static Set<String> getFullyNamedRules() {
        return FULLY_NAMED_RULES;
    }

    public static Set<String> getRadicalOnlyNamedRules() {
        return RULES_WITH_SUFFIX;
    }

    public static Set<String> getConditionRules() {
        return CONDITION_RULES;
    }

    public static String getRuleClass(String k) {
        if (FULLY_NAMED_RULES.contains(k)) {
            return k;
        }
        for (String c : CONDITION_RULES) {
            if (!k.startsWith(c)) continue;
            return c;
        }
        for (String c : RULES_WITH_SUFFIX) {
            if (!k.startsWith(c)) continue;
            return c;
        }
        return null;
    }

    static {
        FULLY_NAMED_RULES.add(ADD_ON);
        FULLY_NAMED_RULES.add(ADD_ON_CARDINALITY);
        FULLY_NAMED_RULES.add(ADD_ON_DEPENDS_ON);
        FULLY_NAMED_RULES.add(ADD_ON_DESCRIPTION);
        FULLY_NAMED_RULES.add(ANNOTATIONS);
        FULLY_NAMED_RULES.add(BRING_DATASOURCE);
        FULLY_NAMED_RULES.add(CLASS);
        FULLY_NAMED_RULES.add(CONFIGURATION);
        FULLY_NAMED_RULES.add(EXPECT_ADD_ON_FAMILY);
        FULLY_NAMED_RULES.add(INCLUSION_MODE);
        FULLY_NAMED_RULES.add(KIND);
        RULES_WITH_SUFFIX.add(ADD_ON_FIX);
        RULES_WITH_SUFFIX.add(ANNOTATION_FIELD_VALUE);
        RULES_WITH_SUFFIX.add(ANNOTATED_TYPE);
        RULES_WITH_SUFFIX.add(EXPECTED_FILE);
        RULES_WITH_SUFFIX.add(NOT_EXPECTED_FILE);
        RULES_WITH_SUFFIX.add(PROFILE);
        RULES_WITH_SUFFIX.add(PROPERTIES_FILE_MATCH);
        RULES_WITH_SUFFIX.add(XML_PATH);
        CONDITION_RULES.add(HIDDEN_IF);
        CONDITION_RULES.add(NO_CONFIGURATION_IF);
        ALL_RULES.addAll(FULLY_NAMED_RULES);
        ALL_RULES.addAll(RULES_WITH_SUFFIX);
        ALL_RULES.addAll(CONDITION_RULES);
    }
}

