/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class MinMaxContainsValidator
extends BaseJsonValidator {
    private final Set<Analysis> analysis;

    public MinMaxContainsValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.MAX_CONTAINS, validationContext);
        JsonNode maxNode;
        LinkedHashSet<Analysis> analysis = null;
        int min = 1;
        int max = Integer.MAX_VALUE;
        JsonNode minNode = parentSchema.getSchemaNode().get("minContains");
        if (null != minNode) {
            if (!minNode.isNumber() || !minNode.canConvertToExactIntegral() || minNode.intValue() < 0) {
                if (analysis == null) {
                    analysis = new LinkedHashSet<Analysis>();
                }
                analysis.add(new Analysis("minContains", schemaLocation));
            } else {
                min = minNode.intValue();
            }
        }
        if (null != (maxNode = parentSchema.getSchemaNode().get("maxContains"))) {
            if (!maxNode.isNumber() || !maxNode.canConvertToExactIntegral() || maxNode.intValue() < 0) {
                if (analysis == null) {
                    analysis = new LinkedHashSet();
                }
                analysis.add(new Analysis("maxContains", schemaLocation));
            } else {
                max = maxNode.intValue();
            }
        }
        if (max < min) {
            if (analysis == null) {
                analysis = new LinkedHashSet();
            }
            analysis.add(new Analysis("minContainsVsMaxContains", schemaLocation));
        }
        this.analysis = analysis;
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        return this.analysis != null ? (Set)this.analysis.stream().map(analysis -> ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).messageKey(analysis.getMessageKey())).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).type(analysis.getMessageKey())).arguments(this.parentSchema.getSchemaNode().toString())).build()).collect(Collectors.toCollection(LinkedHashSet::new)) : Collections.emptySet();
    }

    public static class Analysis {
        private final String messageKey;
        private final SchemaLocation schemaLocation;

        public String getMessageKey() {
            return this.messageKey;
        }

        public SchemaLocation getSchemaLocation() {
            return this.schemaLocation;
        }

        public Analysis(String messageKey, SchemaLocation schemaLocation) {
            this.messageKey = messageKey;
            this.schemaLocation = schemaLocation;
        }
    }
}

