/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.deployment.openshift.amq;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.openshift.client.OpenShiftClient;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.wildfly.glow.Env;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.deployment.openshift.api.Deployer;
import org.wildfly.glow.deployment.openshift.api.OpenShiftSupport;
import org.wildfly.glow.deployment.openshift.api.Utils;

public class AMQDeployer
implements Deployer {
    private static final String REMOTE_BROKER_NAME = "amq-broker";
    private static final String REMOTE_BROKER_PASSWORD = "admin";
    private static final String REMOTE_BROKER_USER = "admin";
    private static final Map<String, String> REMOTE_BROKER_CONNECTION_MAP = new HashMap<String, String>();
    private static final Map<String, String> REMOTE_BROKER_APP_MAP = new HashMap<String, String>();
    private static final String AMQ_USER_ENV = "AMQ_USER";
    private static final String AMQ_PASSWORD_ENV = "AMQ_PASSWORD";
    private static final String BROKER_AMQ_USERNAME_ENV = "BROKER_AMQ_USERNAME";
    private static final String BROKER_AMQ_PASSWORD_ENV = "BROKER_AMQ_PASSWORD";
    private static final String MQ_SERVICE_PREFIX_MAPPING_ENV = "MQ_SERVICE_PREFIX_MAPPING";
    private static final String TEMPLATE_PASSWORD_ENV = "{PREFIX}_PASSWORD";
    private static final String TEMPLATE_USERNAME_ENV = "{PREFIX}_USERNAME";
    private static final String TEMPLATE_SERVICE_HOST = "{SERVICE-NAME}_AMQ7_TCP_SERVICE_HOST";
    private static final String TEMPLATE_SERVICE_PORT = "{SERVICE-NAME}_AMQ7_TCP_SERVICE_PORT";
    private static final Set<String> RESOLVED_ENVS = new HashSet<String>();

    @Override
    public Map<String, String> deploy(GlowMessageWriter writer, Path target, OpenShiftClient osClient, Map<String, String> env, String appHost, String appName, String matching, Map<String, String> extraEnv, boolean dryRun) throws Exception {
        writer.info("Deploying AMQ Messaging Broker");
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("deployment", REMOTE_BROKER_NAME);
        ContainerPort port = new ContainerPort();
        port.setContainerPort(61616);
        port.setProtocol("TCP");
        ArrayList<ContainerPort> ports = new ArrayList<ContainerPort>();
        ports.add(port);
        ArrayList<EnvVar> vars = new ArrayList<EnvVar>();
        for (Map.Entry<String, String> entry : REMOTE_BROKER_CONNECTION_MAP.entrySet()) {
            String val = extraEnv.get(entry.getKey());
            if (val != null) {
                if (AMQ_USER_ENV.equals(entry.getKey())) {
                    REMOTE_BROKER_APP_MAP.put(BROKER_AMQ_USERNAME_ENV, val);
                } else if (AMQ_PASSWORD_ENV.equals(entry.getKey())) {
                    REMOTE_BROKER_APP_MAP.put(BROKER_AMQ_PASSWORD_ENV, val);
                }
            }
            vars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVar().toBuilder().withName(entry.getKey())).withValue(val == null ? entry.getValue() : val)).build());
        }
        Container container = new Container();
        container.setName(REMOTE_BROKER_NAME);
        container.setImage("registry.redhat.io/amq7/amq-broker");
        container.setPorts(ports);
        container.setEnv(vars);
        container.setImagePullPolicy("IfNotPresent");
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.StrategyNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(REMOTE_BROKER_NAME)).endMetadata()).withNewSpec().withReplicas(1)).withNewSelector().withMatchLabels(labels)).endSelector()).withNewTemplate().withNewMetadata().withLabels(labels)).endMetadata()).withNewSpec().withContainers(container)).withRestartPolicy("Always")).endSpec()).endTemplate()).withNewStrategy().withType("RollingUpdate")).endStrategy()).endSpec()).build();
        if (!dryRun) {
            ((Resource)osClient.resources(Deployment.class).resource(deployment)).createOr(Updatable::update);
        }
        Utils.persistResource(OpenShiftSupport.getDeployersDirectory(target), deployment, "amq-broker-deployment.yaml");
        IntOrString v = new IntOrString();
        v.setValue(61616);
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(REMOTE_BROKER_NAME)).endMetadata()).withNewSpec().withPorts(((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePort().toBuilder().withName("61616-tcp")).withProtocol("TCP")).withPort(61616)).withTargetPort(v)).build())).withType("ClusterIP")).withSessionAffinity("None")).withSelector(labels)).endSpec()).build();
        if (!dryRun) {
            ((ServiceResource)osClient.services().resource(service)).createOr(Updatable::update);
        }
        Utils.persistResource(OpenShiftSupport.getDeployersDirectory(target), service, "amq-broker-service.yaml");
        if (dryRun) {
            writer.info("Resources for AMQ Messaging Broker have been generated");
        } else {
            writer.info("AMQ Messaging Broker has been deployed");
        }
        return REMOTE_BROKER_APP_MAP;
    }

    @Override
    public Map<String, String> disabledDeploy(String appHost, String appName, String matching, Map<String, String> env) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String descriptionPrefix = " Replace the PREFIX with the prefix used in the MQ_SERVICE_PREFIX_MAPPING env variable";
        String descriptionServiceName = " Replace the SERVICE-NAME with the service name used in the MQ_SERVICE_PREFIX_MAPPING env variable";
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String k;
            if (entry.getKey().startsWith("{PREFIX}")) {
                k = entry.getKey().replace("{PREFIX}", "PREFIX");
                ret.put(k, entry.getValue() + descriptionPrefix);
                continue;
            }
            if (entry.getKey().startsWith("{SERVICE-NAME}")) {
                k = entry.getKey().replace("{SERVICE-NAME}", "SERVICE-NAME");
                ret.put(k, entry.getValue() + descriptionServiceName);
                continue;
            }
            if (!entry.getKey().startsWith(MQ_SERVICE_PREFIX_MAPPING_ENV)) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    @Override
    public Set<Env> getResolvedEnvs(Set<Env> input) {
        HashSet<Env> envs = new HashSet<Env>();
        for (Env env : input) {
            if (!RESOLVED_ENVS.contains(env.getName())) continue;
            envs.add(env);
        }
        return envs;
    }

    @Override
    public Set<String> getSupportedLayers() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("cloud-remote-activemq");
        return ret;
    }

    @Override
    public String getName() {
        return REMOTE_BROKER_NAME;
    }

    static {
        RESOLVED_ENVS.add(MQ_SERVICE_PREFIX_MAPPING_ENV);
        RESOLVED_ENVS.add(TEMPLATE_PASSWORD_ENV);
        RESOLVED_ENVS.add(TEMPLATE_USERNAME_ENV);
        RESOLVED_ENVS.add(TEMPLATE_SERVICE_HOST);
        RESOLVED_ENVS.add(TEMPLATE_SERVICE_PORT);
        REMOTE_BROKER_CONNECTION_MAP.put(AMQ_USER_ENV, "admin");
        REMOTE_BROKER_CONNECTION_MAP.put(AMQ_PASSWORD_ENV, "admin");
        REMOTE_BROKER_CONNECTION_MAP.put("AMQ_DATA_DIR", "/home/jboss/data");
        REMOTE_BROKER_APP_MAP.put(MQ_SERVICE_PREFIX_MAPPING_ENV, "broker-amq7=BROKER_AMQ");
        REMOTE_BROKER_APP_MAP.put("BROKER_AMQ_TCP_SERVICE_HOST", REMOTE_BROKER_NAME);
        REMOTE_BROKER_APP_MAP.put("BROKER_AMQ_TCP_SERVICE_PORT", "61616");
        REMOTE_BROKER_APP_MAP.put(BROKER_AMQ_PASSWORD_ENV, "admin");
        REMOTE_BROKER_APP_MAP.put(BROKER_AMQ_USERNAME_ENV, "admin");
    }
}

