/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.jbang;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wildfly.glow.GlowSession;

public class JBangIntegration {
    private static final Pattern MAVEN_JAR_PATTERN = Pattern.compile("([a-zA-Z0-9_.-]+):([a-zA-Z0-9_.-]+):jar:([a-zA-Z0-9_.-]+)");
    private static final String WEB_INF = "WEB-INF";

    private static void extractJar(Path jar, final Path destDir) throws IOException {
        try (FileSystem fs = FileSystems.newFileSystem(jar, null);){
            final Path root = fs.getPath("/", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path destFile = destDir.resolve(root.relativize(file).toString());
                    Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                    Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path destDirPath = destDir.resolve(root.relativize(dir).toString());
                    Files.createDirectories(destDirPath, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
            System.out.println("JAR extracted successfully to " + destDir);
        }
    }

    private static Path toWar(final Path appClasses, Set<Path> libs) throws IOException {
        System.out.println("Adding libs to WAR: " + libs);
        final Path parent = appClasses.getParent();
        final Path webInf = parent.resolve(WEB_INF);
        final Path webClassesDir = webInf.resolve("classes");
        Path webLibDir = webInf.resolve("lib");
        Files.createDirectories(webClassesDir, new FileAttribute[0]);
        Files.walkFileTree(appClasses, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path filePath = appClasses.relativize(file);
                Path targetPath = filePath.startsWith(JBangIntegration.WEB_INF) && filePath.getNameCount() > 1 ? webInf.resolve(filePath.subpath(1, filePath.getNameCount())) : webClassesDir.resolve(filePath);
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                Files.copy(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(webClassesDir.resolve(appClasses.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }
        });
        if (libs.size() > 0) {
            Files.createDirectories(webLibDir, new FileAttribute[0]);
        }
        for (Path lib : libs) {
            Path targetPath = webLibDir.resolve(lib.getFileName());
            Files.copy(lib, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        String warName = parent.getFileName().toString().split("\\.")[0] + ".war";
        Path warFile = parent.resolve(warName);
        URI warUri = URI.create("jar:" + warFile.toUri());
        try (FileSystem warFs = FileSystems.newFileSystem(warUri, Collections.singletonMap("create", "true"));){
            final Path warRoot = warFs.getPath("/", new String[0]);
            Files.walkFileTree(webInf, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path targetPath = warRoot.resolve(parent.relativize(file).toString().replace("\\", "/"));
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    Files.copy(file, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(warRoot.resolve(webInf.relativize(dir).toString().replace("\\", "/")), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return warFile;
    }

    private static Path runGlowScan(Path glowJar, Path war, Optional<String> glowArgs) throws Exception {
        System.out.println("Scanning " + war + " with " + glowJar);
        Path temp = Files.createTempDirectory("glow", new FileAttribute[0]);
        ArrayList<CallSite> args = new ArrayList<CallSite>(List.of("java", "-jar", glowJar.toString(), "scan", "--provision=BOOTABLE_JAR", "--output-dir=" + temp));
        glowArgs.map(s -> Arrays.asList(s.split("\\s+"))).ifPresent(args::addAll);
        args.add((CallSite)((Object)war.toString()));
        ProcessBuilder processBuilder = new ProcessBuilder(args).redirectErrorStream(true);
        System.out.println("Running command: " + String.join((CharSequence)" ", processBuilder.command()));
        Process process = processBuilder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            reader.lines().forEach(System.out::println);
        }
        if (process.waitFor() != 0) {
            throw new IOException("Glow scan failed with exit code " + process.exitValue());
        }
        try (Stream<Path> files = Files.list(temp);){
            List fileList = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
            Path path = fileList.size() == 1 ? (Path)fileList.get(0) : null;
            return path;
        }
    }

    private static void deleteDirectory(Path dir) throws IOException {
        if (Files.exists(dir, new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(dir, new FileVisitOption[0]);){
                paths.sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException ignored) {
                        System.err.println("Failed to delete: " + path);
                    }
                });
            }
        }
    }

    private static Set<Path> findLibrariestoInclude(List<Map.Entry<String, Path>> originalDeps, List<String> comments) {
        return originalDeps.stream().filter(entry -> {
            Matcher matcher = MAVEN_JAR_PATTERN.matcher((CharSequence)entry.getKey());
            if (!matcher.matches()) {
                return false;
            }
            String groupId = matcher.group(1);
            String artifactId = matcher.group(2);
            String version = matcher.group(3);
            if ("org.wildfly.glow".equals(groupId) && "wildfly-glow".equals(artifactId)) {
                return false;
            }
            String dep = String.format("//DEPS %s:%s:%s", groupId, artifactId, version);
            return comments.contains(dep);
        }).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    public static Map<String, Object> postBuild(Path appClasses, Path pomFile, List<Map.Entry<String, String>> repositories, List<Map.Entry<String, Path>> originalDeps, List<String> comments, boolean nativeImage) throws IOException {
        Optional<String> glowArgs = comments.stream().filter(s -> s.startsWith("//GLOW ")).map(s -> s.substring(6).strip()).collect(Collectors.reducing((s1, s2) -> s1 + " " + s2));
        Set<Path> libs = JBangIntegration.findLibrariestoInclude(originalDeps, comments);
        Path war = JBangIntegration.toWar(appClasses, libs);
        try {
            Path glowJar = new File(GlowSession.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toPath();
            Path bootableJar = JBangIntegration.runGlowScan(glowJar, war, glowArgs);
            System.out.println("Bootable Jar: " + bootableJar);
            JBangIntegration.extractJar(bootableJar, appClasses);
            JBangIntegration.deleteDirectory(bootableJar.getParent());
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("main-class", "org.wildfly.core.jar.boot.Main");
            return results;
        }
        catch (Exception e) {
            throw new IOException("Unable to create the WildFly applciation", e);
        }
    }
}

