/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.wildfly.channel.Channel;
import org.wildfly.glow.GoOfflineArguments;
import org.wildfly.glow.MetadataProvider;
import org.wildfly.glow.OutputFormat;

public interface ScanArguments {
    public Set<String> getExecutionProfiles();

    public Set<String> getUserEnabledAddOns();

    public List<Path> getBinaries();

    public Path getProvisioningXML();

    public OutputFormat getOutput();

    public String getExecutionContext();

    public boolean isDisableForkEmbedded();

    public boolean isSuggest();

    public boolean isCloud();

    public String getVersion();

    public Boolean isCompact();

    public boolean isTechPreview();

    public boolean isVerbose();

    public Set<Pattern> getExcludeArchivesFromScan();

    public String getConfigStability();

    public String getPackageStability();

    public String getDefaultConfigStability();

    public boolean isCli();

    public List<Channel> getChannels();

    public Set<String> getSpaces();

    public MetadataProvider getMetadataProvider();

    default public Builder createScanArgumentsBuilder() {
        return new Builder();
    }

    public static class Builder
    extends GoOfflineArguments.Builder {
        Builder() {
        }

        public Builder setExecutionProfiles(Set<String> executionProfiles) {
            this.executionProfiles = executionProfiles;
            return this;
        }

        public Builder setUserEnabledAddOns(Set<String> userEnabledAddOns) {
            this.userEnabledAddOns = userEnabledAddOns;
            return this;
        }

        public Builder setBinaries(List<Path> binaries) {
            this.binaries = binaries;
            return this;
        }

        @Override
        public Builder setProvisoningXML(Path provisoningXML) {
            this.provisioningXML = provisoningXML;
            return this;
        }

        public Builder setOutput(OutputFormat output) {
            this.output = output;
            return this;
        }

        public Builder setSuggest(boolean suggest) {
            this.suggest = suggest;
            return this;
        }

        @Override
        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setExecutionContext(String executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        public Builder setConfigName(String configName) {
            this.configName = configName;
            return this;
        }

        public Builder setJndiLayers(Set<String> layersForJndi) {
            this.layersForJndi = layersForJndi;
            return this;
        }

        public Builder setVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder setTechPreview(boolean techPreview) {
            this.techPreview = techPreview;
            return this;
        }

        public Builder setExcludeArchivesFromScan(String ... archives) {
            return this.setExcludeArchivesFromScan(new HashSet<String>(Arrays.asList(archives)));
        }

        public Builder setExcludeArchivesFromScan(Set<String> archives) {
            this.excludeJarsFromScan = archives;
            return this;
        }

        public Builder setPackageStability(String stability) {
            this.packageStability = stability;
            return this;
        }

        public Builder setConfigStability(String stability) {
            this.configStability = stability;
            return this;
        }

        public Builder setDefaultConfigStability(String stability) {
            this.defaultConfigStability = stability;
            return this;
        }

        public Builder setIsCli(boolean isCli) {
            this.isCli = isCli;
            return this;
        }

        public Builder setChannels(List<Channel> channels) {
            this.channels = channels;
            return this;
        }

        public Builder setSpaces(Set<String> spaces) {
            this.spaces = spaces;
            return this;
        }

        public Builder setMetadataProider(MetadataProvider metadataProvider) {
            this.metadataProvider = metadataProvider;
            return this;
        }

        public Builder setIsDisableForkEmbedded(boolean disableForkEmbedded) {
            this.disableForkEmbedded = disableForkEmbedded;
            return this;
        }
    }
}

