/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DiscriminatorValidator
extends BaseJsonValidator {
    private final String propertyName;
    private final Map<String, String> mapping;

    public DiscriminatorValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.DISCRIMINATOR, validationContext);
        ObjectNode discriminator;
        ObjectNode objectNode = discriminator = schemaNode.isObject() ? (ObjectNode)schemaNode : null;
        if (discriminator != null) {
            ObjectNode mapping;
            JsonNode propertyName = discriminator.get("propertyName");
            this.propertyName = propertyName != null ? propertyName.asText() : "";
            JsonNode mappingNode = discriminator.get("mapping");
            ObjectNode objectNode2 = mapping = mappingNode != null && mappingNode.isObject() ? (ObjectNode)mappingNode : null;
            if (mapping != null) {
                this.mapping = new HashMap<String, String>();
                Iterator<Map.Entry<String, JsonNode>> iter = mapping.fields();
                while (iter.hasNext()) {
                    Map.Entry<String, JsonNode> entry = iter.next();
                    this.mapping.put(entry.getKey(), entry.getValue().asText());
                }
            } else {
                this.mapping = Collections.emptyMap();
            }
        } else {
            this.propertyName = "";
            this.mapping = Collections.emptyMap();
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        return Collections.emptySet();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Map<String, String> getMapping() {
        return this.mapping;
    }
}

