/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.support;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Utils {
    public static void setSystemProperties(Set<String> systemProperties) throws Exception {
        if (!systemProperties.isEmpty()) {
            for (String p : systemProperties) {
                if (p.startsWith("-D")) {
                    String propName;
                    int i = p.indexOf("=");
                    String value = "";
                    if (i > 0) {
                        propName = p.substring(2, i);
                        value = p.substring(i + 1);
                    } else {
                        propName = p.substring(2);
                    }
                    System.setProperty(propName, value);
                    continue;
                }
                throw new Exception("Invalid system property " + p + ". A property must start with -D");
            }
        }
    }

    public static Map<String, String> handleOpenShiftEnvFile(Path envFile) throws Exception {
        HashMap<String, String> extraEnv = new HashMap<String, String>();
        if (!Files.exists(envFile, new LinkOption[0])) {
            throw new Exception(String.valueOf(envFile) + " file doesn't exist");
        }
        for (String l : Files.readAllLines(envFile)) {
            if ((l = l.trim()).isEmpty() || l.startsWith("#")) continue;
            int i = l.indexOf("=");
            if (i < 0 || i == l.length() - 1) {
                throw new Exception("Invalid environment variable " + l + " in " + String.valueOf(envFile));
            }
            extraEnv.put(l.substring(0, i), l.substring(i + 1));
        }
        return extraEnv;
    }

    public static Map<String, String> readConfigFile(Path file) throws Exception {
        if (file == null) {
            return Collections.emptyMap();
        }
        if (!Files.exists(file, new LinkOption[0])) {
            throw new Exception("File " + String.valueOf(file) + " doesn't exist.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String l : Files.readAllLines(file)) {
            if ((l = l.trim()).startsWith("#")) continue;
            String[] split = l.split("=");
            map.put(split[0].trim(), split[1].trim());
        }
        return map;
    }

    public static void addAddOnsFromConfig(Map<String, String> config, Set<String> addOns) throws Exception {
        String val = config.get("add-ons");
        if (val != null) {
            String[] addOnsArray;
            for (String addOn : addOnsArray = val.split(",")) {
                addOns.add(addOn.trim());
            }
        }
    }

    public static String getServerVersionFromConfig(Map<String, String> config) throws Exception {
        return config.get("server-version");
    }

    public static void addDisableDeployersFromConfig(Map<String, String> config, Set<String> addOns) throws Exception {
        String val = config.get("disable-deployers");
        if (val != null) {
            String[] addOnsArray;
            for (String addOn : addOnsArray = val.split(",")) {
                addOns.add(addOn.trim());
            }
        }
    }

    public static void addEnableDeployersFromConfig(Map<String, String> config, Set<String> addOns) throws Exception {
        String val = config.get("enable-deployers");
        if (val != null) {
            String[] addOnsArray;
            for (String addOn : addOnsArray = val.split(",")) {
                addOns.add(addOn.trim());
            }
        }
    }

    public static Boolean getHaFromConfig(Map<String, String> config) {
        String val = config.get("ha");
        return Boolean.valueOf(val);
    }
}

