/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.wildfly.glow.GlowMessageWriter;

public class ExecUtil {
    private static final int PROCESS_CHECK_INTERVAL = 500;

    public static boolean exec(String command, GlowMessageWriter writer, String ... args) {
        return ExecUtil.exec(new File("."), command, writer, args);
    }

    public static boolean execSilentWithTimeout(Duration timeout, String command, GlowMessageWriter writer, String ... args) {
        return ExecUtil.execWithTimeout(new File("."), timeout, command, writer, args);
    }

    public static boolean exec(File directory, String command, GlowMessageWriter writer, String ... args) {
        try {
            Process process = ExecUtil.startProcess(directory, command, args);
            new HandleOutput(process.getInputStream(), writer).run();
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static boolean execWithTimeout(File directory, Duration timeout, String command, GlowMessageWriter writer, String ... args) {
        try {
            Process process = ExecUtil.startProcess(directory, command, args);
            Thread t = new Thread(new HandleOutput(process.getInputStream(), writer));
            t.setName("Process stdout");
            t.setDaemon(true);
            t.start();
            process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
            ExecUtil.destroyProcess(process);
            return process.exitValue() == 0;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static Process startProcess(File directory, String command, String ... args) {
        try {
            String[] cmd = new String[args.length + 1];
            cmd[0] = command;
            if (args.length > 0) {
                System.arraycopy(args, 0, cmd, 1, args.length);
            }
            return new ProcessBuilder(new String[0]).directory(directory).command(cmd).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while executing command.", e);
        }
    }

    public static void destroyProcess(Process process) {
        process.destroy();
        int i = 0;
        while (process.isAlive() && i++ < 10) {
            try {
                process.waitFor(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        if (process.isAlive()) {
            process.destroyForcibly();
        }
    }

    public static String resolveImageBinary(GlowMessageWriter writer) {
        try {
            if (ExecUtil.execSilentWithTimeout(Duration.ofSeconds(3L), "docker", writer, "-v")) {
                return "docker";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (ExecUtil.execSilentWithTimeout(Duration.ofSeconds(3L), "podman", writer, "-v")) {
                return "podman";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static class HandleOutput
    implements Runnable {
        private final InputStream is;
        private final GlowMessageWriter writer;

        HandleOutput(InputStream is, GlowMessageWriter writer) {
            this.is = is;
            this.writer = writer;
        }

        @Override
        public void run() {
            try (InputStreamReader isr = new InputStreamReader(this.is);
                 BufferedReader reader = new BufferedReader(isr);){
                String line = reader.readLine();
                while (line != null) {
                    this.writer.info(line);
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                System.err.println("Failed to handle output" + String.valueOf(e));
            }
        }
    }
}

