/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.GlowMessageWriter;
import org.wildfly.glow.GlowSession;
import org.wildfly.glow.HiddenPropertiesAccessor;
import org.wildfly.glow.OutputContent;
import org.wildfly.glow.OutputFormat;
import org.wildfly.glow.ScanArguments;
import org.wildfly.glow.ScanResults;
import org.wildfly.glow.StabilitySupport;
import org.wildfly.glow.cli.support.AbstractCommand;
import org.wildfly.glow.cli.support.CLIConfigurationResolver;
import org.wildfly.glow.cli.support.Utils;
import org.wildfly.glow.deployment.openshift.api.OpenShiftConfiguration;
import org.wildfly.glow.deployment.openshift.api.OpenShiftSupport;
import org.wildfly.glow.error.IdentifiedError;
import org.wildfly.glow.maven.MavenResolver;
import picocli.CommandLine;

@CommandLine.Command(name="scan", sortOptions=true)
public class ScanCommand
extends AbstractCommand {
    private static final String ADD_ADD_ONS_MSG = "@|bold To enable add-ons, add the|@ @|fg(yellow) --add-ons=<list of add-ons>|@ @|bold option to the|@ @|fg(yellow) scan|@ @|bold command|@";
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-s", "--suggest"})
    Optional<Boolean> suggest;
    @CommandLine.Option(names={"--ha"})
    Optional<Boolean> haProfile;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"-di", "--docker-image-name"}, paramLabel="<docker image name>")
    Optional<String> dockerImageName;
    @CommandLine.Option(names={"--add-layers-for-jndi"}, split=",", paramLabel="<layer>")
    Set<String> layersForJndi = new LinkedHashSet<String>();
    @CommandLine.Option(names={"-ao", "--add-ons"}, split=",", paramLabel="<add-on>")
    Set<String> addOns = new LinkedHashSet<String>();
    @CommandLine.Parameters(descriptionKey="deployments")
    List<Path> deployments;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;
    @CommandLine.Option(converter={ProvisionConverter.class}, names={"-p", "--provision"}, paramLabel="<SERVER|BOOTABLE_JAR|OPENSHIFT|DOCKER_IMAGE|PROVISIONING_XML>")
    Optional<OutputFormat> provision;
    @CommandLine.Option(names={"-d", "--output-dir"}, paramLabel="<output directory>")
    Optional<String> provisionOutputDir;
    @CommandLine.Option(names={"-ea", "--exclude-archives-from-scan"}, split=",", paramLabel="<list of nested archive names>")
    Set<String> excludeArchivesFromScan = new HashSet<String>();
    @CommandLine.Option(names={"--stability-level", "-sl"}, paramLabel="<default|community|preview|experimental>")
    Optional<String> stability;
    @CommandLine.Option(names={"--package-stability-level", "-psl"}, paramLabel="<default|community|preview|experimental>")
    Optional<String> packageStability;
    @CommandLine.Option(names={"--config-stability-level", "-csl"}, paramLabel="<default|community|preview|experimental>")
    Optional<String> configStability;
    @CommandLine.Option(names={"-ef", "--env-file"}, paramLabel="<env file path>")
    Optional<Path> envFile;
    @CommandLine.Option(names={"-bef", "--build-env-file"}, paramLabel="<build env file path>")
    Optional<Path> buildEnvFile;
    @CommandLine.Option(names={"-is", "--init-script"}, paramLabel="<init script file path>")
    Optional<Path> initScriptFile;
    @CommandLine.Option(names={"-cs", "--cli-script"}, paramLabel="<CLI script file path>")
    Optional<Path> cliScriptFile;
    @CommandLine.Option(names={"--disable-deployers"}, split=",", paramLabel="<ALL|deployer name>")
    Set<String> disableDeployers = new LinkedHashSet<String>();
    @CommandLine.Option(names={"--enable-deployers"}, split=",", paramLabel="<deployer name>")
    Set<String> enableDeployers = new LinkedHashSet<String>();
    @CommandLine.Option(names={"-pp", "--properties"}, split=" ", paramLabel="\"<-DpropName[=value] [-DpropName[=value]]>\"")
    Set<String> systemProperties = new HashSet<String>();
    @CommandLine.Option(names={"-foe", "--fails-on-error"}, defaultValue="true")
    Optional<Boolean> failsOnError;
    @CommandLine.Option(names={"-cc", "--channels"}, paramLabel="<Channels yaml file path>")
    Optional<Path> channelsFile;
    @CommandLine.Option(names={"--config-file"}, paramLabel="<Path to the configuration file>")
    Optional<Path> configFile;
    @CommandLine.Option(names={"--app-name"}, paramLabel="<application name>")
    Optional<String> appName;
    @CommandLine.Option(names={"--dry-run"})
    Optional<Boolean> dryRun;
    @CommandLine.Option(names={"-sp", "--spaces"}, split=",", paramLabel="<space1,space2, ...>")
    Set<String> spaces = new LinkedHashSet<String>();
    @CommandLine.Option(names={"-df", "--disable-fork-embedded"})
    Optional<Boolean> disableForkEmbedded;

    @Override
    public Integer call() throws Exception {
        Path p;
        Utils.setSystemProperties(this.systemProperties);
        Map<String, String> configMap = Utils.readConfigFile(this.configFile.orElse(null));
        HiddenPropertiesAccessor hiddenPropertiesAccessor = new HiddenPropertiesAccessor();
        boolean compact = Boolean.parseBoolean(hiddenPropertiesAccessor.getProperty("compact"));
        if (!compact) {
            this.print("Wildfly Glow is scanning...");
        }
        ScanArguments.Builder builder = Arguments.scanBuilder();
        HashSet<String> profiles = new HashSet<String>();
        profiles.add("ha");
        boolean haProfileEnabled = this.haProfile.orElse(false);
        if (haProfileEnabled) {
            builder.setExecutionProfiles(profiles);
        } else {
            haProfileEnabled = Utils.getHaFromConfig(configMap);
            if (haProfileEnabled) {
                builder.setExecutionProfiles(profiles);
            }
        }
        if (!this.layersForJndi.isEmpty()) {
            builder.setJndiLayers(this.layersForJndi);
        }
        if (!this.spaces.isEmpty()) {
            builder.setSpaces(this.spaces);
        }
        if (this.suggest.orElse(false).booleanValue()) {
            builder.setSuggest(true);
        }
        if (this.wildflyPreview.orElse(false).booleanValue()) {
            if (this.channelsFile.isPresent()) {
                throw new Exception("--wildfly-previewcan't be set when --channels is set.");
            }
            builder.setTechPreview(true);
        }
        if (this.wildflyServerVersion.isPresent()) {
            if (this.channelsFile.isPresent()) {
                throw new Exception("--server-versioncan't be set when --channels is set.");
            }
            builder.setVersion(this.wildflyServerVersion.get());
        } else {
            String vers = Utils.getServerVersionFromConfig(configMap);
            if (vers != null) {
                builder.setVersion(vers);
            }
        }
        HashMap<String, String> extraEnv = new HashMap<String, String>();
        HashMap<String, String> buildExtraEnv = new HashMap<String, String>();
        if (this.envFile.isPresent()) {
            if (this.provision.isPresent()) {
                if (!OutputFormat.OPENSHIFT.equals((Object)this.provision.get())) {
                    throw new Exception("Env file is only usable when --provision=" + String.valueOf((Object)OutputFormat.OPENSHIFT) + " option is set.");
                }
            } else {
                throw new Exception("Env file is only usable when --provision=" + String.valueOf((Object)OutputFormat.OPENSHIFT) + " option is set.");
            }
            extraEnv.putAll(Utils.handleOpenShiftEnvFile(this.envFile.get()));
        }
        if (this.disableForkEmbedded.isPresent()) {
            builder.setIsDisableForkEmbedded(this.disableForkEmbedded.get());
        }
        if (this.dryRun.isPresent()) {
            if (this.provision.isPresent()) {
                if (!OutputFormat.OPENSHIFT.equals((Object)this.provision.get())) {
                    throw new Exception("--dry-run is only usable when --provision=" + String.valueOf((Object)OutputFormat.OPENSHIFT) + " option is set.");
                }
            } else {
                throw new Exception("--dry-run is only usable when --provision=" + String.valueOf((Object)OutputFormat.OPENSHIFT) + " option is set.");
            }
        }
        if (this.buildEnvFile.isPresent()) {
            if (this.provision.isPresent()) {
                if (!OutputFormat.OPENSHIFT.equals((Object)this.provision.get())) {
                    throw new Exception("Build env file is only usable when --provision=" + String.valueOf((Object)OutputFormat.OPENSHIFT) + " option is set.");
                }
            } else {
                throw new Exception("Build env file is only usable when --provision=" + String.valueOf((Object)OutputFormat.OPENSHIFT) + " option is set.");
            }
            buildExtraEnv.putAll(Utils.handleOpenShiftEnvFile(this.buildEnvFile.get()));
        }
        if (this.cliScriptFile.isPresent()) {
            if (this.provision.isPresent()) {
                if (!OutputFormat.OPENSHIFT.equals((Object)this.provision.get())) {
                    throw new Exception("CLI script file is only usable when --provision=" + String.valueOf((Object)OutputFormat.OPENSHIFT) + " option is set.");
                }
            } else {
                throw new Exception("CLI script file file is only usable when --provision=" + String.valueOf((Object)OutputFormat.OPENSHIFT) + " option is set.");
            }
            p = this.cliScriptFile.get();
            if (!Files.exists(p, new LinkOption[0])) {
                throw new Exception(String.valueOf(p) + " file doesn't exist");
            }
        }
        if (this.initScriptFile.isPresent()) {
            if (this.provision.isPresent()) {
                if (!OutputFormat.OPENSHIFT.equals((Object)this.provision.get())) {
                    throw new Exception("Init script file is only usable when --provision=" + String.valueOf((Object)OutputFormat.OPENSHIFT) + " option is set.");
                }
            } else {
                throw new Exception("Init script file file is only usable when --provision=" + String.valueOf((Object)OutputFormat.OPENSHIFT) + " option is set.");
            }
            p = this.initScriptFile.get();
            if (!Files.exists(p, new LinkOption[0])) {
                throw new Exception(String.valueOf(p) + " file doesn't exist");
            }
        }
        builder.setVerbose(this.verbose);
        Utils.addAddOnsFromConfig(configMap, this.addOns);
        if (!this.addOns.isEmpty()) {
            builder.setUserEnabledAddOns(this.addOns);
        }
        if (this.deployments != null && !this.deployments.isEmpty()) {
            builder.setBinaries(this.deployments);
        }
        if (this.provisioningXml.isPresent()) {
            builder.setProvisoningXML(this.provisioningXml.get());
        }
        MavenRepoManager repoManager = null;
        if (this.channelsFile.isPresent()) {
            Path channelsFilePath = this.channelsFile.get();
            if (!Files.exists(channelsFilePath, new LinkOption[0])) {
                throw new Exception(String.valueOf(channelsFilePath) + " file doesn't exist");
            }
            String content = Files.readString(channelsFilePath);
            List<Channel> channels = ChannelMapper.fromString(content);
            builder.setChannels(channels);
            repoManager = MavenResolver.newMavenResolver(channels);
        } else {
            repoManager = MavenResolver.newMavenResolver();
        }
        if (this.provision.isPresent()) {
            if (OutputFormat.BOOTABLE_JAR.equals((Object)this.provision.get()) && this.cloud.orElse(false).booleanValue()) {
                throw new Exception("Can't produce a Bootable JAR for cloud. Use the --provision=SERVER option for cloud.");
            }
            if (OutputFormat.DOCKER_IMAGE.equals((Object)this.provision.get()) && !this.cloud.orElse(false).booleanValue()) {
                this.cloud = Optional.of(Boolean.TRUE);
            }
            if (OutputFormat.OPENSHIFT.equals((Object)this.provision.get()) && !this.cloud.orElse(false).booleanValue()) {
                this.cloud = Optional.of(Boolean.TRUE);
            }
            builder.setOutput(this.provision.get());
        }
        if (this.cloud.orElse(false).booleanValue()) {
            builder.setExecutionContext("cloud");
        }
        builder.setExcludeArchivesFromScan(this.excludeArchivesFromScan);
        String userSetConfigStability = null;
        builder.setDefaultConfigStability("community");
        if (this.stability.isPresent()) {
            if (this.configStability.isPresent()) {
                throw new Exception("--config-stability-level can't be set when --stability-level is set");
            }
            if (this.packageStability.isPresent()) {
                throw new Exception("--package-stability-level can't be set when --stability-level is set");
            }
            StabilitySupport.checkStability(this.stability.get());
            userSetConfigStability = this.stability.get();
            builder.setConfigStability(this.stability.get());
            builder.setPackageStability(this.stability.get());
        }
        if (this.configStability.isPresent()) {
            StabilitySupport.checkStability(this.configStability.get());
            userSetConfigStability = this.configStability.get();
            builder.setConfigStability(this.configStability.get());
        }
        if (this.packageStability.isPresent()) {
            StabilitySupport.checkStability(this.packageStability.get());
            builder.setPackageStability(this.packageStability.get());
        }
        if (this.dockerImageName.isPresent() && this.provision.isPresent() && !OutputFormat.DOCKER_IMAGE.equals((Object)this.provision.get())) {
            throw new Exception("Can only set a docker image name when provisioning a docker image. Remove the --docker-image-name option");
        }
        Utils.addDisableDeployersFromConfig(configMap, this.disableDeployers);
        Utils.addEnableDeployersFromConfig(configMap, this.enableDeployers);
        builder.setIsCli(true);
        ScanResults scanResults = GlowSession.scan(repoManager, builder.build(), GlowMessageWriter.DEFAULT);
        CLIConfigurationResolver configurationResolver = new CLIConfigurationResolver(this.provision.isPresent() && this.provision.get().equals((Object)OutputFormat.OPENSHIFT), this.disableDeployers, this.enableDeployers);
        scanResults.outputInformation(configurationResolver);
        if (this.provision.isEmpty()) {
            if (!compact) {
                if (this.suggest.orElse(false).booleanValue()) {
                    if (!scanResults.getSuggestions().getPossibleAddOns().isEmpty() && this.addOns.isEmpty()) {
                        this.print(ADD_ADD_ONS_MSG);
                    }
                    if (!scanResults.getSuggestions().getPossibleProfiles().isEmpty()) {
                        this.print("@|bold To enable the HA profile, add the|@ @|fg(yellow) %s|@ @|bold option to the|@ @|fg(yellow) %s|@ @|bold command|@", "--ha", "scan");
                    }
                }
                if (scanResults.getErrorSession().hasErrors()) {
                    if (!this.suggest.orElse(false).booleanValue()) {
                        boolean hasAddOn = false;
                        for (IdentifiedError err : scanResults.getErrorSession().getErrors()) {
                            if (err.getPossibleAddons().isEmpty()) continue;
                            hasAddOn = true;
                            break;
                        }
                        if (hasAddOn) {
                            System.out.println(CommandLine.Help.Ansi.AUTO.string(ADD_ADD_ONS_MSG));
                        }
                    }
                    this.print("@|bold Some errors have been reported. You should fix them prior provisioning a server with the|@ @|fg(yellow) --provision|@ @|bold option of the|@ @|fg(yellow) scan|@ @|bold command|@");
                } else {
                    this.print("@|bold If you had included a|@ @|fg(yellow) --provision=<SERVER|BOOTABLE_JAR|OPENSHIFT|DOCKER_IMAGE|PROVISIONING_XML>|@ @|bold option to the|@ @|fg(yellow) scan|@ @|bold command, after outputting this report, WildFly Glow will continue on to provisioning your WildFly server, bootable jar, a Docker image or deploy your application to OpenShift.|@");
                }
            }
        } else {
            this.print();
            if (this.failsOnError.orElse(false).booleanValue() && scanResults.getErrorSession().hasErrors()) {
                throw new Exception("Your are provisioning although errors have been reported. If you want to enforce provisioning, set --fails-on-error=false to ignore errors.");
            }
            FeaturePackLocation.ProducerSpec baseProducer = scanResults.getProvisioningConfig().getFeaturePackDeps().iterator().next().getLocation().getProducer();
            String vers = scanResults.getFeaturePackVersions().get(baseProducer).getBuild();
            Path target = Paths.get(this.provisionOutputDir.orElse("server-" + vers), new String[0]);
            IoUtils.recursiveDelete(target);
            switch (this.provision.get()) {
                case BOOTABLE_JAR: {
                    if (this.provisionOutputDir.isEmpty()) {
                        target = Paths.get("", new String[0]);
                    }
                    this.print("@|bold Building WildFly Bootable JAR file...|@");
                    break;
                }
                case PROVISIONING_XML: {
                    this.print("@|bold Generating Galleon provisioning configuration file...|@");
                    break;
                }
                case SERVER: {
                    this.print("@|bold Provisioning server...|@", target);
                    break;
                }
                case DOCKER_IMAGE: {
                    this.print("@|bold Generating docker image...|@");
                    break;
                }
                case OPENSHIFT: {
                    if (this.dryRun.isPresent()) {
                        this.print("@|bold Openshift resources generation...|@");
                        break;
                    }
                    this.print("@|bold Openshift build and deploy...|@");
                }
            }
            OutputContent content = scanResults.outputConfig(target, this.dockerImageName.orElse(null));
            Path base = Paths.get("", new String[0]).toAbsolutePath();
            String envMessage = null;
            String completedMessage = null;
            for (OutputContent.OutputFile f : content.getFiles().keySet()) {
                Path rel = base.relativize(content.getFiles().get((Object)f));
                block7 : switch (f) {
                    case BOOTABLE_JAR_FILE: {
                        completedMessage = "@|bold To run the jar call: 'java -jar " + String.valueOf(rel) + "'|@";
                        break;
                    }
                    case DOCKER_FILE: {
                        this.print("@|bold Docker file generated in %s|@.", rel);
                        break;
                    }
                    case ENV_FILE: {
                        switch (this.provision.get()) {
                            case SERVER: {
                                envMessage = "WARNING: You have to export the suggested env variables prior to start the server.";
                                break block7;
                            }
                            case BOOTABLE_JAR: {
                                envMessage = "WARNING: You have to export the suggested env variables prior to start the bootable JAR.";
                                break block7;
                            }
                            case DOCKER_IMAGE: {
                                envMessage = "WARNING: For each suggested env variable add `-e <env name>=<env value>` to the `[docker | podman] run` command.";
                            }
                        }
                        break;
                    }
                    case PROVISIONING_XML_FILE: {
                        switch (this.provision.get()) {
                            case PROVISIONING_XML: {
                                this.print("@|bold Galleon Provisioning configuration is located in " + String.valueOf(rel) + " file|@");
                            }
                        }
                        break;
                    }
                    case CHANNEL_FILE: {
                        switch (this.provision.get()) {
                            case PROVISIONING_XML: {
                                this.print("@|bold WildFly Channel is located in " + String.valueOf(rel) + " file|@");
                            }
                        }
                        break;
                    }
                    case SERVER_DIR: {
                        completedMessage = this.cloud.orElse(false) != false ? "@|bold To run the server call: 'JBOSS_HOME=" + String.valueOf(rel) + " sh " + String.valueOf(rel) + "/bin/openshift-launch.sh'|@" : "@|bold To run the server call: 'sh " + String.valueOf(rel) + "/bin/standalone.sh" + (String)(userSetConfigStability == null ? "" : " --stability=" + userSetConfigStability) + "'|@";
                    }
                }
            }
            if (OutputFormat.OPENSHIFT.equals((Object)this.provision.get())) {
                OpenShiftSupport.deploy(this.deployments, this.appName.orElse(null), GlowMessageWriter.DEFAULT, target, scanResults, haProfileEnabled, extraEnv, buildExtraEnv, this.disableDeployers, this.enableDeployers, this.initScriptFile.orElse(null), this.cliScriptFile.orElse(null), new OpenShiftConfiguration.Builder().build(), MavenResolver.newMavenResolver(), userSetConfigStability, Collections.emptyMap(), this.dryRun.isPresent(), scanResults.getChannels());
                if (this.dryRun.isPresent()) {
                    this.print("@|bold \nCloud resources generation DONE.|@");
                } else {
                    this.print("@|bold \nOpenshift build and deploy DONE.|@");
                }
            } else if (content.getDockerImageName() != null) {
                this.print("@|bold To run the image call: '[docker | podman] run -p 8080:8080 -p 9990:9990 " + content.getDockerImageName() + "'|@");
                if (envMessage != null) {
                    GlowMessageWriter.DEFAULT.warn(envMessage);
                }
            } else if (completedMessage != null) {
                this.print(completedMessage);
                if (envMessage != null) {
                    GlowMessageWriter.DEFAULT.warn(envMessage);
                }
            }
        }
        return 0;
    }

    private static class ProvisionConverter
    implements CommandLine.ITypeConverter<OutputFormat> {
        private ProvisionConverter() {
        }

        @Override
        public OutputFormat convert(String value) throws Exception {
            return OutputFormat.valueOf(value.toUpperCase());
        }
    }
}

