/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.cli;

import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.wildfly.plugin.tools.bootablejar.BootLoggingConfiguration;
import org.wildfly.plugin.tools.cli.CLIWrapper;

public class CLIForkedBootConfigGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Path jbossHome = Paths.get(args[0], new String[0]);
        Path cliOutput = Paths.get(args[1], new String[0]);
        Path systemProperties = Paths.get(args[2], new String[0]);
        String stabilityLevel = null;
        if (args.length >= 4) {
            stabilityLevel = args[3];
        }
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(systemProperties.toFile());){
            properties.load(in);
            for (String key : properties.stringPropertyNames()) {
                System.setProperty(key, properties.getProperty(key));
            }
        }
        try (CLIWrapper executor = new CLIWrapper(jbossHome, false, CLIForkedBootConfigGenerator.class.getClassLoader(), new BootLoggingConfiguration(), stabilityLevel);){
            try {
                executor.generateBootLoggingConfig();
            }
            finally {
                Files.write(cliOutput, executor.getOutput().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
    }
}

