/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.wildfly.channel.BlocklistCoordinate;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.channel.Vendor;

public class Channel {
    public static final String CLASSIFIER = "channel";
    public static final String EXTENSION = "yaml";
    private String schemaVersion;
    private String name;
    private String description;
    private Vendor vendor;
    private List<Repository> repositories = new ArrayList<Repository>();
    private BlocklistCoordinate blocklistCoordinate;
    private ChannelManifestCoordinate manifestCoordinate;
    private NoStreamStrategy noStreamStrategy = NoStreamStrategy.NONE;

    public Channel() {
        this.schemaVersion = "2.0.0";
    }

    public Channel(String name, String description, Vendor vendor, List<Repository> repositories, ChannelManifestCoordinate manifestCoordinate, BlocklistCoordinate blocklistCoordinate, NoStreamStrategy noStreamStrategy) {
        this("2.0.0", name, description, vendor, repositories, manifestCoordinate, blocklistCoordinate, noStreamStrategy);
    }

    @JsonCreator
    public Channel(@JsonProperty(value="schemaVersion", required=true) String schemaVersion, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="vendor") Vendor vendor, @JsonProperty(value="repositories") @JsonInclude(value=JsonInclude.Include.NON_EMPTY) List<Repository> repositories, @JsonProperty(value="manifest") ChannelManifestCoordinate manifestCoordinate, @JsonProperty(value="blocklist") @JsonInclude(value=JsonInclude.Include.NON_EMPTY) BlocklistCoordinate blocklistCoordinate, @JsonProperty(value="resolve-if-no-stream") NoStreamStrategy noStreamStrategy) {
        this.schemaVersion = schemaVersion;
        this.name = name;
        this.description = description;
        this.vendor = vendor;
        this.repositories = repositories != null ? repositories : Collections.emptyList();
        this.blocklistCoordinate = blocklistCoordinate;
        this.manifestCoordinate = manifestCoordinate;
        this.noStreamStrategy = noStreamStrategy != null ? noStreamStrategy : NoStreamStrategy.NONE;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Vendor getVendor() {
        return this.vendor;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Repository> getRepositories() {
        return this.repositories;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="blocklist")
    public BlocklistCoordinate getBlocklistCoordinate() {
        return this.blocklistCoordinate;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="manifest")
    public ChannelManifestCoordinate getManifestCoordinate() {
        return this.manifestCoordinate;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="resolve-if-no-stream")
    public NoStreamStrategy getNoStreamStrategy() {
        return this.noStreamStrategy;
    }

    public String toString() {
        return "Channel{schemaVersion='" + this.schemaVersion + "', name='" + this.name + "', description='" + this.description + "', vendor=" + this.vendor + ", repositories=" + this.repositories + ", blocklistCoordinate=" + this.blocklistCoordinate + ", manifestCoordinate=" + this.manifestCoordinate + ", noStreamStrategy=" + this.noStreamStrategy + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel channel = (Channel)o;
        return Objects.equals(this.schemaVersion, channel.schemaVersion) && Objects.equals(this.name, channel.name) && Objects.equals(this.description, channel.description) && Objects.equals(this.vendor, channel.vendor) && Objects.equals(this.repositories, channel.repositories) && Objects.equals(this.blocklistCoordinate, channel.blocklistCoordinate) && Objects.equals(this.manifestCoordinate, channel.manifestCoordinate) && this.noStreamStrategy == channel.noStreamStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaVersion, this.name, this.description, this.vendor, this.repositories, this.blocklistCoordinate, this.manifestCoordinate, this.noStreamStrategy});
    }

    public static class Builder {
        private String name;
        private List<Repository> repositories = new ArrayList<Repository>();
        private ChannelManifestCoordinate manifestCoordinate;
        private BlocklistCoordinate blocklistCoordinate;
        private NoStreamStrategy strategy;
        private String description;
        private Vendor vendor;

        public Builder() {
        }

        public Builder(Channel from) {
            this.name = from.getName();
            this.repositories = new ArrayList<Repository>(from.getRepositories());
            this.manifestCoordinate = from.getManifestCoordinate();
            this.blocklistCoordinate = from.getBlocklistCoordinate();
            this.strategy = from.getNoStreamStrategy();
            this.description = from.getDescription();
            this.vendor = from.getVendor();
        }

        public Channel build() {
            return new Channel(this.name, this.description, this.vendor, this.repositories, this.manifestCoordinate, this.blocklistCoordinate, this.strategy);
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setRepositories(List<Repository> repositories) {
            this.repositories = repositories;
            return this;
        }

        public Builder setVendor(Vendor vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder addRepository(String repoId, String url) {
            this.repositories.add(new Repository(repoId, url));
            return this;
        }

        public Builder setManifestCoordinate(String groupId, String artifactId, String version) {
            this.manifestCoordinate = new ChannelManifestCoordinate(groupId, artifactId, version);
            return this;
        }

        public Builder setManifestCoordinate(String groupId, String artifactId) {
            this.manifestCoordinate = new ChannelManifestCoordinate(groupId, artifactId);
            return this;
        }

        public Builder setManifestUrl(URL url) {
            this.manifestCoordinate = new ChannelManifestCoordinate(url);
            return this;
        }

        public Builder setManifestCoordinate(ChannelManifestCoordinate coordinate) {
            this.manifestCoordinate = coordinate;
            return this;
        }

        public Builder setBlocklist(String groupId, String artifactId, String version) {
            this.blocklistCoordinate = version == null ? new BlocklistCoordinate(groupId, artifactId) : new BlocklistCoordinate(groupId, artifactId, version);
            return this;
        }

        public Builder setBlocklistCoordinate(BlocklistCoordinate blocklistCoordinate) {
            this.blocklistCoordinate = blocklistCoordinate;
            return this;
        }

        public Builder setResolveStrategy(NoStreamStrategy strategy) {
            this.strategy = strategy;
            return this;
        }
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public static enum NoStreamStrategy {
        LATEST,
        MAVEN_LATEST,
        MAVEN_RELEASE,
        NONE;

    }
}

