/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.wildfly.glow.NestedWarOrExplodedArchiveFileVisitor;
import org.wildfly.glow.Utils;

public class DeploymentFileRuleInspector {
    private final Path rootPath;
    private final boolean archive;
    private final ArchiveFileRegistry archiveFileRegistry;

    public DeploymentFileRuleInspector(Path rootPath, boolean archive) throws IOException {
        this.rootPath = rootPath;
        this.archive = archive;
        this.archiveFileRegistry = new ArchiveFileRegistry(rootPath);
    }

    public ParsedRule extractParsedRule(String prop) {
        return ParsedRule.extract(this.archiveFileRegistry, this.rootPath, prop);
    }

    private static String toUnixFilePath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    private class ArchiveFileRegistry {
        private final Map<String, Path> allFilePaths;
        private final Path rootPath;

        public ArchiveFileRegistry(Path rootPath) throws IOException {
            final HashMap allFilePaths = new HashMap();
            Files.walkFileTree(rootPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new NestedWarOrExplodedArchiveFileVisitor(rootPath, DeploymentFileRuleInspector.this.archive){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    allFilePaths.put(DeploymentFileRuleInspector.toUnixFilePath(dir.toString()), dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    allFilePaths.put(DeploymentFileRuleInspector.toUnixFilePath(file.toString()), file);
                    return FileVisitResult.CONTINUE;
                }
            });
            this.allFilePaths = Collections.unmodifiableMap(allFilePaths);
            this.rootPath = rootPath;
        }

        List<Path> getArchivePaths(List<PatternOrValue> rulePaths) {
            ArrayList<Path> paths = new ArrayList<Path>();
            for (PatternOrValue path : rulePaths) {
                if (!path.isPattern()) {
                    if (!this.allFilePaths.containsKey(path.value)) continue;
                    paths.add(this.allFilePaths.get(path.value));
                    continue;
                }
                for (Map.Entry<String, Path> entry : this.allFilePaths.entrySet()) {
                    if (!path.pattern.matcher(entry.getKey()).matches()) continue;
                    paths.add(entry.getValue());
                }
            }
            return paths;
        }

        private String pathRelativeToRoot(String path) {
            if (path.startsWith("/")) {
                return path.substring(1);
            }
            return path;
        }

        private String adjustPatternInputRelativeToRoot(Path rootPath, String pathPattern) {
            if (rootPath.toString().endsWith("/")) {
                return String.valueOf(rootPath) + this.pathRelativeToRoot(pathPattern);
            }
            return String.valueOf(rootPath) + pathPattern;
        }
    }

    public static class ParsedRule {
        private final List<PatternOrValue> fileParts;
        private final List<PatternOrValue> valueParts;
        private final List<Path> matchedPaths;

        public ParsedRule(List<PatternOrValue> fileParts, List<PatternOrValue> valueParts, List<Path> matchedPaths) {
            this.fileParts = fileParts;
            this.valueParts = valueParts;
            this.matchedPaths = matchedPaths;
        }

        private static ParsedRule extract(ArchiveFileRegistry registry, Path rootPath, String prop) {
            List<PatternOrValue> valueParts;
            List<PatternOrValue> fileParts;
            if (prop.startsWith("[")) {
                int index = prop.indexOf("]");
                if (index == -1) {
                    throw new IllegalStateException("Expected a closing ']' in " + prop);
                }
                String filesPart = prop.substring(1, index);
                fileParts = ParsedRule.patternOrValueListFromArray(filesPart.split(","), p -> PatternOrValue.createForFile(rootPath, p));
                if ((index = prop.indexOf(44, index + 1)) == -1) {
                    valueParts = Collections.emptyList();
                } else {
                    String values = prop.substring(index + 1);
                    valueParts = ParsedRule.patternOrValueListFromArray(values.split(","), v -> PatternOrValue.createForValue(v));
                }
            } else {
                String[] split = prop.split(",");
                fileParts = ParsedRule.patternOrValueListFromArray(new String[]{split[0]}, p -> PatternOrValue.createForFile(rootPath, p));
                valueParts = ParsedRule.patternOrValueListFromArray(Arrays.copyOfRange(split, 1, split.length), v -> PatternOrValue.createForValue(v));
            }
            List<Path> matchedPaths = registry.getArchivePaths(fileParts);
            return new ParsedRule(fileParts, valueParts, matchedPaths);
        }

        private static List<PatternOrValue> patternOrValueListFromArray(String[] arr, Function<String, PatternOrValue> factory) {
            return Arrays.stream(arr).map(v -> (PatternOrValue)factory.apply((String)v)).collect(Collectors.toList());
        }

        public List<Path> getMatchedPaths() {
            return this.matchedPaths;
        }

        public List<PatternOrValue> getValueParts() {
            return this.valueParts;
        }

        public void iterateMatchedPaths(MatchedPathConsumer consumer) throws Exception {
            for (Path path : this.matchedPaths) {
                if (!Files.exists(path, new LinkOption[0])) continue;
                consumer.accept(path, this.valueParts);
            }
        }
    }

    @FunctionalInterface
    public static interface MatchedPathConsumer {
        public void accept(Path var1, List<PatternOrValue> var2) throws Exception;
    }

    public static class PatternOrValue {
        private final String value;
        private final Pattern pattern;

        private PatternOrValue(String value, Pattern pattern) {
            this.value = value;
            this.pattern = pattern;
        }

        static PatternOrValue createForFile(Path rootPath, String path) {
            String escapedPath;
            Pattern pattern = null;
            if (Utils.isPattern(path)) {
                escapedPath = Utils.escapePattern(path);
                escapedPath = PatternOrValue.adjustPatternInputRelativeToRoot(rootPath, escapedPath);
                pattern = Pattern.compile(escapedPath);
            } else {
                escapedPath = rootPath.resolve(PatternOrValue.pathRelativeToRoot(path)).toString();
                escapedPath = DeploymentFileRuleInspector.toUnixFilePath(escapedPath);
            }
            return new PatternOrValue(escapedPath, pattern);
        }

        static PatternOrValue createForValue(String value) {
            if (Utils.isPattern(value)) {
                return new PatternOrValue(value, Pattern.compile(Utils.escapePattern(value)));
            }
            return new PatternOrValue(value, null);
        }

        public boolean equalsOrMatches(String value) {
            if (this.pattern != null) {
                return this.pattern.matcher(value).matches();
            }
            return this.value.equals(value);
        }

        public boolean isPattern() {
            return this.pattern != null;
        }

        private static String pathRelativeToRoot(String path) {
            if (path.startsWith("/")) {
                return path.substring(1);
            }
            return path;
        }

        private static String adjustPatternInputRelativeToRoot(Path rootPath, String pathPattern) {
            Object path = rootPath.toString();
            if (!((String)(path = DeploymentFileRuleInspector.toUnixFilePath((String)path))).endsWith("/")) {
                path = (String)path + "/";
            }
            path = (String)path + PatternOrValue.pathRelativeToRoot(pathPattern);
            return path;
        }

        public String getValue() {
            return this.value;
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

