/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;

public class DirectoryIndexer {
    public static Index indexDirectory(File source, Indexer indexer) throws FileNotFoundException, IOException {
        DirectoryIndexer.scanFile(source, indexer);
        return indexer.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanFile(File source, Indexer indexer) throws FileNotFoundException, IOException {
        if (source.isDirectory()) {
            File[] children = source.listFiles();
            if (children == null) {
                throw new FileNotFoundException("Source directory disappeared: " + String.valueOf(source));
            }
            for (File child : children) {
                DirectoryIndexer.scanFile(child, indexer);
            }
            return;
        }
        if (!source.getName().endsWith(".class")) {
            return;
        }
        FileInputStream input = new FileInputStream(source);
        try {
            indexer.indexWithSummary(input);
        }
        catch (Exception e) {
            String message = e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage();
            System.err.println("ERROR: Could not index " + source.getName() + ": " + message);
        }
        finally {
            DirectoryIndexer.safeClose(input);
        }
    }

    private static void safeClose(FileInputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

