/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.cli.commands;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.glow.AddOn;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.Layer;
import org.wildfly.glow.LayerMapping;
import org.wildfly.glow.MetadataProvider;
import org.wildfly.glow.ProvisioningUtils;
import org.wildfly.glow.ScanArguments;
import org.wildfly.glow.Space;
import org.wildfly.glow.WildFlyMavenMetadataProvider;
import org.wildfly.glow.WildFlyMetadataProvider;
import org.wildfly.glow.cli.support.AbstractCommand;
import org.wildfly.glow.cli.support.CLIConfigurationResolver;
import org.wildfly.glow.maven.MavenResolver;
import picocli.CommandLine;

@CommandLine.Command(name="show-add-ons", sortOptions=true)
public class ShowAddOnsCommand
extends AbstractCommand {
    @CommandLine.Option(names={"-c", "--cloud"})
    Optional<Boolean> cloud;
    @CommandLine.Option(names={"-wp", "--wildfly-preview"})
    Optional<Boolean> wildflyPreview;
    @CommandLine.Option(names={"-sv", "--server-version"}, paramLabel="<server version>")
    Optional<String> wildflyServerVersion;
    @CommandLine.Option(names={"--input-feature-packs-file"}, paramLabel="<provisioning file path>")
    Optional<Path> provisioningXml;
    @CommandLine.Option(names={"-cc", "--channels"}, paramLabel="<Channels yaml file path>")
    Optional<Path> channelsFile;
    @CommandLine.Option(names={"-sp", "--spaces"}, split=",", paramLabel="<space1,space2, ...>")
    Set<String> spaces = new LinkedHashSet<String>();
    private Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> defaultSpaceFpDependencies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        Integer n;
        block11: {
            MavenRepoManager repoManager;
            this.print("Wildfly Glow is retrieving add-ons...");
            ScanArguments.Builder builder = Arguments.scanBuilder();
            List<Channel> channels = Collections.emptyList();
            if (this.channelsFile.isPresent()) {
                String content = Files.readString(this.channelsFile.get());
                channels = ChannelMapper.fromString(content);
                builder.setChannels(channels);
                repoManager = MavenResolver.newMavenResolver(channels);
            } else {
                repoManager = MavenResolver.newMavenResolver();
            }
            Path tmpMetadataDirectory = null;
            try {
                MetadataProvider metadataProvider;
                String prop = System.getProperty("wildfly-glow-galleon-feature-packs-url");
                if (prop == null) {
                    tmpMetadataDirectory = Files.createTempDirectory("wildfly-glow-metadata", new FileAttribute[0]);
                    metadataProvider = new WildFlyMavenMetadataProvider(repoManager, tmpMetadataDirectory);
                } else {
                    tmpMetadataDirectory = null;
                    metadataProvider = new WildFlyMetadataProvider(new URI(prop));
                }
                String context = "bare-metal";
                if (this.cloud.orElse(false).booleanValue()) {
                    context = "cloud";
                }
                if (this.wildflyPreview.orElse(false).booleanValue() && this.channelsFile.isPresent()) {
                    throw new Exception("--wildfly-previewcan't be set when --channels is set.");
                }
                if (this.wildflyServerVersion.isPresent() && this.channelsFile.isPresent()) {
                    throw new Exception("--server-versioncan't be set when --channels is set.");
                }
                this.showAddOns(Space.DEFAULT, context, this.provisioningXml.orElse(null), this.wildflyServerVersion.isEmpty(), this.wildflyServerVersion.orElse(null), this.wildflyPreview.orElse(false), channels, repoManager, metadataProvider);
                String vers = this.wildflyServerVersion.isPresent() ? this.wildflyServerVersion.get() : metadataProvider.getLatestVersion();
                for (String spaceName : this.spaces) {
                    Set<String> versions = metadataProvider.getAllVersions(spaceName);
                    if (!versions.contains(vers)) continue;
                    Space space = metadataProvider.getSpace(spaceName);
                    this.showAddOns(space, context, this.provisioningXml.orElse(null), this.wildflyServerVersion.isEmpty(), this.wildflyServerVersion.orElse(null), this.wildflyPreview.orElse(false), channels, repoManager, metadataProvider);
                }
                this.print("@|bold Add-ons can be set using the|@ @|fg(yellow) %s=<list of add-ons>|@ @|bold option of the|@ @|fg(yellow) %s|@ @|bold command|@", "--add-ons", "scan");
                n = 0;
                if (tmpMetadataDirectory == null) break block11;
            }
            catch (Throwable throwable) {
                if (tmpMetadataDirectory != null) {
                    IoUtils.recursiveDelete(tmpMetadataDirectory);
                }
                throw throwable;
            }
            IoUtils.recursiveDelete(tmpMetadataDirectory);
        }
        return n;
    }

    public void showAddOns(Space space, String context, Path provisioningXml, boolean isLatest, String serverVersion, boolean isPreview, List<Channel> channels, MavenRepoManager repoManager, MetadataProvider metadataProvider) throws Exception {
        final CLIConfigurationResolver resolver = new CLIConfigurationResolver();
        ProvisioningUtils.ProvisioningConsumer consumer = new ProvisioningUtils.ProvisioningConsumer(){

            @Override
            public void consume(Space space, GalleonProvisioningConfig provisioning, Map<String, Layer> all, LayerMapping mapping, Map<FeaturePackLocation.FPID, Set<FeaturePackLocation.ProducerSpec>> fpDependencies) throws Exception {
                if (Space.DEFAULT.equals(space)) {
                    ShowAddOnsCommand.this.defaultSpaceFpDependencies = fpDependencies;
                }
                StringBuilder builder = new StringBuilder();
                builder.append("\nAdd-ons found in the ").append(space.getName()).append(" space:\n");
                if (provisioning == null) {
                    builder.append("- No Add-ons.");
                } else {
                    boolean foundAddOns = false;
                    for (Map.Entry<String, Set<AddOn>> entry : mapping.getAddOnFamilyMembers().entrySet()) {
                        StringBuilder addOnFamilyBuilder = new StringBuilder();
                        for (AddOn member : mapping.getAddOnFamilyMembers().get(entry.getKey())) {
                            boolean ignore = false;
                            if (!Space.DEFAULT.equals(space)) {
                                for (Layer l : member.getLayers()) {
                                    for (FeaturePackLocation.FPID fpid : l.getFeaturePacks()) {
                                        for (FeaturePackLocation.FPID dfpid : ShowAddOnsCommand.this.defaultSpaceFpDependencies.keySet()) {
                                            if (!dfpid.getProducer().equals(fpid.getProducer())) continue;
                                            ignore = true;
                                            break;
                                        }
                                        if (!ignore) continue;
                                        break;
                                    }
                                    if (!ignore) continue;
                                    break;
                                }
                            }
                            if (member.getName().endsWith(":default") || ignore) continue;
                            foundAddOns = true;
                            String deployer = resolver.getPossibleDeployer(member.getLayers());
                            addOnFamilyBuilder.append(" - @|bold ").append(member.getName()).append("|@").append((String)(deployer == null ? "" : " (supported by " + deployer + " deployer)")).append((String)(member.getDescription() == null ? "" : ": " + member.getDescription())).append("%n");
                        }
                        if (addOnFamilyBuilder.length() == 0) continue;
                        builder.append("* ").append(entry.getKey()).append(" add-ons:%n");
                        builder.append(addOnFamilyBuilder.toString());
                    }
                    if (!foundAddOns) {
                        builder.append("- No Add-ons.");
                    }
                }
                ShowAddOnsCommand.this.print(builder.toString());
            }
        };
        ProvisioningUtils.traverseProvisioning(space, consumer, context, provisioningXml, isLatest, serverVersion, isPreview, channels, repoManager, metadataProvider);
    }
}

