/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.legacy.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.legacy.util.ResourceType;
import org.wildfly.legacy.util.Tools;

public class CompareModelVersionsUtil {
    private final boolean compareDifferentVersions;
    private final boolean compareRuntime;
    private final String targetVersion;
    private final ModelNode legacyModelVersions;
    private final ModelNode legacyResourceDefinitions;
    private final ModelNode currentModelVersions;
    private final ModelNode currentResourceDefinitions;
    private final Set<String> subsystems;

    private CompareModelVersionsUtil(boolean compareDifferentVersions, boolean compareRuntime, String targetVersion, ModelNode legacyModelVersions, ModelNode legacyResourceDefinitions, ModelNode currentModelVersions, ModelNode currentResourceDefinitions, Set<String> subsystems) throws Exception {
        this.compareDifferentVersions = compareDifferentVersions;
        this.compareRuntime = compareRuntime;
        this.targetVersion = targetVersion;
        this.legacyModelVersions = legacyModelVersions;
        this.legacyResourceDefinitions = legacyResourceDefinitions;
        this.currentModelVersions = currentModelVersions;
        this.currentResourceDefinitions = currentResourceDefinitions;
        this.subsystems = subsystems;
    }

    public static void main(String[] args) throws Exception {
        boolean compareRuntime;
        boolean compareDifferentVersions;
        File fromDirectory;
        ResourceType[] resourceTypes;
        if (CompareModelVersionsUtil.class.getProtectionDomain().getCodeSource().getLocation().toString().endsWith(".jar")) {
            throw new Exception("This currently does not work as a jar. Please import a clone of https://github.com/kabir/wildfly-legacy-test into your IDE");
        }
        String version = System.getProperty("jboss.as.compare.version", null);
        String fromTgt = System.getProperty("jboss.as.compare.from.target", null);
        String differentVersions = System.getProperty("jboss.as.compare.different.versions", null);
        String type = System.getProperty("jboss.as.compare.type", null);
        String runtime = System.getProperty("jboss.as.compare.runtime", null);
        Set<String> subsystems = CompareModelVersionsUtil.parseList(System.getProperty("jboss.as.compare.subsystems", null));
        if (version == null) {
            System.out.print("Enter legacy AS version: ");
            version = CompareModelVersionsUtil.readInput(null);
        }
        System.out.println("Using target model: " + version);
        if (type == null) {
            System.out.print("Enter type [S](standalone)/H(host)/D(domain)/F(domain + host):");
            type = CompareModelVersionsUtil.readInput("S");
        }
        if (ResourceType.STANDALONE.toString().startsWith(type.toUpperCase())) {
            resourceTypes = new ResourceType[]{ResourceType.STANDALONE};
        } else if (ResourceType.HOST.toString().startsWith(type.toUpperCase())) {
            resourceTypes = new ResourceType[]{ResourceType.HOST};
        } else if (ResourceType.DOMAIN.toString().startsWith(type.toUpperCase())) {
            resourceTypes = new ResourceType[]{ResourceType.DOMAIN};
        } else if (type.toUpperCase().equals("F")) {
            resourceTypes = new ResourceType[]{ResourceType.DOMAIN, ResourceType.HOST};
        } else {
            throw new IllegalArgumentException("Could not determine type for: '" + type + "'");
        }
        if (fromTgt == null) {
            System.out.print("Read from target directory or from the legacy-models directory - t/[l]:");
            fromTgt = CompareModelVersionsUtil.readInput("l");
        }
        if (fromTgt.equals("l")) {
            URL legacyModels = Thread.currentThread().getContextClassLoader().getResource("legacy-models");
            fromDirectory = new File(legacyModels.toURI());
        } else if (fromTgt.equals("t")) {
            fromDirectory = new File(Tools.getProjectDirectory(), "target");
        } else {
            throw new IllegalArgumentException("Please enter 'l' for legacy-models directory or 't' for target directory");
        }
        if (differentVersions == null) {
            System.out.print("Report on differences in the model when the management versions are different? y/[n]: ");
            differentVersions = CompareModelVersionsUtil.readInput("n").toLowerCase();
        }
        if (differentVersions.equals("n")) {
            System.out.println("Not reporting on differences in the model when the management versions are different");
            compareDifferentVersions = false;
        } else if (differentVersions.equals("y")) {
            System.out.println("Reporting on differences in the model when the management versions are different");
            compareDifferentVersions = true;
        } else {
            throw new IllegalArgumentException("Please enter 'y' or 'n'");
        }
        if (runtime == null) {
            System.out.print("Report on differences in the model of runtime resources/attributes? y/[n]: ");
            runtime = CompareModelVersionsUtil.readInput("n").toLowerCase();
        }
        if (runtime.equals("n")) {
            System.out.println("Not reporting on differences in the model for runtime resources/attributes.");
            compareRuntime = false;
        } else if (differentVersions.equals("y")) {
            System.out.println("Reporting on differences in the model for runtime resources/attributes.");
            compareRuntime = true;
        } else {
            throw new IllegalArgumentException("Please enter 'y' or 'n'");
        }
        if (subsystems == null) {
            System.out.print("If you only want to report on differences of certain subsystems enter their names as a comma-separated list (e.g. 'ejb3,jmx'): ");
            subsystems = CompareModelVersionsUtil.parseList(CompareModelVersionsUtil.readInput(""));
        }
        System.out.println("Loading legacy model versions for " + version + "....");
        ModelNode legacyModelVersions = Tools.loadModelNodeFromFile(new File(fromDirectory, "standalone-model-versions-" + version + ".dmr"));
        System.out.println("Loaded legacy model versions");
        System.out.println("Loading model versions for currently running server...");
        ModelNode currentModelVersions = Tools.getCurrentModelVersions();
        System.out.println("Loaded current model versions");
        for (ResourceType resourceType : resourceTypes) {
            CompareModelVersionsUtil.doCompare(resourceType, fromDirectory, compareDifferentVersions, compareRuntime, version, legacyModelVersions, currentModelVersions, subsystems);
        }
    }

    private static void doCompare(ResourceType resourceType, File fromDirectory, boolean compareDifferentVersions, boolean compareRuntime, String targetVersion, ModelNode legacyModelVersions, ModelNode currentModelVersions, Set<String> subsystems) throws Exception {
        System.out.println("Loading legacy resource descriptions for " + targetVersion + "....");
        ModelNode legacyResourceDefinitions = Tools.loadModelNodeFromFile(new File(fromDirectory, resourceType.toString().toLowerCase() + "-resource-definition-" + targetVersion + ".dmr"));
        System.out.println("Loaded legacy resource descriptions");
        System.out.println("Loading resource descriptions for currently running " + (Object)((Object)resourceType) + "...");
        ModelNode currentResourceDefinitions = resourceType == ResourceType.STANDALONE ? Tools.getCurrentRunningResourceDefinition(PathAddress.EMPTY_ADDRESS) : (resourceType == ResourceType.DOMAIN ? Tools.getCurrentRunningDomainResourceDefinition() : Tools.getCurrentRunningResourceDefinition(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)"master")})));
        System.out.println("Loaded current resource descriptions");
        CompareModelVersionsUtil compareModelVersionsUtil = new CompareModelVersionsUtil(compareDifferentVersions, compareRuntime, targetVersion, legacyModelVersions, legacyResourceDefinitions, currentModelVersions, currentResourceDefinitions, subsystems);
        System.out.println("Starting comparison of the current....\n");
        compareModelVersionsUtil.compareModels();
        System.out.println("\nDone comparison of " + (Object)((Object)resourceType) + "!");
    }

    private static String readInput(String defaultAnswer) throws IOException {
        StringBuilder sb = new StringBuilder();
        char c = (char)System.in.read();
        while (c != '\n') {
            sb.append(c);
            c = (char)System.in.read();
        }
        String s = sb.toString().trim();
        if (s.equals("")) {
            if (defaultAnswer != null) {
                return defaultAnswer;
            }
            throw new IllegalArgumentException("Please enter a valid answer");
        }
        return s;
    }

    private void compareModels() {
        if (this.subsystems == null) {
            this.compareCoreModels();
        }
        this.compareSubsystemModels();
    }

    private void compareCoreModels() {
        System.out.println("====== Comparing core models ======");
        ResourceDefinition currentDefinition = new ResourceDefinition(this.trimSubsystem(this.currentResourceDefinitions), this.currentModelVersions);
        ResourceDefinition legacyDefinition = new ResourceDefinition(this.trimSubsystem(this.legacyResourceDefinitions), this.legacyModelVersions);
        CompareContext context = new CompareContext(PathAddress.EMPTY_ADDRESS, PathAddress.EMPTY_ADDRESS, true, currentDefinition, legacyDefinition);
        if (!context.continuteWithCheck()) {
            return;
        }
        this.compareModel(context);
    }

    private void compareSubsystemModels() {
        System.out.println("====== Comparing subsystem models ======");
        ResourceDefinition rootCurrentDefinition = new ResourceDefinition(this.trimNonSubsystem(this.currentResourceDefinitions), this.currentModelVersions);
        ResourceDefinition rootLegacyDefinition = new ResourceDefinition(this.trimNonSubsystem(this.legacyResourceDefinitions), this.legacyModelVersions);
        Map<String, ModelNode> currentSubsystems = rootCurrentDefinition.getChildren("subsystem");
        Map<String, ModelNode> legacySubsystems = rootLegacyDefinition.getChildren("subsystem");
        CompareContext context = new CompareContext(PathAddress.EMPTY_ADDRESS, PathAddress.EMPTY_ADDRESS, true, rootCurrentDefinition, rootLegacyDefinition);
        this.compareKeySetsAndRemoveMissing(context, "subsystems", currentSubsystems, legacySubsystems);
        for (Map.Entry<String, ModelNode> legacyEntry : legacySubsystems.entrySet()) {
            ResourceDefinition legacyDefinition;
            ResourceDefinition currentDefinition;
            PathAddress subsystemAddress;
            if (this.subsystems != null && !this.subsystems.contains(legacyEntry.getKey()) || !(context = new CompareContext(subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)legacyEntry.getKey())}), subsystemAddress, false, currentDefinition = new ResourceDefinition(currentSubsystems.get(legacyEntry.getKey()), this.currentModelVersions), legacyDefinition = new ResourceDefinition(legacyEntry.getValue(), this.legacyModelVersions))).continuteWithCheck()) continue;
            this.compareModel(context);
        }
    }

    private ModelNode trimSubsystem(ModelNode definition) {
        ModelNode def = definition.clone();
        def.get("children").remove("subsystem");
        return def;
    }

    private ModelNode trimNonSubsystem(ModelNode definition) {
        ModelNode def = definition.clone();
        for (String key : def.get("children").keys()) {
            if (key.equals("subsystem")) continue;
            def.remove(key);
        }
        return def;
    }

    private void compareModel(CompareContext context) {
        if (!this.compareRuntime && context.getCurrentDefinition().isRuntime() && context.getLegacyDefinition().isRuntime()) {
            return;
        }
        this.compareAttributes(context);
        this.compareOperations(context);
        this.compareChildren(context);
    }

    private void compareAttributes(CompareContext context) {
        Map<String, ModelNode> legacyAttributes = context.getLegacyDefinition().getAttributes();
        Map<String, ModelNode> currentAttributes = context.getCurrentDefinition().getAttributes();
        this.compareKeySetsAndRemoveMissing(context, "attributes", currentAttributes, legacyAttributes);
        for (Map.Entry<String, ModelNode> legacyEntry : legacyAttributes.entrySet()) {
            ModelNode legacyAttribute = legacyEntry.getValue();
            ModelNode currentAttribute = currentAttributes.get(legacyEntry.getKey());
            String id = "attribute '" + legacyEntry.getKey() + "'";
            this.compareAttributeOrOperationParameter(context, id, currentAttribute, legacyAttribute);
            this.compareAccessType(context, id, currentAttribute, legacyAttribute);
            this.compareStorage(context, id, currentAttribute, legacyAttribute);
            this.compareDefault(context, id, currentAttribute, legacyAttribute);
            this.compareUnit(context, id, currentAttribute, legacyAttribute);
        }
    }

    private void compareOperations(CompareContext context) {
        Map<String, ModelNode> legacyOperations = context.getLegacyDefinition().getOperations();
        Map<String, ModelNode> currentOperations = context.getCurrentDefinition().getOperations();
        this.compareKeySetsAndRemoveMissing(context, "operations", currentOperations, legacyOperations);
        for (Map.Entry<String, ModelNode> legacyOpEntry : legacyOperations.entrySet()) {
            String operationName = legacyOpEntry.getKey();
            ModelNode legacyOperation = legacyOpEntry.getValue();
            ModelNode currentOperation = currentOperations.get(operationName);
            Map<String, ModelNode> legacyParameters = context.getLegacyDefinition().getOperationParameters(operationName);
            Map<String, ModelNode> currentParameters = context.getCurrentDefinition().getOperationParameters(operationName);
            this.compareKeySetsAndRemoveMissing(context, "parameters for operation '" + operationName + "'", currentParameters, legacyParameters);
            for (Map.Entry<String, ModelNode> legacyParamEntry : legacyParameters.entrySet()) {
                ModelNode legacyParameter = legacyParamEntry.getValue();
                ModelNode currentParameter = currentParameters.get(legacyParamEntry.getKey());
                String id = "parameter '" + legacyParamEntry.getKey() + "' of operation '" + operationName + "'";
                this.compareAttributeOrOperationParameter(context, id, currentParameter, legacyParameter);
            }
            ModelNode legacyReply = legacyOperation.get("reply-properties");
            ModelNode currentReply = currentOperation.get("reply-properties");
            this.compareAttributeOrOperationParameter(context, "'reply-properties' for operation '" + operationName + "'", currentReply, legacyReply);
        }
    }

    private void compareAttributeOrOperationParameter(CompareContext context, String id, ModelNode current, ModelNode legacy) {
        this.compareType(context, id, current, legacy);
        this.compareValueType(context, id, current, legacy);
        this.compareNillable(context, id, current, legacy);
        this.compareExpressionsAllowed(context, id, current, legacy);
        this.compareAlternatives(context, id, current, legacy);
        this.compareDeprecated(context, id, current, legacy);
    }

    private void compareType(CompareContext context, String id, ModelNode current, ModelNode legacy) {
        if (!current.get("type").equals(legacy.get("type"))) {
            context.println("Different 'type' for " + id + ". Current: " + current.get("type") + "; legacy: " + legacy.get("type"));
        }
    }

    private void compareValueType(CompareContext context, String id, ModelNode current, ModelNode legacy) {
        ModelNode currentValueType = current.get("value-type");
        ModelNode legacyValueType = legacy.get("value-type");
        if (!currentValueType.isDefined() && !legacyValueType.isDefined()) {
            return;
        }
        if (this.isType(legacyValueType) || this.isType(currentValueType)) {
            if (!currentValueType.equals(legacyValueType)) {
                context.println("Different 'value-type' for " + id + ". Current: " + current.get("value-type") + "; legacy: " + legacy.get("value-type"));
            }
        } else {
            Map<String, ModelNode> legacyValueTypes = this.createMapIndexedByKey(legacyValueType);
            Map<String, ModelNode> currentValueTypes = this.createMapIndexedByKey(currentValueType);
            this.compareKeySetsAndRemoveMissing(context, "value-type for " + id, currentValueTypes, legacyValueTypes);
            for (Map.Entry<String, ModelNode> entry : currentValueTypes.entrySet()) {
                ModelNode currentEntry = entry.getValue();
                ModelNode legacyEntry = legacyValueTypes.get(entry.getKey());
                this.compareAttributeOrOperationParameter(context, "value-type key '" + entry.getKey() + "' for " + id, currentEntry, legacyEntry);
            }
        }
    }

    private void compareNillable(CompareContext context, String id, ModelNode current, ModelNode legacy) {
        boolean legacyNillable;
        boolean currentNillable = current.get("nillable").asBoolean(false);
        if (currentNillable != (legacyNillable = legacy.get("nillable").asBoolean(false))) {
            context.println("Different 'nillable' for " + id + ". Current: " + currentNillable + "; legacy: " + legacyNillable);
        }
    }

    private void compareExpressionsAllowed(CompareContext context, String id, ModelNode current, ModelNode legacy) {
        boolean legacyNillable;
        boolean currentNillable = current.get("expressions-allowed").asBoolean(false);
        if (currentNillable != (legacyNillable = legacy.get("expressions-allowed").asBoolean(false))) {
            context.println("Different 'expressions-allowed' for " + id + ". Current: " + currentNillable + "; legacy: " + legacyNillable);
        }
    }

    private void compareAccessType(CompareContext context, String id, ModelNode current, ModelNode legacy) {
        if (!current.get("access-type").equals(legacy.get("access-type"))) {
            context.println("Different 'access-type' for " + id + ". Current: " + current.get("access-type") + "; legacy: " + legacy.get("access-type"));
        }
    }

    private void compareStorage(CompareContext context, String id, ModelNode current, ModelNode legacy) {
        if (!current.get("storage").equals(legacy.get("storage"))) {
            context.println("Different 'storage' for " + id + ". Current: " + current.get("storage") + "; legacy: " + legacy.get("storage"));
        }
    }

    private void compareDefault(CompareContext context, String id, ModelNode current, ModelNode legacy) {
        if (!current.get("default").equals(legacy.get("default"))) {
            context.println("Different 'default' for " + id + ". Current: " + current.get("default") + "; legacy: " + legacy.get("default"));
        }
    }

    private void compareDeprecated(CompareContext context, String id, ModelNode current, ModelNode legacy) {
        if (!current.get("deprecated").equals(legacy.get("deprecated"))) {
            context.println("Different 'deprecated' for " + id + ". Current: " + current.get("deprecated") + "; legacy: " + legacy.get("deprecated"));
        }
    }

    private void compareUnit(CompareContext context, String id, ModelNode current, ModelNode legacy) {
        if (!current.get("unit").equals(legacy.get("unit"))) {
            context.println("Different 'unit' for " + id + ". Current: " + current.get("unit") + "; legacy: " + legacy.get("unit"));
        }
    }

    private boolean isType(ModelNode node) {
        if (!node.isDefined()) {
            return false;
        }
        try {
            node.asType();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Map<String, ModelNode> createMapIndexedByKey(ModelNode node) {
        HashMap<String, ModelNode> map = new HashMap<String, ModelNode>();
        if (!node.isDefined()) {
            return map;
        }
        for (Property prop : node.asPropertyList()) {
            map.put(prop.getName(), prop.getValue());
        }
        return map;
    }

    private void compareAlternatives(CompareContext context, String id, ModelNode current, ModelNode legacy) {
        if (!current.get("alternatives").equals(legacy.get("alternatives"))) {
            context.println("Different 'alternatives' for " + id + ". Current: " + current.get("alternatives") + "; legacy: " + legacy.get("alternatives"));
        }
    }

    private void compareChildren(CompareContext context) {
        Set<String> legacyChildTypes = context.getLegacyDefinition().getChildTypes();
        Set<String> currentChildTypes = context.getCurrentDefinition().getChildTypes();
        this.compareSetsAndRemoveMissing(context, "child types", currentChildTypes, legacyChildTypes);
        for (String type : legacyChildTypes) {
            Map<String, ModelNode> legacyChildren = context.getLegacyDefinition().getChildren(type);
            Map<String, ModelNode> currentChildren = context.getCurrentDefinition().getChildren(type);
            this.compareKeySetsAndRemoveMissing(context, "child names for type=" + type, currentChildren, legacyChildren);
            for (Map.Entry<String, ModelNode> legacyChildEntry : legacyChildren.entrySet()) {
                CompareContext childContext;
                String name = legacyChildEntry.getKey();
                ModelNode legacyChildDescription = legacyChildEntry.getValue();
                ModelNode currentChildDescription = currentChildren.get(name);
                try {
                    childContext = new CompareContext(context.getRootAddress(), context.getPathAddress().append(new PathElement[]{PathElement.pathElement((String)type, (String)name)}), context.isCore(), new ResourceDefinition(currentChildDescription, this.currentModelVersions), new ResourceDefinition(legacyChildDescription, this.legacyModelVersions));
                }
                catch (RuntimeException e) {
                    System.out.println(context.getPathAddress() + " + " + type + "=" + name);
                    throw e;
                }
                this.compareModel(childContext);
            }
        }
    }

    private void compareKeySetsAndRemoveMissing(CompareContext context, String type, Map<String, ModelNode> currentMap, Map<String, ModelNode> legacyMap) {
        this.compareSetsAndRemoveMissing(context, type, currentMap.keySet(), legacyMap.keySet());
    }

    private void compareSetsAndRemoveMissing(CompareContext context, String type, Set<String> currentSet, Set<String> legacySet) {
        Set<String> extraInLegacy = this.getMissingNames(context, legacySet, currentSet);
        Set<String> extraInCurrent = this.getMissingNames(context, currentSet, legacySet);
        Set<String> extraInLegacyAfterRuntime = new HashSet<String>(extraInLegacy);
        Set<String> extraInCurrentAfterRuntime = new HashSet<String>(extraInCurrent);
        if ((extraInLegacy.size() > 0 || extraInCurrent.size() > 0) && !this.compareRuntime && type.equals("attributes")) {
            extraInLegacyAfterRuntime = this.trimRuntimeAttributes(context.getLegacyDefinition().getAttributes(), extraInLegacyAfterRuntime);
            extraInCurrentAfterRuntime = this.trimRuntimeAttributes(context.getCurrentDefinition().getAttributes(), extraInCurrentAfterRuntime);
        }
        if (extraInLegacyAfterRuntime.size() > 0 || extraInCurrentAfterRuntime.size() > 0) {
            context.println("Missing " + type + " in current: " + extraInLegacyAfterRuntime + "; missing in legacy " + extraInCurrentAfterRuntime);
        }
        if (extraInCurrent.size() > 0) {
            currentSet.removeAll(extraInCurrent);
        }
        if (extraInLegacy.size() > 0) {
            legacySet.removeAll(extraInLegacy);
        }
    }

    private Set<String> trimRuntimeAttributes(Map<String, ModelNode> attributes, Set<String> set) {
        HashSet<String> runtime = new HashSet<String>(set);
        for (String name : set) {
            ModelNode desc = attributes.get(name);
            if (!desc.hasDefined("storage") || !desc.get("storage").asString().equals(AttributeAccess.Storage.RUNTIME.toString())) continue;
            runtime.remove(name);
        }
        return runtime;
    }

    private Set<String> getMissingNames(CompareContext context, Set<String> possiblyMissing, Set<String> names) {
        HashSet<String> missing = new HashSet<String>(possiblyMissing);
        for (String name : names) {
            missing.remove(name);
        }
        if (context.isVersionLevel() && missing.contains("management-micro-version") && names.contains("management-major-version") && names.contains("management-minor-version")) {
            missing.remove("management-micro-version");
        }
        return missing;
    }

    private static Set<String> parseList(String s) {
        if (s == null) {
            return null;
        }
        String[] elements = s.trim().split(",");
        HashSet<String> set = null;
        for (String element : elements) {
            if ((element = element.trim()).length() <= 0) continue;
            if (set == null) {
                set = new HashSet<String>();
            }
            set.add(element.trim());
        }
        return set;
    }

    private static class ResourceDefinition {
        final ModelNode description;
        final ModelNode versions;

        ResourceDefinition(ModelNode description, ModelNode versions) {
            this.description = description;
            this.versions = versions;
        }

        Map<String, ModelNode> getAttributes() {
            return this.getSortedEntryMap(this.description, "attributes");
        }

        Map<String, ModelNode> getOperations() {
            return this.getSortedEntryMap(this.description, "operations");
        }

        Set<String> getChildTypes() {
            return this.getSortedEntryMap(this.description, "children").keySet();
        }

        Map<String, ModelNode> getChildren(String type) {
            return this.getSortedEntryMap(this.description.get(new String[]{"children", type}), "model-description");
        }

        Map<String, ModelNode> getOperationParameters(String opName) {
            return this.getSortedEntryMap(this.description.get(new String[]{"operations", opName}), "request-properties");
        }

        private Map<String, ModelNode> getSortedEntryMap(ModelNode parent, String name) {
            if (!parent.hasDefined(name)) {
                return Collections.emptyMap();
            }
            TreeMap<String, ModelNode> sorted = new TreeMap<String, ModelNode>();
            for (Property prop : parent.get(name).asPropertyList()) {
                sorted.put(prop.getName(), prop.getValue());
            }
            return sorted;
        }

        private ModelVersion getCoreModelVersion() {
            return Tools.createModelVersion(this.versions.get(new String[]{"core", "standalone"}));
        }

        private ModelVersion getSubsystemVersion(PathAddress address) {
            for (PathElement element : address) {
                if (!element.getKey().equals("subsystem")) continue;
                return Tools.createModelVersion(this.versions.get(new String[]{"subsystem", element.getValue()}));
            }
            throw new IllegalArgumentException("Could not find subsystem version for " + address);
        }

        boolean isRuntime() {
            if (this.description.hasDefined("storage")) {
                return this.description.get("storage").equals((Object)"runtime");
            }
            return false;
        }
    }

    private class CompareContext {
        final PathAddress rootAddress;
        final PathAddress pathAddress;
        final boolean core;
        final ResourceDefinition legacyDefinition;
        final ResourceDefinition currentDefinition;
        boolean outputPath;

        CompareContext(PathAddress rootAddress, PathAddress pathAddress, boolean core, ResourceDefinition currentDefinition, ResourceDefinition legacyDefinition) {
            this.rootAddress = rootAddress;
            this.pathAddress = pathAddress;
            this.core = core;
            this.currentDefinition = currentDefinition;
            this.legacyDefinition = legacyDefinition;
        }

        PathAddress getRootAddress() {
            return this.rootAddress;
        }

        PathAddress getPathAddress() {
            return this.pathAddress;
        }

        boolean isVersionLevel() {
            return this.rootAddress.equals(this.pathAddress);
        }

        boolean isCore() {
            return this.core;
        }

        ResourceDefinition getLegacyDefinition() {
            return this.legacyDefinition;
        }

        ResourceDefinition getCurrentDefinition() {
            return this.currentDefinition;
        }

        boolean continuteWithCheck() {
            if (!this.isVersionLevel()) {
                return true;
            }
            ModelVersion currentVersion = this.getModelVersion(this.currentDefinition);
            ModelVersion legacyVersion = this.getModelVersion(this.legacyDefinition);
            System.out.println("====== Resource root address: " + this.formatAddressOneLine(this.pathAddress) + " - Current version: " + currentVersion + "; legacy version: " + legacyVersion + " =======");
            if (!legacyVersion.equals((Object)currentVersion) && CompareModelVersionsUtil.this.compareDifferentVersions) {
                return true;
            }
            if (legacyVersion.equals((Object)currentVersion)) {
                return true;
            }
            System.out.println("Skipping check of resource and children");
            return false;
        }

        private ModelVersion getModelVersion(ResourceDefinition definition) {
            if (this.core) {
                return definition.getCoreModelVersion();
            }
            return definition.getSubsystemVersion(this.pathAddress);
        }

        private String formatAddressOneLine(PathAddress addr) {
            StringBuilder sb = new StringBuilder("[");
            boolean first = true;
            for (PathElement element : addr) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(element);
            }
            sb.append("]");
            return sb.toString();
        }

        void println(String msg) {
            if (!this.outputPath) {
                this.outputPath = true;
                PathAddress relative = this.pathAddress.subAddress(this.rootAddress.size());
                System.out.println("--- Problems for relative address to root " + this.formatAddressOneLine(relative) + ":");
            }
            System.out.println(msg);
        }
    }
}

