/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.legacy.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.wildfly.legacy.util.CompareModelVersionsUtil;
import org.xnio.IoUtils;

public class Tools {
    static final String CORE = "core";
    static final String STANDALONE = "standalone";
    static final String VERSION = "version";

    static ModelNode getAndCheckResult(ModelNode result) {
        if (!result.get("outcome").asString().equals("success")) {
            throw new RuntimeException(result.get("failure-description").toString());
        }
        return result.get("result");
    }

    static ModelVersion createModelVersion(ModelNode node) {
        return ModelVersion.create((int)Tools.readVersion(node, "management-major-version"), (int)Tools.readVersion(node, "management-minor-version"), (int)Tools.readVersion(node, "management-micro-version"));
    }

    static ModelNode readModelVersionFields(ModelNode node) {
        ModelNode version = new ModelNode();
        if (node.hasDefined("management-major-version")) {
            version.get("management-major-version").set(node.get("management-major-version"));
        }
        if (node.hasDefined("management-minor-version")) {
            version.get("management-minor-version").set(node.get("management-minor-version"));
        }
        if (node.hasDefined("management-micro-version")) {
            version.get("management-micro-version").set(node.get("management-micro-version"));
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModelNode getCurrentModelVersions() throws Exception {
        ModelControllerClient client = Tools.getClient();
        try {
            ModelNode allVersions = new ModelNode();
            ModelNode op = new ModelNode();
            op.get("operation").set("read-resource");
            op.get("address").setEmptyList();
            ModelNode result = Tools.getAndCheckResult(client.execute(op));
            allVersions.get(new String[]{CORE, STANDALONE}).set(Tools.readModelVersionFields(result));
            op.get("address").add("extension", "*").add("subsystem", "*");
            result = Tools.getAndCheckResult(client.execute(op));
            TreeMap<String, ModelNode> map = new TreeMap<String, ModelNode>();
            List subsystemResults = result.asList();
            for (ModelNode modelNode : subsystemResults) {
                String subsystemName = PathAddress.pathAddress((ModelNode)modelNode.get("address")).getLastElement().getValue();
                map.put(subsystemName, Tools.getAndCheckResult(modelNode));
            }
            for (Map.Entry entry : map.entrySet()) {
                allVersions.get(new String[]{"subsystem", (String)entry.getKey()}).set(Tools.readModelVersionFields((ModelNode)entry.getValue()));
                allVersions.get(new String[]{"subsystem", (String)entry.getKey()}).get("xml-namespaces").set(((ModelNode)entry.getValue()).get("xml-namespaces"));
            }
            Iterator<Object> iterator = allVersions;
            return iterator;
        }
        finally {
            IoUtils.safeClose((Closeable)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModelNode getCurrentRunningResourceDefinition(PathAddress pathAddress) throws Exception {
        ModelControllerClient client = Tools.getClient();
        try {
            ModelNode op = new ModelNode();
            op.get("operation").set("read-resource-description");
            op.get("address").set(pathAddress.toModelNode());
            op.get("recursive").set(true);
            op.get("operations").set(true);
            op.get("proxies").set(false);
            op.get("inherited").set(false);
            ModelNode modelNode = Tools.getAndCheckResult(client.execute(op));
            return modelNode;
        }
        finally {
            IoUtils.safeClose((Closeable)client);
        }
    }

    static ModelNode getCurrentRunningDomainResourceDefinition() throws Exception {
        ModelNode node = Tools.getCurrentRunningResourceDefinition(PathAddress.EMPTY_ADDRESS);
        ModelNode profile = node.get("children").require("profile").require("model-description").require("*");
        node.get("children").require("host");
        node.require("children").remove("host");
        profile.get("children").setEmptyList();
        return node;
    }

    static int readVersion(ModelNode node, String name) {
        if (!node.hasDefined(name)) {
            return 0;
        }
        return node.get(name).asInt();
    }

    static void serializeModeNodeToFile(ModelNode modelNode, File file) throws Exception {
        if (file.exists()) {
            file.delete();
        }
        PrintWriter writer = new PrintWriter(file);
        try {
            modelNode.writeString(writer, false);
            System.out.println("Resource definition for running server written to: " + file.getAbsolutePath());
        }
        finally {
            IoUtils.safeClose((Closeable)writer);
        }
    }

    static File getProjectDirectory() throws URISyntaxException {
        return new File(CompareModelVersionsUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getParentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModelNode loadModelNodeFromFile(File file) throws Exception {
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist " + file);
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line = reader.readLine();
            while (line != null) {
                sb.append(line);
                line = reader.readLine();
            }
        }
        finally {
            IoUtils.safeClose((Closeable)reader);
        }
        new ModelNode();
        return ModelNode.fromString((String)sb.toString());
    }

    private static ModelControllerClient getClient() throws UnknownHostException {
        String protocol = System.getProperty("wildfly.util.protocol");
        int port = Integer.valueOf(System.getProperty("wildfly.util.port", "-1"));
        if (protocol != null || port >= 0) {
            if (protocol != null && port >= 0) {
                return ModelControllerClient.Factory.create((String)protocol, (String)"localhost", (int)port);
            }
            if (protocol != null) {
                if (protocol.equals("remote")) {
                    port = 9999;
                } else if (protocol.equals("http-remoting")) {
                    port = 9990;
                }
                return ModelControllerClient.Factory.create((String)protocol, (String)"localhost", (int)port);
            }
            throw new IllegalStateException("port specified without protocol");
        }
        ModelControllerClient client = ModelControllerClient.Factory.create((String)"http-remoting", (String)"localhost", (int)9990);
        try {
            client.execute(Util.createEmptyOperation((String)"read-resource", (PathAddress)PathAddress.EMPTY_ADDRESS));
            return client;
        }
        catch (Exception e) {
            IoUtils.safeClose((Closeable)client);
            client = ModelControllerClient.Factory.create((String)"remote", (String)"localhost", (int)9999);
            try {
                client.execute(Util.createEmptyOperation((String)"read-resource", (PathAddress)PathAddress.EMPTY_ADDRESS));
                return client;
            }
            catch (Exception e2) {
                IoUtils.safeClose((Closeable)client);
                throw new IllegalStateException("Could not figure out how to connect to the host. Please use -Dwildfly.util.protocol and wildfly.util.port to specify where to connect");
            }
        }
    }
}

