/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mcp;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.mcp.WildFlyManagementClient;

public class WildFlyStatus {
    private static final String RUNNING = "running";
    private static final String NORMAL = "NORMAL";
    private static final String SUCCESS = "success";
    private static final String OK = "OK";
    private final String serverState;
    private final String runningMode;
    private final List<Object> bootErrors;
    private final List<WildFlyManagementClient.Deployment> deploymentsStatus;

    WildFlyStatus(String serverState, String runningMode, List<Object> bootErrors, List<WildFlyManagementClient.Deployment> deploymentsStatus) {
        this.serverState = serverState;
        this.runningMode = runningMode;
        this.bootErrors = bootErrors;
        this.deploymentsStatus = deploymentsStatus;
    }

    public boolean isOk() {
        return this.serverState.equals(RUNNING) && this.runningMode.equals(NORMAL) && this.bootErrors.isEmpty() && this.allDeploymentsOK();
    }

    private boolean allDeploymentsOK() {
        for (WildFlyManagementClient.Deployment d : this.deploymentsStatus) {
            if (d.outcome.equals(SUCCESS) && d.result.equals(OK)) continue;
            return false;
        }
        return true;
    }

    public List<String> getStatus() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("Server state: " + this.serverState);
        res.add("Running Mode: " + this.runningMode);
        res.add("Boot errors: " + String.valueOf(this.bootErrors));
        res.add("Deployments: " + String.valueOf(this.deploymentsStatus));
        return res;
    }
}

