/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.subsystem.cassandra;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.nosql.subsystem.cassandra.CassandraDriverDefinition;
import org.wildfly.extension.nosql.subsystem.cassandra.CassandraSubsystemService;
import org.wildfly.nosql.common.DriverDependencyProcessor;
import org.wildfly.nosql.common.DriverScanDependencyProcessor;

public class CassandraDriverSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final CassandraDriverSubsystemAdd INSTANCE = new CassandraDriverSubsystemAdd();
    private final ParametersValidator runtimeValidator = new ParametersValidator();

    private CassandraDriverSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition def : CassandraDriverDefinition.INSTANCE.getAttributes()) {
            def.validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.runtimeValidator.validate(operation.resolve());
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                int PARSE_CASSANDRA_DRIVER = 19458;
                int DEPENDENCIES_CASSANDRA_DRIVER = 7954;
                processorTarget.addDeploymentProcessor("cassandradriver", Phase.PARSE, 19458, (DeploymentUnitProcessor)new DriverScanDependencyProcessor("cassandrasubsystem"));
                processorTarget.addDeploymentProcessor("cassandradriver", Phase.DEPENDENCIES, 7954, (DeploymentUnitProcessor)DriverDependencyProcessor.getInstance());
            }
        }, OperationContext.Stage.RUNTIME);
        this.startCassandraDriverSubsysteService(context);
    }

    private void startCassandraDriverSubsysteService(OperationContext context) {
        CassandraSubsystemService cassandraSubsystemService = new CassandraSubsystemService();
        context.getServiceTarget().addService(CassandraSubsystemService.serviceName(), (Service)cassandraSubsystemService).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

