/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.driver.mongodb;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.security.SubjectFactory;
import org.wildfly.extension.nosql.driver.mongodb.AuthType;
import org.wildfly.extension.nosql.driver.mongodb.ConfigurationBuilder;
import org.wildfly.nosql.common.MethodHandleBuilder;
import org.wildfly.nosql.common.NoSQLConstants;
import org.wildfly.nosql.common.NoSQLLogger;

public class MongoInteraction {
    private final ArrayList serverAddressArrayList = new ArrayList();
    private final ConfigurationBuilder configurationBuilder;
    private Object clientInstance;
    private final Class mongoClientClass;
    private final Class mongoDatabaseClass;
    private final MethodHandle closeMethod;
    private final MethodHandle getDatabaseMethod;
    private final MethodHandle mongoClientCtorMethod;
    private final MethodHandle mongoClientSecurityCtorMethod;
    private final MethodHandle builderCtorMethod;
    private final MethodHandle descriptionMethod;
    private final MethodHandle writeConcernMethod;
    private final MethodHandle readConcernMethod;
    private final MethodHandle sslEnabledMethod;
    private final MethodHandle replicaSetMethod;
    private final MethodHandle buildMethod;
    private final MethodHandle writeConcernValueOfMethod;
    private final MethodHandle readConcernCtorMethod;
    private final MethodHandle readConcernLevelFromStringMethod;
    private final MethodHandle serverAddressHostCtor;
    private final MethodHandle serverAddressHostPortCtor;
    private final Class mongoCredentialClass;
    private final MethodHandle mongoCredentialCreateCredential;
    private final MethodHandle mongoCredentialGSSAPICreateCredential;
    private final MethodHandle mongoCredentialMongoCRCreateCredential;
    private final MethodHandle mongoCredentialX509CreateCredential;
    private final MethodHandle mongoCredentialPlainCreateCredential;
    private final MethodHandle mongoCredentialScramSha1CreateCredential;
    private volatile SubjectFactory subjectFactory;

    public MongoInteraction(ConfigurationBuilder configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
        MethodHandleBuilder methodHandleBuilder = new MethodHandleBuilder();
        methodHandleBuilder.classLoader(ModuleIdentifier.fromString((String)configurationBuilder.getModuleName()));
        Class mongoClientOptionsClass = methodHandleBuilder.className("com.mongodb.MongoClientOptions").getTargetClass();
        this.mongoClientClass = methodHandleBuilder.className(NoSQLConstants.MONGOCLIENTCLASS).getTargetClass();
        this.closeMethod = methodHandleBuilder.method("close", new Class[0]);
        this.getDatabaseMethod = methodHandleBuilder.declaredMethod("getDatabase", new Class[]{String.class});
        this.mongoClientCtorMethod = methodHandleBuilder.declaredConstructor(new Class[]{List.class, mongoClientOptionsClass});
        this.mongoClientSecurityCtorMethod = methodHandleBuilder.declaredConstructor(new Class[]{List.class, List.class, mongoClientOptionsClass});
        Class mongoWriteConcernClass = methodHandleBuilder.className("com.mongodb.WriteConcern").getTargetClass();
        this.writeConcernValueOfMethod = methodHandleBuilder.method("valueOf", new Class[]{String.class});
        Class mongoReadConcernLevelClass = methodHandleBuilder.className("com.mongodb.ReadConcernLevel").getTargetClass();
        this.readConcernLevelFromStringMethod = methodHandleBuilder.method("fromString", new Class[]{String.class});
        Class mongoReadConcernClass = methodHandleBuilder.className("com.mongodb.ReadConcern").getTargetClass();
        this.readConcernCtorMethod = methodHandleBuilder.declaredConstructor(new Class[]{mongoReadConcernLevelClass});
        methodHandleBuilder.className("com.mongodb.MongoClientOptions$Builder");
        this.builderCtorMethod = methodHandleBuilder.constructor(MethodType.methodType(Void.TYPE));
        this.descriptionMethod = methodHandleBuilder.declaredMethod("description", new Class[]{String.class});
        this.writeConcernMethod = methodHandleBuilder.method("writeConcern", new Class[]{mongoWriteConcernClass});
        this.readConcernMethod = methodHandleBuilder.method("readConcern", new Class[]{mongoReadConcernClass});
        this.sslEnabledMethod = methodHandleBuilder.method("sslEnabled", new Class[]{Boolean.TYPE});
        this.replicaSetMethod = methodHandleBuilder.method("requiredReplicaSetName", new Class[]{String.class});
        this.buildMethod = methodHandleBuilder.method("build", new Class[0]);
        methodHandleBuilder.className("com.mongodb.ServerAddress");
        this.serverAddressHostCtor = methodHandleBuilder.constructor(MethodType.methodType(Void.TYPE, String.class));
        this.serverAddressHostPortCtor = methodHandleBuilder.constructor(MethodType.methodType(Void.TYPE, String.class, Integer.TYPE));
        this.mongoDatabaseClass = methodHandleBuilder.className("com.mongodb.client.MongoDatabase").getTargetClass();
        this.mongoCredentialClass = methodHandleBuilder.className("com.mongodb.MongoCredential").getTargetClass();
        this.mongoCredentialCreateCredential = methodHandleBuilder.staticMethod("createCredential", MethodType.methodType(this.mongoCredentialClass, String.class, String.class, char[].class));
        this.mongoCredentialGSSAPICreateCredential = methodHandleBuilder.staticMethod("createGSSAPICredential", MethodType.methodType(this.mongoCredentialClass, String.class));
        this.mongoCredentialMongoCRCreateCredential = methodHandleBuilder.staticMethod("createMongoCRCredential", MethodType.methodType(this.mongoCredentialClass, String.class, String.class, char[].class));
        this.mongoCredentialX509CreateCredential = methodHandleBuilder.staticMethod("createMongoX509Credential", MethodType.methodType(this.mongoCredentialClass, String.class));
        this.mongoCredentialPlainCreateCredential = methodHandleBuilder.staticMethod("createPlainCredential", MethodType.methodType(this.mongoCredentialClass, String.class, String.class, char[].class));
        this.mongoCredentialScramSha1CreateCredential = methodHandleBuilder.staticMethod("createScramSha1Credential", MethodType.methodType(this.mongoCredentialClass, String.class, String.class, char[].class));
    }

    public void hostPort(String host, int port) throws Throwable {
        if (port > 0) {
            this.serverAddressArrayList.add(this.serverAddressHostPortCtor.invoke(host, port));
        } else {
            this.serverAddressArrayList.add(this.serverAddressHostCtor.invoke(host));
        }
    }

    public Object mongoClient() throws Throwable {
        return this.mongoClient(this.serverAddressArrayList, this.mongoClientOptions(), this.mongoCredential());
    }

    public Object getDB() throws Throwable {
        return this.getDatabase(this.configurationBuilder.getDatabase());
    }

    public void close() throws Throwable {
        this.underlyingClose();
    }

    public Object mongoClientOptions() throws Throwable {
        Object builder = this.builderCtorMethod.invoke();
        this.descriptionMethod.invoke(builder, this.configurationBuilder.getDescription());
        String writeConcernName = this.configurationBuilder.getWriteConcern();
        if (writeConcernName != null) {
            Object writeConcernValue = this.writeConcernValueOfMethod.invoke(writeConcernName);
            this.writeConcernMethod.invoke(builder, writeConcernValue);
        }
        if (this.configurationBuilder.getReadConcern() != null) {
            Object readConcernLevelValue = this.readConcernLevelFromStringMethod.invoke(this.configurationBuilder.getReadConcern());
            Object readConcernValue = this.readConcernCtorMethod.invoke(readConcernLevelValue);
            this.readConcernMethod.invoke(builder, readConcernValue);
        }
        if (this.configurationBuilder.isSSL()) {
            this.sslEnabledMethod.invoke(builder, true);
        }
        if (this.configurationBuilder.getReplicaSet() != null) {
            this.replicaSetMethod.invoke(builder, this.configurationBuilder.getReplicaSet());
        }
        Object mongoClientOptions = this.buildMethod.invoke(builder);
        return mongoClientOptions;
    }

    public List mongoCredential() throws Throwable {
        if (this.configurationBuilder.getSecurityDomain() != null && this.subjectFactory != null) {
            String database = this.configurationBuilder.getAdminDatabase() != null ? this.configurationBuilder.getAdminDatabase() : this.configurationBuilder.getDatabase();
            try {
                Subject subject = this.subjectFactory.createSubject(this.configurationBuilder.getSecurityDomain());
                Set<PasswordCredential> passwordCredentials = subject.getPrivateCredentials(PasswordCredential.class);
                PasswordCredential passwordCredential = passwordCredentials.iterator().next();
                ArrayList<Object> resultList = new ArrayList<Object>();
                if (this.configurationBuilder.getAuthType() == null || AuthType.DEFAULT.equals((Object)this.configurationBuilder.getAuthType())) {
                    resultList.add(this.mongoCredentialCreateCredential.invoke(passwordCredential.getUserName(), database, passwordCredential.getPassword()));
                    return resultList;
                }
                if (AuthType.GSSAPI.equals((Object)this.configurationBuilder.getAuthType())) {
                    resultList.add(this.mongoCredentialGSSAPICreateCredential.invoke(passwordCredential.getUserName()));
                    return resultList;
                }
                if (AuthType.MONGODB_CR.equals((Object)this.configurationBuilder.getAuthType())) {
                    resultList.add(this.mongoCredentialMongoCRCreateCredential.invoke(passwordCredential.getUserName(), database, passwordCredential.getPassword()));
                    return resultList;
                }
                if (AuthType.MONGODB_X509.equals((Object)this.configurationBuilder.getAuthType())) {
                    resultList.add(this.mongoCredentialX509CreateCredential.invoke(passwordCredential.getUserName()));
                    return resultList;
                }
                if (AuthType.PLAIN_SASL.equals((Object)this.configurationBuilder.getAuthType())) {
                    resultList.add(this.mongoCredentialPlainCreateCredential.invoke(passwordCredential.getUserName(), database, passwordCredential.getPassword()));
                    return resultList;
                }
                if (AuthType.SCRAM_SHA_1.equals((Object)this.configurationBuilder.getAuthType())) {
                    resultList.add(this.mongoCredentialScramSha1CreateCredential.invoke(passwordCredential.getUserName(), database, passwordCredential.getPassword()));
                    return resultList;
                }
                throw new RuntimeException("unhandled auth-type " + this.configurationBuilder.getAuthType().toString());
            }
            catch (Throwable problem) {
                if (NoSQLLogger.ROOT_LOGGER.isTraceEnabled()) {
                    NoSQLLogger.ROOT_LOGGER.tracef(problem, "could not create subject for security domain '%s' with database '%s'", (Object)this.configurationBuilder.getSecurityDomain(), (Object)database);
                }
                throw problem;
            }
        }
        return null;
    }

    public Object mongoClient(Object serverAddressList, Object mongoClientOptions, List mongoCredential) throws Throwable {
        this.clientInstance = mongoCredential != null && mongoCredential.size() > 0 ? this.mongoClientSecurityCtorMethod.invoke(serverAddressList, this.castCollection(mongoCredential, this.mongoCredentialClass), mongoClientOptions) : this.mongoClientCtorMethod.invoke(serverAddressList, mongoClientOptions);
        return this.clientInstance;
    }

    public Object getDatabase(String databaseName) throws Throwable {
        Object result = null;
        if (this.clientInstance != null) {
            result = this.getDatabaseMethod.invoke(this.clientInstance, databaseName);
        }
        return result;
    }

    public void underlyingClose() throws Throwable {
        try {
            if (this.clientInstance != null) {
                this.closeMethod.invoke(this.clientInstance);
            }
        }
        finally {
            this.clientInstance = null;
        }
    }

    public Class getMongoClientClass() {
        return this.mongoClientClass;
    }

    public Class getMongoDatabaseClass() {
        return this.mongoDatabaseClass;
    }

    public void subjectFactory(SubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    private <X> List<X> castCollection(List srcList, Class<X> xClass) {
        ArrayList<X> arrayList = new ArrayList<X>();
        for (Object srcObject : srcList) {
            if (srcObject == null || !xClass.isAssignableFrom(srcObject.getClass())) continue;
            arrayList.add(xClass.cast(srcObject));
        }
        return arrayList;
    }
}

