/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.subsystem.mongodb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.nosql.driver.mongodb.ReadConcernType;
import org.wildfly.extension.nosql.driver.mongodb.WriteConcernType;

class PropertiesValidator
implements ParameterValidator {
    private static final Map<String, List<String>> VALID_PROPERTIES = new HashMap<String, List<String>>();

    PropertiesValidator() {
    }

    public void validateParameter(String parameterName, ModelNode values) throws OperationFailedException {
        for (Property property : values.asPropertyList()) {
            if (!VALID_PROPERTIES.containsKey(property.getName())) {
                throw new OperationFailedException("Invalid property name: " + property.getName());
            }
            if (VALID_PROPERTIES.get(property.getName()).contains(property.getValue().asString().toUpperCase())) continue;
            throw new OperationFailedException("Invalid value of property " + property.getName() + ": " + property.getValue());
        }
    }

    public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
    }

    static {
        VALID_PROPERTIES.put("writeConcern", WriteConcernType.NAMES);
        VALID_PROPERTIES.put("readConcern", ReadConcernType.NAMES);
    }
}

