/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.driver.neo4j.transaction;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.LastResource;
import org.jboss.tm.XAResourceWrapper;
import org.wildfly.extension.nosql.driver.neo4j.transaction.LocalXAException;
import org.wildfly.extension.nosql.driver.neo4j.transaction.TransactionControl;
import org.wildfly.nosql.common.NoSQLLogger;

public class Neo4jXAResourceImpl
implements LastResource,
XAResourceWrapper {
    private static final boolean trace = NoSQLLogger.ROOT_LOGGER.isTraceEnabled();
    private Xid currentXid;
    private String productName;
    private String productVersion;
    private String jndiName;
    private Object underlyingTransaction;
    private TransactionControl transactionControl;

    public Neo4jXAResourceImpl(TransactionControl transactionControl, String jndiName, String productName, String productVersion) {
        this.transactionControl = transactionControl;
        this.jndiName = jndiName;
        this.productName = productName;
        this.productVersion = productVersion;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (trace) {
            NoSQLLogger.ROOT_LOGGER.tracef("start(%s, %s)", (Object)xid, (Object)flags);
        }
        if (this.currentXid != null && flags == 0) {
            throw new LocalXAException("Trying to start a new transaction when old is not complete: Old: " + this.currentXid + ", New " + xid + ", Flags " + flags, -6);
        }
        if (this.currentXid == null && flags != 0) {
            throw new LocalXAException("Trying to start a new transaction with wrong flags: New " + xid + ", Flags " + flags, -6);
        }
        if (this.currentXid == null) {
            try {
                this.underlyingTransaction = this.transactionControl.beginTransaction();
            }
            catch (Throwable t) {
                throw new LocalXAException("Throwable trying to start local transaction", -3, t);
            }
            this.currentXid = xid;
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (!xid.equals(this.currentXid)) {
            throw new XAException(-6);
        }
        this.currentXid = null;
        try {
            this.transactionControl.success();
        }
        finally {
            this.transactionControl.close();
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (!xid.equals(this.currentXid)) {
            throw new XAException(-6);
        }
        this.currentXid = null;
        try {
            this.transactionControl.failure();
        }
        finally {
            this.transactionControl.close();
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (trace) {
            NoSQLLogger.ROOT_LOGGER.tracef("end(%s,%s)", (Object)xid, (Object)flags);
        }
    }

    public void forget(Xid xid) throws XAException {
        throw new XAException(-3);
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource == this;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        throw new XAException(-3);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public XAResource getResource() {
        return this;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getJndiName() {
        return this.jndiName;
    }
}

