/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.subsystem.neo4j;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

enum Namespace {
    UNKNOWN(null),
    NEO4J_1_0("urn:jboss:domain:neo4jdriver:1.0");

    private final String name;
    public static final EnumSet<Namespace> STANDARD_NAMESPACES;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        STANDARD_NAMESPACES = EnumSet.complementOf(EnumSet.of(UNKNOWN));
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

